/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.None$;
import scala.Option;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t%c\u0001\u0002\u0015*\u00019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"Ia\t\u0001B\u0001B\u0003%qI\u0013\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011%\u0004!\u0011!Q\u0001\n)D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\to\u0002\u0011\t\u0011)A\u0005q\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001\"CA\u0010\u0001\t\u0007I\u0011BA\u0011\u0011\u001d\t\u0019\u0003\u0001Q\u0001\n\tC\u0011\"!\n\u0001\u0005\u0004%I!a\n\t\u000f\u0005%\u0002\u0001)A\u0005[\"Q\u00111\u0006\u0001C\u0002\u0013\u0005\u0011&!\f\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003_A\u0011\"!\u0012\u0001\u0005\u0004%\t&a\u0012\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u0013Bq!!\u0015\u0001\t#\n\u0019\u0006C\u0004\u0002\\\u0001!\t&!\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0015\u0002j!9\u0011Q\u000e\u0001\u0005R\u0005=\u0004bBA@\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\ti\t\u0001C!\u0003\u000bCq!a$\u0001\t\u0003\n\t\nC\u0004\u0002<\u0002!\t\"!0\t\u0011\u0005\u0015\b\u0001\"\u0001*\u0003\u000bCq!a:\u0001\t\u0003\tI\u000fC\u0004\u0002~\u0002!\t%a@\t\u000f\t=\u0001\u0001\"\u0015\u0003\u0012!i!\u0011\u0004\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003\u001c);\u0011B!\b*\u0003\u0003E\tAa\b\u0007\u0011!J\u0013\u0011!E\u0001\u0005CAq!a\u0001%\t\u0003\u0011I\u0003C\u0005\u0003,\u0011\n\n\u0011\"\u0001\u0003.!I!1\t\u0013\u0012\u0002\u0013\u0005!Q\t\u0002\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u000b\u0005)Z\u0013AB:feZ,'OC\u0001-\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0018\u0011\u0005A\nT\"A\u0015\n\u0005IJ#!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\r\u0005\u00026}9\u0011a\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0003s5\na\u0001\u0010:p_Rt$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR\u0014A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!\u0010\u001e\u0002\u0013\u0019,Go\u00195fe&#\u0007CA\"E\u001b\u0005Q\u0014BA#;\u0005\rIe\u000e^\u0001\u0007Y\u0016\fG-\u001a:\u0011\u0005AB\u0015BA%*\u00059aU-\u00193fe\u0016sG\rU8j]RL!AR\u0019\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u0005Aj\u0015B\u0001(*\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u0019R\u0013\t\u0011\u0016F\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\u0011R\r\u001f9p]\u0016tG/[1m\u0005\u0006\u001c7n\u001c4g!\t)v,D\u0001W\u0015\t9\u0006,A\u0003vi&d7O\u0003\u0002Z5\u000611m\\7n_:T!\u0001L.\u000b\u0005qk\u0016AB1qC\u000eDWMC\u0001_\u0003\ry'oZ\u0005\u0003AZ\u0013!#\u0012=q_:,g\u000e^5bY\n\u000b7m[8gM\u0006Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0005A\u001a\u0017B\u00013*\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fQ!];pi\u0006\u0004\"\u0001M4\n\u0005!L#\u0001\u0004*fa2L7-Y)v_R\f\u0017!\u00047pO\u000e{g\u000e^3yi>\u0003H\u000fE\u0002DW6L!\u0001\u001c\u001e\u0003\r=\u0003H/[8o!\t)f.\u0003\u0002p-\nQAj\\4D_:$X\r\u001f;\u0002\u001f\u0015DHO]1NKR\u0014\u0018n\u0019+bON\u0004BA];5i5\t1O\u0003\u0002uu\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\u001c(aA'ba\u00069R.\u001a;bI\u0006$\u0018MV3sg&|gnU;qa2LWM\u001d\t\u0004\u0007f\\\u0018B\u0001>;\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0002}\u007f6\tQP\u0003\u0002Z}*\u0011!FW\u0005\u0004\u0003\u0003i(aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)a\t9!!\u0003\u0002\f\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011Q\u0004\t\u0003a\u0001AQa\r\u0007A\u0002QBQ!\u0011\u0007A\u0002\tCQA\u0012\u0007A\u0002\u001dCQa\u0013\u0007A\u00021CQa\u0014\u0007A\u0002ACQa\u0015\u0007A\u0002QCQ!\u0019\u0007A\u0002\tDQ!\u001a\u0007A\u0002\u0019Dq!\u001b\u0007\u0011\u0002\u0003\u0007!\u000eC\u0004q\u0019A\u0005\t\u0019A9\t\u000b]d\u0001\u0019\u0001=\u0002\u0013I,\u0007\u000f\\5dC&#W#\u0001\"\u0002\u0015I,\u0007\u000f\\5dC&#\u0007%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\u0012!\\\u0001\fY><7i\u001c8uKb$\b%\u0001\u0010qCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5OK^D\u0015n\u001a5XCR,'/\\1sWV\u0011\u0011q\u0006\t\u0007\u0003c\t9$a\u000f\u000e\u0005\u0005M\"bAA\u001bg\u00069Q.\u001e;bE2,\u0017\u0002BA\u001d\u0003g\u0011aAQ;gM\u0016\u0014\b\u0003BA\u001f\u0003\u007fi\u0011\u0001W\u0005\u0004\u0003\u0003B&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001 a\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001d\u0016<\b*[4i/\u0006$XM]7be.\u0004\u0013aH5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fIV\u0011\u0011\u0011\n\t\u0004\u0007\u0006-\u0013bAA'u\t9!i\\8mK\u0006t\u0017\u0001I5t\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195TkB\u0004xN\u001d;fI\u0002\n1\u0002\\1uKN$X\t]8dQR!\u0011QKA,!\r\u00195N\u0011\u0005\b\u00033*\u0002\u0019AA\u001e\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fa\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0002`\u0005\u0015\u0004cA\"\u0002b%\u0019\u00111\r\u001e\u0003\t1{gn\u001a\u0005\b\u000332\u0002\u0019AA\u001e\u00031awnZ#oI>3gm]3u)\u0011\ty&a\u001b\t\u000f\u0005es\u00031\u0001\u0002<\u0005\tRM\u001c3PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195\u0015\r\u0005E\u0014\u0011PA>!\u0011\u00195.a\u001d\u0011\u0007q\f)(C\u0002\u0002xu\u0014ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007\u000eC\u0004\u0002Za\u0001\r!a\u000f\t\r\u0005u\u0004\u00041\u0001C\u0003\u0015)\u0007o\\2i\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e\u0006\u0002\u0002J\u0005i\u0011m^1jiNCW\u000f\u001e3po:$\"!a\"\u0011\u0007\r\u000bI)C\u0002\u0002\fj\u0012A!\u00168ji\u00061Am\\,pe.\fA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003CAJ\u0003S\u000bY+a,\u0011\t\r[\u0017Q\u0013\t\u0005\u0003/\u000b)+\u0004\u0002\u0002\u001a*!\u00111TAO\u0003\rawn\u001a\u0006\u0005\u0003?\u000b\t+A\u0005j]R,'O\\1mg*\u0019\u00111\u0015.\u0002\u000fM$xN]1hK&!\u0011qUAM\u00055aunZ!qa\u0016tG-\u00138g_\"9\u0011\u0011\f\u000fA\u0002\u0005m\u0002bBAW9\u0001\u0007\u0011qL\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u00022r\u0001\r!a-\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\t),a.\u000e\u0003\u0001I1!!/2\u0005%1U\r^2i\t\u0006$\u0018-A\u0011va\u0012\fG/\u001a%jO\"<\u0016\r^3s[\u0006\u00148.\u00118e'R\f'\u000f^(gMN,G\u000f\u0006\u0006\u0002@\u0006\u0005\u0017\u0011[Ao\u0003C\u0004BaQ6\u0002`!9\u00111Y\u000fA\u0002\u0005\u0015\u0017!\u00039beRLG/[8o!\u0011\t9-!4\u000e\u0005\u0005%'bAAfW\u000591\r\\;ti\u0016\u0014\u0018\u0002BAh\u0003\u0013\u0014\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\u0005mU\u00041\u0001\u0002TB!\u0011Q[Am\u001b\t\t9NC\u0002\u0002\u001c.JA!a7\u0002X\nY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\ty.\ba\u0001\u0003?\n1\u0003\\3bI\u0016\u0014\b*[4i/\u0006$XM]7be.Dq!a9\u001e\u0001\u0004\ty,\u0001\u000bmK\u0006$WM\u001d'pON#\u0018M\u001d;PM\u001a\u001cX\r^\u0001\u001dG>l\u0007\u000f\\3uK\u0012+G.Y=fI\u001a+Go\u00195SKF,Xm\u001d;t\u0003mi\u0017-\u001f2f/\u0006\u0014h.\u00134Pm\u0016\u00148/\u001b>fIJ+7m\u001c:egR1\u0011qQAv\u0003wDq!!< \u0001\u0004\ty/A\u0004sK\u000e|'\u000fZ:\u0011\t\u0005E\u0018q_\u0007\u0003\u0003gT1!!>Y\u0003\u0019\u0011XmY8sI&!\u0011\u0011`Az\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011\u0011L\u0010A\u0002\u0005m\u0012\u0001\u0003;sk:\u001c\u0017\r^3\u0015\r\u0005%#\u0011\u0001B\u0003\u0011\u001d\u0011\u0019\u0001\ta\u0001\u0003w\t!\u0001\u001e9\t\u000f\t\u001d\u0001\u00051\u0001\u0003\n\u0005)rN\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0007c\u0001\u0019\u0003\f%\u0019!QB\u0015\u0003+=3gm]3u)J,hnY1uS>t7\u000b^1uK\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003\u000f\u0013\u0019B!\u0006\t\u000f\u0005e\u0013\u00051\u0001\u0002<!9!qC\u0011A\u0002\u0005}\u0013AB8gMN,G/\u0001\u0007tkB,'\u000f\n7fC\u0012,'/F\u0001H\u0003Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bIB\u0011\u0001\u0007J\n\u0004I\t\r\u0002cA\"\u0003&%\u0019!q\u0005\u001e\u0003\r\u0005s\u0017PU3g)\t\u0011y\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u000b\u0003\u0005_Q3A\u001bB\u0019W\t\u0011\u0019\u0004\u0005\u0003\u00036\t}RB\u0001B\u001c\u0015\u0011\u0011IDa\u000f\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001fu\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005#q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005\u000fR3!\u001dB\u0019\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final int replicaId;
    private final LogContext logContext;
    private final Buffer<TopicPartition> partitionsWithNewHighWatermark;
    private final boolean isOffsetForLeaderEpochSupported;

    public static Map<String, String> $lessinit$greater$default$10() {
        return (Map)Map$.MODULE$.empty();
    }

    public static Option<LogContext> $lessinit$greater$default$9() {
        return None$.MODULE$;
    }

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Buffer<TopicPartition> partitionsWithNewHighWatermark() {
        return this.partitionsWithNewHighWatermark;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    public boolean initiateShutdown() {
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.super$leader()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.super$leader()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            return;
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        Option<LogAppendInfo> logAppendInfo = this.replicaMgr.appendRecordsToFollowerReplica(topicPartition, fetchOffset, records, partitionData.highWatermark(), partitionData.logStartOffset(), this.quota, (Function4<Partition, AbstractLog, Object, Option<Object>, Option<Object>>)(Function4 & Serializable)(partition, log, leaderHighWatermark, leaderLogStartOffset) -> this.updateHighWatermarkAndStartOffset(partition, log, BoxesRunTime.unboxToLong((Object)leaderHighWatermark), (Option<Object>)leaderLogStartOffset));
        if (records.sizeInBytes() > 0) {
            this.brokerTopicStats().topicStats(topicPartition.topic()).totalFollowerFetchRequestRate().mark();
            this.brokerTopicStats().allTopicsStats().totalFollowerFetchRequestRate().mark();
        }
        return logAppendInfo;
    }

    public Option<Object> updateHighWatermarkAndStartOffset(Partition partition, AbstractLog log, long leaderHighWatermark, Option<Object> leaderLogStartOffset) {
        Option<Object> followerHighWatermark = log.maybeUpdateHighWatermark(leaderHighWatermark);
        leaderLogStartOffset.foreach((Function1)(JFunction1.mcZJ.sp & Serializable)offset -> log.maybeIncrementLogStartOffset(offset, LogStartOffsetIncrementReason.LeaderOffsetIncremented));
        followerHighWatermark.foreach((Function1 & Serializable)x$1 -> ReplicaFetcherThread.$anonfun$updateHighWatermarkAndStartOffset$2(this, partition, BoxesRunTime.unboxToLong((Object)x$1)));
        return followerHighWatermark;
    }

    public void completeDelayedFetchRequests() {
        if (this.partitionsWithNewHighWatermark().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests((Seq<TopicPartition>)this.partitionsWithNewHighWatermark().toSeq());
            this.partitionsWithNewHighWatermark().clear();
            return;
        }
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (((MetadataVersion)this.metadataVersionSupplier.apply()).fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
            return;
        }
    }

    @Override
    public boolean truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        if (offsetTruncationState.offset() < log.highWatermark()) {
            if (!partition.isUncleanLeader()) {
                if (partition.isActiveLinkDestinationLeader()) {
                    this.replicaMgr.clusterLinkTruncationBelowHWM().mark();
                } else {
                    this.replicaMgr.truncationBelowHWM().mark();
                }
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, false);
    }

    public static final /* synthetic */ Buffer $anonfun$updateHighWatermarkAndStartOffset$2(ReplicaFetcherThread $this, Partition partition$1, long x$1) {
        return (Buffer)$this.partitionsWithNewHighWatermark().$plus$eq((Object)partition$1.topicPartition());
    }

    public ReplicaFetcherThread(String name, int fetcherId, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, Option<LogContext> logContextOpt, Map<String, String> extraMetricTags, Function0<MetadataVersion> metadataVersionSupplier) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(name, name, leader, failedPartitions, exponentialBackoff, new ConfluentReplicaFetcherTierStateMachine(leader, replicaMgr, exponentialBackoff), false, replicaMgr.brokerTopicStats(), extraMetricTags);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = (LogContext)logContextOpt.getOrElse((Function0 & Serializable)() -> new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(this.super$leader().brokerEndPoint().id()).append(", fetcherId=").append($this.fetcherId).append("] ").toString()));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.partitionsWithNewHighWatermark = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.isOffsetForLeaderEpochSupported = ((MetadataVersion)metadataVersionSupplier.apply()).isOffsetForLeaderEpochSupported();
    }
}

