/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterPartitionManager;
import kafka.server.IsrChangePropagationConfig;
import kafka.server.ZkAlterPartitionManager$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%t!B\f\u0019\u0011\u0003ib!B\u0010\u0019\u0011\u0003\u0001\u0003\"B\u0014\u0002\t\u0003A\u0003bB\u0015\u0002\u0001\u0004%\tA\u000b\u0005\b]\u0005\u0001\r\u0011\"\u00010\u0011\u0019)\u0014\u0001)Q\u0005W\u0019!q\u0004\u0007\u0001;\u0011!!eA!A!\u0002\u0013)\u0005\u0002C)\u0007\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011e3!\u0011!Q\u0001\niCQa\n\u0004\u0005\u0002\u0001Dq!\u001a\u0004C\u0002\u0013%!\u0006\u0003\u0004g\r\u0001\u0006Ia\u000b\u0005\tO\u001a\u0011\r\u0011\"\u0001\u0019Q\"1QO\u0002Q\u0001\n%DqA\u001e\u0004C\u0002\u0013%q\u000fC\u0004\u0002\b\u0019\u0001\u000b\u0011\u0002=\t\u0011\u0005%aA1A\u0005\n]Dq!a\u0003\u0007A\u0003%\u0001\u0010C\u0004\u0002\u000e\u0019!\t%a\u0004\t\u000f\u0005Ea\u0001\"\u0011\u0002\u0014!A\u00111\n\u0004\u0005\u0002a\ti\u0005\u0003\u0006\u0002R\u0019\t\n\u0011\"\u0001\u0019\u0003'\nqCW6BYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005eQ\u0012AB:feZ,'OC\u0001\u001c\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AH\u0001\u000e\u0003a\u0011qCW6BYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005YB)\u001a4bk2$\u0018j\u001d:Qe>\u0004\u0018mZ1uS>t7i\u001c8gS\u001e,\u0012a\u000b\t\u0003=1J!!\f\r\u00035%\u001b(o\u00115b]\u001e,\u0007K]8qC\u001e\fG/[8o\u0007>tg-[4\u0002?\u0011+g-Y;mi&\u001b(\u000f\u0015:pa\u0006<\u0017\r^5p]\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u00021gA\u0011!%M\u0005\u0003e\r\u0012A!\u00168ji\"9A\u0007BA\u0001\u0002\u0004Y\u0013a\u0001=%c\u0005aB)\u001a4bk2$\u0018j\u001d:Qe>\u0004\u0018mZ1uS>t7i\u001c8gS\u001e\u0004\u0003FA\u00038!\t\u0011\u0003(\u0003\u0002:G\tAao\u001c7bi&dWm\u0005\u0003\u0007Cmr\u0004C\u0001\u0010=\u0013\ti\u0004DA\u000bBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005S\u0012!B;uS2\u001c\u0018BA\"A\u0005\u001daunZ4j]\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005\u0019{U\"A$\u000b\u0005!K\u0015\u0001B;uS2T!!\u0007&\u000b\u0005mY%B\u0001'N\u0003\u0019\t\u0007/Y2iK*\ta*A\u0002pe\u001eL!\u0001U$\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"aU,\u000e\u0003QS!!Q+\u000b\u0005YS\u0015AB2p[6|g.\u0003\u0002Y)\n!A+[7f\u0003!Q8n\u00117jK:$\bCA._\u001b\u0005a&BA/\u001b\u0003\tQ8.\u0003\u0002`9\ni1*\u00194lCj[7\t\\5f]R$B!\u00192dIB\u0011aD\u0002\u0005\u0006\t*\u0001\r!\u0012\u0005\u0006#*\u0001\rA\u0015\u0005\u00063*\u0001\rAW\u0001\u001cSN\u00148\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u0007>tg-[4\u00029%\u001c(o\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]\u000e{gNZ5hA\u0005a\u0011n\u001d:DQ\u0006tw-Z*fiV\t\u0011\u000eE\u0002k_Fl\u0011a\u001b\u0006\u0003Y6\fq!\\;uC\ndWM\u0003\u0002oG\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005A\\'aA*fiB\u0011!o]\u0007\u0002+&\u0011A/\u0016\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u00035I7O]\"iC:<WmU3uA\u0005yA.Y:u\u0013N\u00148\t[1oO\u0016l5/F\u0001y!\rI\u00181A\u0007\u0002u*\u00111\u0010`\u0001\u0007CR|W.[2\u000b\u0005ut\u0018AC2p]\u000e,(O]3oi*\u0011\u0001j \u0006\u0003\u0003\u0003\tAA[1wC&\u0019\u0011Q\u0001>\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\tmCN$\u0018j\u001d:DQ\u0006tw-Z'tA\u0005!B.Y:u\u0013N\u0014\bK]8qC\u001e\fG/[8o\u001bN\fQ\u0003\\1ti&\u001b(\u000f\u0015:pa\u0006<\u0017\r^5p]6\u001b\b%A\u0003ti\u0006\u0014H\u000fF\u00011\u0003\u0019\u0019XOY7jiRQ\u0011QCA\u0015\u0003g\t9$!\u0011\u0011\r\u0005]\u0011\u0011DA\u000f\u001b\u0005a\u0018bAA\u000ey\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t\u001b\u0003\r\t\u0007/[\u0005\u0005\u0003O\t\tC\u0001\u0007MK\u0006$WM]!oI&\u001b(\u000fC\u0004\u0002,Q\u0001\r!!\f\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007c\u0001:\u00020%\u0019\u0011\u0011G+\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBA\u001b)\u0001\u0007\u0011QD\u0001\rY\u0016\fG-\u001a:B]\u0012L5O\u001d\u0005\b\u0003s!\u0002\u0019AA\u001e\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0007c\u0001\u0012\u0002>%\u0019\u0011qH\u0012\u0003\u0007%sG\u000fC\u0004\u0002DQ\u0001\r!!\u0012\u0002)A\u0014x\u000e]1hCR,\u0017*\\7fI&\fG/\u001a7z!\r\u0011\u0013qI\u0005\u0004\u0003\u0013\u001a#a\u0002\"p_2,\u0017M\\\u0001\u0019[\u0006L(-\u001a)s_B\fw-\u0019;f\u0013N\u00148\t[1oO\u0016\u001cHc\u0001\u0019\u0002P!I\u00111I\u000b\u0011\u0002\u0003\u0007\u0011QI\u0001#[\u0006L(-\u001a)s_B\fw-\u0019;f\u0013N\u00148\t[1oO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U#\u0006BA#\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G\u001a\u0013AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ZkAlterPartitionManager
implements AlterPartitionManager,
Logging {
    private final Scheduler scheduler;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final IsrChangePropagationConfig isrChangeNotificationConfig;
    private final scala.collection.mutable.Set<TopicPartition> isrChangeSet;
    private final AtomicLong lastIsrChangeMs;
    private final AtomicLong lastIsrPropagationMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void DefaultIsrPropagationConfig_$eq(IsrChangePropagationConfig x$1) {
        ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig_$eq(x$1);
    }

    public static IsrChangePropagationConfig DefaultIsrPropagationConfig() {
        return ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        AlterPartitionManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private IsrChangePropagationConfig isrChangeNotificationConfig() {
        return this.isrChangeNotificationConfig;
    }

    public scala.collection.mutable.Set<TopicPartition> isrChangeSet() {
        return this.isrChangeSet;
    }

    private AtomicLong lastIsrChangeMs() {
        return this.lastIsrChangeMs;
    }

    private AtomicLong lastIsrPropagationMs() {
        return this.lastIsrPropagationMs;
    }

    @Override
    public void start() {
        this.scheduler.schedule("isr-change-propagation", () -> this.maybePropagateIsrChanges(this.maybePropagateIsrChanges$default$1()), 0L, this.isrChangeNotificationConfig().checkIntervalMs());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<LeaderAndIsr> submit(TopicIdPartition topicIdPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch, boolean propagateImmediately) {
        void var6_6;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Writing new ISR ").append(leaderAndIsr.isr()).append(" to ZooKeeper with version ").append(leaderAndIsr.partitionEpoch()).append(" for partition ").append(topicIdPartition).toString());
        Tuple2<Object, Object> tuple2 = ReplicationUtils$.MODULE$.updateLeaderAndIsr(this.zkClient, topicIdPartition.topicPartition(), leaderAndIsr, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        boolean updateSucceeded = tuple2._1$mcZ$sp();
        int newVersion = tuple2._2$mcI$sp();
        CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
        if (var6_6 != false) {
            void var7_7;
            scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
            synchronized (set) {
                this.isrChangeSet().$plus$eq((Object)topicIdPartition.topicPartition());
                this.lastIsrChangeMs().set(this.time.milliseconds());
                if (propagateImmediately) {
                    this.maybePropagateIsrChanges(true);
                }
            }
            future.complete(leaderAndIsr.withPartitionEpoch((int)var7_7));
        } else {
            future.completeExceptionally((Throwable)new InvalidUpdateVersionException(new StringBuilder(86).append("ISR update ").append(leaderAndIsr).append(" for partition ").append(topicIdPartition).append(" with controller epoch ").append(controllerEpoch).append(" ").append("failed with an invalid version error").toString()));
        }
        return future;
    }

    public void maybePropagateIsrChanges(boolean propagateImmediately) {
        long now = this.time.milliseconds();
        scala.collection.mutable.Set<TopicPartition> set = this.isrChangeSet();
        synchronized (set) {
            if (this.isrChangeSet().nonEmpty() && (propagateImmediately || this.lastIsrChangeMs().get() + this.isrChangeNotificationConfig().lingerMs() < now || this.lastIsrPropagationMs().get() + this.isrChangeNotificationConfig().maxDelayMs() < now)) {
                this.zkClient.propagateIsrChanges((Set<TopicPartition>)this.isrChangeSet());
                this.isrChangeSet().clear();
                this.lastIsrPropagationMs().set(now);
            }
            return;
        }
    }

    public boolean maybePropagateIsrChanges$default$1() {
        return false;
    }

    public ZkAlterPartitionManager(Scheduler scheduler, Time time, KafkaZkClient zkClient) {
        this.scheduler = scheduler;
        this.time = time;
        this.zkClient = zkClient;
        this.isrChangeNotificationConfig = ZkAlterPartitionManager$.MODULE$.DefaultIsrPropagationConfig();
        this.isrChangeSet = new HashSet();
        this.lastIsrChangeMs = new AtomicLong(time.milliseconds());
        this.lastIsrPropagationMs = new AtomicLong(time.milliseconds());
    }
}

