/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionChecker$;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.FailedLinkReason;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason$;
import kafka.server.link.LinkState;
import kafka.server.link.UnauthorizedBootstrapFailedLinkReason$;
import kafka.server.link.UnavailableLinkReason;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\t\u0013\u0001eA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u0005/\u0001\t\u0005\t\u0015!\u00030k!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001\bC\u0005=\u0001\t\u0005\t\u0015!\u0003:{!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003B\u0011!i\u0005A!b\u0001\n\u0003q\u0005\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u000b\u0001\u0004A\u0011A1\t\u000f)\u0004\u0001\u0019!C\u0005W\"9A\u000e\u0001a\u0001\n\u0013i\u0007BB:\u0001A\u0003&q\u0006C\u0003u\u0001\u0011ES\u000fC\u0003z\u0001\u0011%!P\u0001\u000fDYV\u001cH/\u001a:MS:\\7\t[3dW\u00063\u0018-\u001b7bE&d\u0017\u000e^=\u000b\u0005M!\u0012\u0001\u00027j].T!!\u0006\f\u0002\rM,'O^3s\u0015\u00059\u0012!B6bM.\f7\u0001A\n\u0003\u0001i\u0001\"aG\u0010\u000f\u0005qiR\"\u0001\n\n\u0005y\u0011\u0012\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0002!C\ta\u0001+\u001a:j_\u0012L7\rV1tW*\u0011aDE\u0001\u0007G>tg-[4\u0011\u0005q!\u0013BA\u0013\u0013\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\b[\u0016$(/[2t!\ta\u0002&\u0003\u0002*%\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0011\u0005qa\u0013BA\u0017\u0013\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002\u0015%tG/\u001a:wC2l5\u000f\u0005\u00021g5\t\u0011GC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014GA\u0002J]RL!AN\u0010\u0002#I,7o\u00195fIVdW\rR3mCfl5/A\u0006dYN\u001b\u0007.\u001a3vY\u0016\u0014X#A\u001d\u0011\u0005qQ\u0014BA\u001e\u0013\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006a1\r\\*dQ\u0016$W\u000f\\3sA%\u0011ahH\u0001\ng\u000eDW\rZ;mKJ\f\u0001\u0002\\5oW:\u000bW.Z\u000b\u0002\u0003B\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001R\u0019\u000e\u0003\u0015S!A\u0012\r\u0002\rq\u0012xn\u001c;?\u0013\tA\u0015'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%2\u0003%a\u0017N\\6OC6,\u0007%\u0001\nsK6|G/Z!e[&tg)Y2u_JLX#A(\u0011\u0007A\u0002&+\u0003\u0002Rc\tIa)\u001e8di&|g\u000e\r\t\u0003'vk\u0011\u0001\u0016\u0006\u0003+Z\u000bQ!\u00193nS:T!a\u0016-\u0002\u000f\rd\u0017.\u001a8ug*\u0011q#\u0017\u0006\u00035n\u000ba!\u00199bG\",'\"\u0001/\u0002\u0007=\u0014x-\u0003\u0002_)\nq1i\u001c8gYV,g\u000e^!e[&t\u0017a\u0005:f[>$X-\u00113nS:4\u0015m\u0019;pef\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0005cG\u0012,gm\u001a5j!\ta\u0002\u0001C\u0003#\u0017\u0001\u00071\u0005C\u0003'\u0017\u0001\u0007q\u0005C\u0003+\u0017\u0001\u00071\u0006C\u0003/\u0017\u0001\u0007q\u0006C\u00038\u0017\u0001\u0007\u0011\bC\u0003@\u0017\u0001\u0007\u0011\tC\u0003N\u0017\u0001\u0007q*A\u0005gC&d7i\\;oiV\tq&A\u0007gC&d7i\\;oi~#S-\u001d\u000b\u0003]F\u0004\"\u0001M8\n\u0005A\f$\u0001B+oSRDqA]\u0007\u0002\u0002\u0003\u0007q&A\u0002yIE\n!BZ1jY\u000e{WO\u001c;!\u0003\r\u0011XO\u001c\u000b\u0002mB\u0011\u0001g^\u0005\u0003qF\u0012qAQ8pY\u0016\fg.\u0001\u0007iC:$G.\u001a*fgVdG\u000f\u0006\u0002ww\")A\u0010\u0005a\u0001{\u00069S.Y=cK\u000ecWo\u001d;fe2Kgn[\"p]:,7\r^5p]\u000eCWmY6feJ+7/\u001e7u!\u0011\u0001d0!\u0001\n\u0005}\f$AB(qi&|g\u000eE\u0002\u001d\u0003\u0007I1!!\u0002\u0013\u0005\t\u001aE.^:uKJd\u0015N\\6D_:tWm\u0019;j_:\u001c\u0005.Z2lKJ\u0014Vm];mi\u0002")
public class ClusterLinkCheckAvailability
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkConfig config;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkManager clusterLinkManager;
    private final String linkName;
    private final Function0<ConfluentAdmin> remoteAdminFactory;
    private int failCount;

    public ClusterLinkScheduler clScheduler() {
        return super.scheduler();
    }

    public String linkName() {
        return this.linkName;
    }

    public Function0<ConfluentAdmin> remoteAdminFactory() {
        return this.remoteAdminFactory;
    }

    private int failCount() {
        return this.failCount;
    }

    private void failCount_$eq(int x$1) {
        this.failCount = x$1;
    }

    @Override
    public boolean run() {
        DescribeClusterResult describeClusterResult = ClusterLinkConnectionChecker$.MODULE$.doBasicDescribeCluster((Admin)this.remoteAdminFactory().apply());
        this.scheduleWhenComplete(describeClusterResult.clusterId(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.handleResult(ClusterLinkConnectionChecker$.MODULE$.check(describeClusterResult, $this.config)));
        return false;
    }

    private boolean handleResult(Option<ClusterLinkConnectionCheckerResult> maybeClusterLinkConnectionCheckerResult) {
        String linkName = this.metrics.linkName();
        if (None$.MODULE$.equals(maybeClusterLinkConnectionCheckerResult)) {
            this.failCount_$eq(0);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Link ").append(linkName).append(" availability check succeeded").toString());
            this.clusterLinkManager.reportAvailableLink(linkName);
        } else if (maybeClusterLinkConnectionCheckerResult instanceof Some) {
            ClusterLinkConnectionCheckerResult linkUnavailableResult = (ClusterLinkConnectionCheckerResult)((Some)maybeClusterLinkConnectionCheckerResult).value();
            this.failCount_$eq(this.failCount() + 1);
            this.metrics.linkUnavailableSensor().record();
            UnavailableLinkReason unavailableLinkReason = linkUnavailableResult.unavailableLinkReason();
            if (InvalidBootstrapInternalEndpointUnavailableLinkReason$.MODULE$.equals(unavailableLinkReason)) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Link ").append(linkName).append(" availability check failed with authorization error").toString());
                this.clusterLinkManager.failClusterLink(linkName, linkUnavailableResult.throwable(), (FailedLinkReason)UnauthorizedBootstrapFailedLinkReason$.MODULE$);
            } else {
                LinkState linkState;
                if (this.failCount() >= Predef$.MODULE$.Integer2int(this.config.availabilityCheckConsecutiveFailureThreshold())) {
                    this.clusterLinkManager.reportUnavailableLink(linkName, linkUnavailableResult.throwable(), linkUnavailableResult.unavailableLinkReason());
                }
                LinkState linkState2 = linkState = this.clusterLinkManager.linkState(linkName);
                ActiveClusterLink$ activeClusterLink$ = ActiveClusterLink$.MODULE$;
                if (linkState2 != null && linkState2.equals(activeClusterLink$)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Link ").append(linkName).append(" availability check failed ").append(this.failCount()).append(" times").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> linkUnavailableResult.throwable());
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Link ").append(linkName).append(" availability check in state ").append(linkState).append(" failed ").append(this.failCount()).append(" times with exception ").append(linkUnavailableResult.throwable().getCause()).append(" ").append("and reason code ").append(linkUnavailableResult.unavailableLinkReason()).toString());
                }
            }
        } else {
            throw new MatchError(maybeClusterLinkConnectionCheckerResult);
        }
        return true;
    }

    public ClusterLinkCheckAvailability(ClusterLinkConfig config, ClusterLinkMetrics metrics, ClusterLinkManager clusterLinkManager, int intervalMs, ClusterLinkScheduler clScheduler, String linkName, Function0<ConfluentAdmin> remoteAdminFactory) {
        this.config = config;
        this.metrics = metrics;
        this.clusterLinkManager = clusterLinkManager;
        this.linkName = linkName;
        this.remoteAdminFactory = remoteAdminFactory;
        super(clScheduler, "CheckAvailability", intervalMs);
        this.failCount = 0;
    }
}

