/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg!B\u0014)\u0003\u0003y\u0003\u0002\u0003#\u0001\u0005\u000b\u0007I\u0011A#\t\u00111\u0003!\u0011!Q\u0001\n\u0019C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t#\u0002\u0011)\u0019!C\u0001%\"Aa\f\u0001B\u0001B\u0003%1\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003a\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u000b1\u0004A\u0011A7\t\u000fU\u0004!\u0019!C\tm\"9\u0011Q\u0001\u0001!\u0002\u00139\b\"CA\u0004\u0001\t\u0007I\u0011CA\u0005\u0011!\tY\u0002\u0001Q\u0001\n\u0005-\u0001\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0011%\t\t\u0003\u0001a\u0001\n\u0013\t\u0019\u0003C\u0004\u00020\u0001\u0001\u000b\u0015\u0002(\t\u0015\u0005e\u0002\u00011A\u0005\u0012!\nY\u0004\u0003\u0006\u0002D\u0001\u0001\r\u0011\"\u0005)\u0003\u000bB\u0001\"!\u0013\u0001A\u0003&\u0011Q\b\u0005\n\u0003\u001b\u0002\u0001\u0019!C\t\u0003wA\u0011\"a\u0014\u0001\u0001\u0004%\t\"!\u0015\t\u0011\u0005U\u0003\u0001)Q\u0005\u0003{A\u0011\"!\u0017\u0001\u0005\u0004%\t!a\u0017\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003;Bq!a!\u0001\t\u0003\n)\t\u0003\u0005\u0002\b\u0002!\t\u0005KAE\u0011\u001d\ty\n\u0001C!\u0003CCq!a*\u0001\t\u0003\n)\tC\u0004\u0002*\u0002!\t%a\u000f\t\u000f\u0005-\u0006\u0001\"\u0011\u0002 !9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006bBA\\\u0001\u0011E\u0011Q\u0011\u0005\b\u0003s\u0003A\u0011CAC\u0011\u001d\tY\f\u0001D\t\u0003\u000bCq!!0\u0001\r#\t)\tC\u0004\u0002@\u0002!\t\"!\"\t\u000f\u0005\u0005\u0007\u0001\"\u0011\u0002<!9\u00111\u0019\u0001\u0005B\u0005\u0015'\u0001H\"mkN$XM\u001d'j].\u001cuN\u001c8fGRLwN\\'b]\u0006<WM\u001d\u0006\u0003S)\nA\u0001\\5oW*\u00111\u0006L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001aYr\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g\r\u0005\u00028w9\u0011\u0001(O\u0007\u0002Q%\u0011!\bK\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002={\t\t2i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005iB\u0003CA C\u001b\u0005\u0001%BA!-\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0005IA\u0004M_\u001e<\u0017N\\4\u0002\u00111Lgn\u001b#bi\u0006,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u00132\n!A_6\n\u0005-C%aD\"mkN$XM\u001d'j].$\u0015\r^1\u0002\u00131Lgn\u001b#bi\u0006\u0004\u0013!D5oSRL\u0017\r\\\"p]\u001aLw\r\u0005\u00029\u001f&\u0011\u0001\u000b\u000b\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017a\u00057pG\u0006dGj\\4jG\u0006d7\t\\;ti\u0016\u0014X#A*\u0011\u0005Q[fBA+Z!\t1&'D\u0001X\u0015\tAf&\u0001\u0004=e>|GOP\u0005\u00035J\na\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!LM\u0001\u0015Y>\u001c\u0017\r\u001c'pO&\u001c\u0017\r\\\"mkN$XM\u001d\u0011\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\"\u0001O1\n\u0005\tD#AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018aB7fiJL7m\u001d\t\u0003q\u0015L!A\u001a\u0015\u0003%\rcWo\u001d;fe2Kgn['fiJL7m]\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003S*l\u0011AK\u0005\u0003W*\u00121bS1gW\u0006\u001cuN\u001c4jO\u00061A(\u001b8jiz\"rA\\8qcJ\u001cH\u000f\u0005\u00029\u0001!)A)\u0003a\u0001\r\")Q*\u0003a\u0001\u001d\")\u0011+\u0003a\u0001'\")q,\u0003a\u0001A\")1-\u0003a\u0001I\")q-\u0003a\u0001Q\u00061A.\u001b8l\u0013\u0012,\u0012a\u001e\t\u0004q\u0006\u0005Q\"A=\u000b\u0005i\\\u0018AB2p[6|gN\u0003\u0002.y*\u0011QP`\u0001\u0007CB\f7\r[3\u000b\u0003}\f1a\u001c:h\u0013\r\t\u0019!\u001f\u0002\u0005+VLG-A\u0004mS:\\\u0017\n\u001a\u0011\u0002\u001fM$\u0018\r^3DQ\u0006tw-\u001a'pG.,\"!a\u0003\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005!A.\u00198h\u0015\t\t)\"\u0001\u0003kCZ\f\u0017\u0002BA\r\u0003\u001f\u0011aa\u00142kK\u000e$\u0018\u0001E:uCR,7\t[1oO\u0016dunY6!\u0003E\u0019G.^:uKJd\u0015N\\6D_:4\u0017nZ\u000b\u0002\u001d\u0006)2\r\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4`I\u0015\fH\u0003BA\u0013\u0003W\u00012!MA\u0014\u0013\r\tIC\r\u0002\u0005+:LG\u000f\u0003\u0005\u0002.=\t\t\u00111\u0001O\u0003\rAH%M\u0001\u0013G2,8\u000f^3s\u0019&t7nQ8oM&<\u0007\u0005K\u0002\u0011\u0003g\u00012!MA\u001b\u0013\r\t9D\r\u0002\tm>d\u0017\r^5mK\u0006A\"/\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0016\u0005\u0005u\u0002cA\u0019\u0002@%\u0019\u0011\u0011\t\u001a\u0003\u000f\t{w\u000e\\3b]\u0006a\"/\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a3`I\u0015\fH\u0003BA\u0013\u0003\u000fB\u0011\"!\f\u0013\u0003\u0003\u0005\r!!\u0010\u00023I,g/\u001a:tK\u000e{gN\\3di&|g.\u00128bE2,G\r\t\u0015\u0004'\u0005M\u0012\u0001C5t\u0003\u000e$\u0018N^3\u0002\u0019%\u001c\u0018i\u0019;jm\u0016|F%Z9\u0015\t\u0005\u0015\u00121\u000b\u0005\n\u0003[)\u0012\u0011!a\u0001\u0003{\t\u0011\"[:BGRLg/\u001a\u0011)\u0007Y\t\u0019$A\u0006nCbdun\u001a'fm\u0016dWCAA/!\u0019\ty&!\u001c\u0002r5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003O\nI'\u0001\u0006d_:\u001cWO\u001d:f]RTA!a\u001b\u0002\u0014\u0005!Q\u000f^5m\u0013\u0011\ty'!\u0019\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004B!a\u001d\u0002~5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0003fm\u0016tGOC\u0002\u0002|y\fQa\u001d7gi)LA!a \u0002v\t)A*\u001a<fY\u0006aQ.\u0019=M_\u001edUM^3mA\u000591\u000f^1siV\u0004HCAA\u0013\u0003-\u0011XmY8oM&<WO]3\u0015\r\u0005\u0015\u00121RAH\u0011\u0019\tiI\u0007a\u0001\u001d\u0006Ia.Z<D_:4\u0017n\u001a\u0005\b\u0003#S\u0002\u0019AAJ\u0003-)\b\u000fZ1uK\u0012\\U-_:\u0011\u000b\u0005U\u00151T*\u000e\u0005\u0005]%bAAMe\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0015q\u0013\u0002\u0004'\u0016$\u0018\u0001F8o\u0003Z\f\u0017\u000e\\1cS2LG/_\"iC:<W\r\u0006\u0003\u0002&\u0005\r\u0006bBAS7\u0001\u0007\u0011QH\u0001\fSN\fe/Y5mC\ndW-\u0001\u0005tQV$Hm\\<o\u0003\u0019\t7\r^5wK\u0006i1-\u001e:sK:$8i\u001c8gS\u001e\fA\u0002\\5oW\u000ecWo\u001d;feN,\"!!-\u0011\u000b\u0005U\u00151W*\n\t\u0005U\u0016q\u0013\u0002\u0004'\u0016\f\u0018aH3ogV\u0014XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8og\u0016s\u0017M\u00197fI\u0006Y\"/Z:fiJ+g/\u001a:tK\u000e{gN\\3di&|g.\u00113nS:\fAd\u0019:fCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8BI6Lg.A\u000edY>\u001cXMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8o\u0003\u0012l\u0017N\\\u0001\u0016kB$\u0017\r^3BGRLg/\u001a'j].\u001cu.\u001e8u\u0003EI7\u000fT5oW\u000e{wN\u001d3j]\u0006$xN]\u0001\u0012Y&t7nQ8pe\u0012Lg.\u0019;pe&#WCAAd!\u0015\t\u0014\u0011ZAg\u0013\r\tYM\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007E\ny-C\u0002\u0002RJ\u00121!\u00138u\u0001")
public abstract class ClusterLinkConnectionManager
implements ClusterLinkFactory.ConnectionManager,
Logging {
    private final ClusterLinkData linkData;
    private final String localLogicalCluster;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkMetrics metrics;
    private final KafkaConfig brokerConfig;
    private final Uuid linkId;
    private final Object stateChangeLock;
    private volatile ClusterLinkConfig clusterLinkConfig;
    private volatile boolean reverseConnectionEnabled;
    private volatile boolean isActive;
    private final AtomicReference<Level> maxLogLevel;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void onControllerChange(boolean isActive) {
        ClusterLinkFactory.ConnectionManager.onControllerChange$(this, isActive);
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        ClusterLinkFactory.ConnectionManager.onLinkMetadataPartitionLeaderChange$(this);
    }

    @Override
    public int persistentConnectionCount() {
        return ClusterLinkFactory.ConnectionManager.persistentConnectionCount$(this);
    }

    @Override
    public int reverseConnectionCount() {
        return ClusterLinkFactory.ConnectionManager.reverseConnectionCount$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public ClusterLinkData linkData() {
        return this.linkData;
    }

    @Override
    public String localLogicalCluster() {
        return this.localLogicalCluster;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    public Object stateChangeLock() {
        return this.stateChangeLock;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return this.clusterLinkConfig;
    }

    private void clusterLinkConfig_$eq(ClusterLinkConfig x$1) {
        this.clusterLinkConfig = x$1;
    }

    public boolean reverseConnectionEnabled() {
        return this.reverseConnectionEnabled;
    }

    public void reverseConnectionEnabled_$eq(boolean x$1) {
        this.reverseConnectionEnabled = x$1;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    public AtomicReference<Level> maxLogLevel() {
        return this.maxLogLevel;
    }

    @Override
    public void startup() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Cluster link connection manager has started up.");
            if (!Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
                this.isActive_$eq(true);
                this.updateActiveLinkCount();
            } else {
                this.isActive_$eq(false);
            }
            this.resetReverseConnectionAdmin();
            return;
        }
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Reconfiguring link connection manager with new configs updated=").append(updatedKeys).append(" newConfig=").append(newConfig.values()).toString());
            this.clusterLinkConfig_$eq(newConfig);
            if (Predef$.MODULE$.Boolean2boolean(newConfig.clusterLinkPaused())) {
                if (this.isActive()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down cluster link connection manager because link has been paused");
                }
                this.shutdown();
            } else {
                this.isActive_$eq(true);
                this.resetReverseConnectionAdmin();
            }
            this.updateActiveLinkCount();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed reconfiguration of cluster link");
            return;
        }
    }

    @Override
    public void onAvailabilityChange(boolean isAvailable) {
        if (isAvailable) {
            this.maxLogLevel().set(null);
            return;
        }
        this.maxLogLevel().set(Level.DEBUG);
    }

    @Override
    public void shutdown() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            this.isActive_$eq(false);
            this.closeReverseConnectionAdmin();
            this.updateActiveLinkCount();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("Shutdown of ClusterLinkConnectionManager with cluster link data ").append(this.linkData()).toString());
            return;
        }
    }

    @Override
    public boolean active() {
        return this.isActive();
    }

    @Override
    public ClusterLinkConfig currentConfig() {
        return this.clusterLinkConfig();
    }

    @Override
    public Seq<String> linkClusters() {
        return (Seq)new .colon.colon((Object)this.localLogicalCluster(), (List)Nil$.MODULE$).$plus$plus((IterableOnce)Option$.MODULE$.option2Iterable(this.linkData().clusterId()).toSeq());
    }

    public void ensureReverseConnectionsEnabled() {
        if (!this.isActive() || Predef$.MODULE$.Boolean2boolean(this.clusterLinkConfig().clusterLinkPaused())) {
            throw new ClusterLinkPausedException(new StringBuilder(36).append("Cluster link ").append(this.linkData().linkName()).append(" is not active,").append(" paused=").append(this.clusterLinkConfig().clusterLinkPaused()).toString());
        }
        if (!this.reverseConnectionEnabled()) {
            throw new InvalidRequestException(new StringBuilder(46).append("Cluster link '").append(this.linkData().linkName()).append("' is not a source initiated link").toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void resetReverseConnectionAdmin() {
        var1_1 = this.stateChangeLock();
        synchronized (var1_1) {
            block8: {
                config = this.currentConfig();
                if (!this.isActive() || Predef$.MODULE$.Boolean2boolean(config.clusterLinkPaused())) ** GOTO lbl-1000
                if (!config.linkMode().mayActAsDestination()) break block8;
                v0 = config.connectionMode();
                var3_3 = ConnectionMode$Inbound$.MODULE$;
                if (v0 != null && v0.equals(var3_3)) ** GOTO lbl-1000
            }
            if (config.linkMode().mayActAsSource()) {
                v1 = config.remoteLinkConnectionMode();
                var4_4 = ConnectionMode$Inbound$.MODULE$;
                ** if (v1 == null || !v1.equals((Object)var4_4)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v2 = true;
                ** GOTO lbl19
            }
lbl-1000:
            // 3 sources

            {
                v2 = false;
            }
lbl19:
            // 2 sources

            this.reverseConnectionEnabled_$eq(v2);
            this.closeReverseConnectionAdmin();
            if (this.reverseConnectionEnabled()) {
                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resetReverseConnectionAdmin$1(kafka.server.link.ClusterLinkConnectionManager ), ()Ljava/lang/String;)((ClusterLinkConnectionManager)this));
                this.createReverseConnectionAdmin();
            } else {
                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$resetReverseConnectionAdmin$2(kafka.server.link.ClusterLinkConfig ), ()Ljava/lang/String;)((ClusterLinkConfig)config));
            }
            return;
        }
    }

    public abstract void createReverseConnectionAdmin();

    public abstract void closeReverseConnectionAdmin();

    public void updateActiveLinkCount() {
        int count = this.isActive() ? 1 : 0;
        Option$.MODULE$.apply((Object)this.metrics.activeLinkCountSensor()).foreach((Function1 & Serializable)x$1 -> {
            x$1.record((double)count);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isLinkCoordinator() {
        return this.metadataManager.isLinkCoordinator(this.linkData().linkName());
    }

    @Override
    public Option<Object> linkCoordinatorId() {
        return this.metadataManager.linkCoordinator(this.linkData().linkName(), this.brokerConfig.interBrokerListenerName()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()));
    }

    public static final /* synthetic */ String $anonfun$resetReverseConnectionAdmin$1(ClusterLinkConnectionManager $this) {
        return new StringBuilder(63).append("Recreating reverse connection clients reverseConnectionEnabled=").append($this.reverseConnectionEnabled()).toString();
    }

    public static final /* synthetic */ String $anonfun$resetReverseConnectionAdmin$2(ClusterLinkConfig config$1) {
        return new StringBuilder(82).append("Not creating reverse connection clients with linkMode=").append(config$1.linkMode()).append(", connMode=").append(config$1.connectionMode()).append(", remoteConnMode=").append(config$1.remoteLinkConnectionMode()).toString();
    }

    public ClusterLinkConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, ClusterLinkMetadataManager metadataManager, ClusterLinkMetrics metrics, KafkaConfig brokerConfig) {
        this.linkData = linkData;
        this.localLogicalCluster = localLogicalCluster;
        this.metadataManager = metadataManager;
        this.metrics = metrics;
        this.brokerConfig = brokerConfig;
        this.linkId = new Uuid(linkData.linkId().getMostSignificantBits(), linkData.linkId().getLeastSignificantBits());
        this.stateChangeLock = new Object();
        this.clusterLinkConfig = initialConfig;
        this.reverseConnectionEnabled = false;
        this.isActive = true;
        this.maxLogLevel = new AtomicReference();
    }
}

