/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFailed;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkStopMirrorTopic;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.LocalClusterLinkAdminClient;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.Uuid;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001\u0002\n\u0014\u0001iA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)\u0001\b\u0001C\u0001s!)Q\b\u0001C\u0001}!9!\t\u0001a\u0001\n\u0013q\u0004bB\"\u0001\u0001\u0004%I\u0001\u0012\u0005\u0007\u0015\u0002\u0001\u000b\u0015B \t\u000f=\u0003\u0001\u0019!C\u0005!\"9A\f\u0001a\u0001\n\u0013i\u0006BB0\u0001A\u0003&\u0011\u000bC\u0003a\u0001\u0011\u0005\u0011\rC\u0003c\u0001\u0011\u0005\u0011\rC\u0003d\u0001\u0011\u0005C\rC\u0003x\u0001\u0011\u0005\u0003\u0010C\u0004\u0002\u0004\u0001!I!!\u0002\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\"!H\"mkN$XM\u001d'j].\u001cuN\u001c;s_2dWM\u001d'jgR,g.\u001a:\u000b\u0005Q)\u0012\u0001\u00027j].T!AF\f\u0002\rM,'O^3s\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0005\u0001m\t\u0013\u0006\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u0019r!a\t\u0013\u000e\u0003MI!!J\n\u0002%\rcWo\u001d;fe2Kgn\u001b$bGR|'/_\u0005\u0003O!\u0012QdQ8oiJ|G\u000e\\3s\u0019&t7.\u001a3U_BL7\rT5ti\u0016tWM\u001d\u0006\u0003KM\u0001\"AK\u0017\u000e\u0003-R!\u0001L\f\u0002\u000bU$\u0018\u000e\\:\n\u00059Z#a\u0002'pO\u001eLgnZ\u0001\b[\u0006t\u0017mZ3s!\t\u0019\u0013'\u0003\u00023'\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u00031\u0011'o\\6fe\u000e{gNZ5h!\t)d'D\u0001\u0016\u0013\t9TCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u0002;wq\u0002\"a\t\u0001\t\u000b=\u001a\u0001\u0019\u0001\u0019\t\u000bM\u001a\u0001\u0019\u0001\u001b\u00021%\u001cH*\u001b8l\u0007>|'\u000fZ5oCR|'/\u00128bE2,G-F\u0001@!\ta\u0002)\u0003\u0002B;\t9!i\\8mK\u0006t\u0017aC5oSRL\u0017\r\\5{K\u0012\fq\"\u001b8ji&\fG.\u001b>fI~#S-\u001d\u000b\u0003\u000b\"\u0003\"\u0001\b$\n\u0005\u001dk\"\u0001B+oSRDq!\u0013\u0004\u0002\u0002\u0003\u0007q(A\u0002yIE\nA\"\u001b8ji&\fG.\u001b>fI\u0002B#a\u0002'\u0011\u0005qi\u0015B\u0001(\u001e\u0005!1x\u000e\\1uS2,\u0017aC:uCJ$X\u000f],pe.,\u0012!\u0015\t\u0004%^KV\"A*\u000b\u0005Q+\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003-v\t!bY8mY\u0016\u001cG/[8o\u0013\tA6K\u0001\u0004Ck\u001a4WM\u001d\t\u00049i+\u0015BA.\u001e\u0005%1UO\\2uS>t\u0007'A\bti\u0006\u0014H/\u001e9X_J\\w\fJ3r)\t)e\fC\u0004J\u0013\u0005\u0005\t\u0019A)\u0002\u0019M$\u0018M\u001d;va^{'o\u001b\u0011\u0002\u000fM$\u0018M\u001d;vaR\tQ)\u0001\u0005tQV$Hm\\<o\u0003-ygn\u0015;bi\u0016Le.\u001b;\u0015\u0007\u0015+'\u000fC\u0003g\u001b\u0001\u0007q-A\u0003u_BL7\r\u0005\u0002i_:\u0011\u0011.\u001c\t\u0003Uvi\u0011a\u001b\u0006\u0003Yf\ta\u0001\u0010:p_Rt\u0014B\u00018\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001/\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059l\u0002\"B:\u000e\u0001\u0004!\u0018!B:uCR,\u0007CA\u0012v\u0013\t18CA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\u0002\u001b=t7\u000b^1uK\u000eC\u0017M\\4f)\u0011)\u0015P_@\t\u000b\u0019t\u0001\u0019A4\t\u000bmt\u0001\u0019\u0001?\u0002\u0011=dGm\u0015;bi\u0016\u00042\u0001H?u\u0013\tqXD\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003\u0003q\u0001\u0019\u0001?\u0002\u00119,wo\u0015;bi\u0016\f\u0001#[:QK:$\u0017N\\4Ti>\u0004\b/\u001a3\u0015\u0007}\n9\u0001C\u0003t\u001f\u0001\u0007A/\u0001\fsk:\u001cFo\u001c9NSJ\u0014xN\u001d+pa&\u001cG+Y:l)\u0015)\u0015QBA\b\u0011\u00151\u0007\u00031\u0001h\u0011\u001d\t\t\u0002\u0005a\u0001\u0003'\ta\u0001\\5oW&#\u0007\u0003BA\u000b\u0003Ki!!a\u0006\u000b\t\u0005e\u00111D\u0001\u0007G>lWn\u001c8\u000b\u0007a\tiB\u0003\u0003\u0002 \u0005\u0005\u0012AB1qC\u000eDWM\u0003\u0002\u0002$\u0005\u0019qN]4\n\t\u0005\u001d\u0012q\u0003\u0002\u0005+VLG-\u0001\u0005nCf\u0014WMU;o)\r)\u0015Q\u0006\u0005\u0007\u0003_\t\u0002\u0019A-\u0002\t]|'o\u001b")
public class ClusterLinkControllerListener
implements ClusterLinkFactory.ControllerLinkedTopicListener,
Logging {
    private final ClusterLinkManager manager;
    private final KafkaConfig brokerConfig;
    private volatile boolean initialized;
    private Buffer<Function0<BoxedUnit>> startupWork;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isLinkCoordinatorEnabled() {
        return this.brokerConfig.interBrokerProtocolVersion().isLinkCoordinatorSupported() && Predef$.MODULE$.Boolean2boolean(this.brokerConfig.clusterLinkMetadataTopicEnable());
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private Buffer<Function0<BoxedUnit>> startupWork() {
        return this.startupWork;
    }

    private void startupWork_$eq(Buffer<Function0<BoxedUnit>> x$1) {
        this.startupWork = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public void startup() {
        Buffer buffer;
        synchronized (this) {
            Buffer buffer2;
            if (this.initialized()) {
                buffer2 = (Buffer)Buffer$.MODULE$.empty();
            } else {
                void var2_1;
                this.initialized_$eq(true);
                Buffer<Function0<BoxedUnit>> tmp = this.startupWork();
                this.startupWork_$eq(null);
                buffer2 = var2_1;
            }
            buffer = buffer2;
        }
        buffer.foreach((Function1 & Serializable)x$1 -> {
            x$1.apply$mcV$sp();
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this.initialized_$eq(false);
    }

    @Override
    public void onStateInit(String topic, ClusterLinkTopicState state) {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("See controller cluster link topic state initialization for '").append(topic).append("': ").append(state).toString());
        this.onStateChange(topic, (Option<ClusterLinkTopicState>)None$.MODULE$, (Option<ClusterLinkTopicState>)new Some((Object)state));
    }

    @Override
    public void onStateChange(String topic, Option<ClusterLinkTopicState> oldState, Option<ClusterLinkTopicState> newState) {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Handle controller cluster link topic state init or change  for '").append(topic).append("': ").append(oldState).append(" -> ").append(newState).toString());
        if (oldState.forall((Function1 & Serializable)os -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkControllerListener.$anonfun$onStateChange$2(this, os))) && newState.exists((Function1 & Serializable)ns -> BoxesRunTime.boxToBoolean((boolean)this.isPendingStopped(ns)))) {
            this.runStopMirrorTopicTask(topic, ((ClusterLinkTopicState)newState.get()).linkId());
        }
        if (!this.isLinkCoordinatorEnabled()) {
            newState.map((Function1 & Serializable)x$2 -> x$2.linkId()).orElse((Function0 & Serializable)() -> oldState.map((Function1 & Serializable)x$3 -> x$3.linkId())).flatMap((Function1 & Serializable)linkId -> $this.manager.clientManager((Uuid)linkId)).foreach((Function1 & Serializable)x0$1 -> {
                ClusterLinkControllerListener.$anonfun$onStateChange$8(topic, newState, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean isPendingStopped(ClusterLinkTopicState state) {
        return state instanceof ClusterLinkTopicState.PendingStoppedMirror;
    }

    private void runStopMirrorTopicTask(String topic, Uuid linkId) {
        if (this.isLinkCoordinatorEnabled()) {
            return;
        }
        Option<ClusterLinkFactory.ClientManager> option = this.manager.clientManager(linkId);
        if (option instanceof Some) {
            ClusterLinkFactory.ClientManager clientManager = (ClusterLinkFactory.ClientManager)((Some)option).value();
            if (clientManager instanceof ClusterLinkDestClientManager) {
                boolean bl;
                ClusterLinkDestClientManager clusterLinkDestClientManager = (ClusterLinkDestClientManager)clientManager;
                ConfluentAdmin destAdmin = (ConfluentAdmin)clusterLinkDestClientManager.destAdminFactory().apply();
                ClusterLinkStopMirrorTopic task = new ClusterLinkStopMirrorTopic(topic, clusterLinkDestClientManager, (Function0<ConfluentAdmin>)(Function0 & Serializable)() -> destAdmin, new LocalClusterLinkAdminClient(destAdmin), 500);
                JFunction0.mcV.sp & Serializable maybeRun_work = (JFunction0.mcV.sp & Serializable)() -> task.startup();
                if (this.initialized()) {
                    bl = true;
                } else {
                    synchronized (this) {
                        boolean bl2;
                        if (this.initialized()) {
                            bl2 = true;
                        } else {
                            Option$.MODULE$.apply(this.startupWork()).foreach(arg_0 -> ClusterLinkControllerListener.$anonfun$maybeRun$1((Function0)maybeRun_work, arg_0));
                            bl2 = false;
                        }
                        boolean bl3 = bl2;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 9, 11, 12] lbl23 : MonitorExitStatement: MONITOREXIT : this
                        bl = bl3;
                    }
                }
                if (bl) {
                    task.startup();
                }
                return;
            }
            if (clientManager instanceof ClusterLinkFailed.ClientManager) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Cannot start 'stop topic mirror' task, cluster link '").append(linkId).append("' is in a failed state").toString());
                return;
            }
            throw new IllegalStateException(new StringBuilder(28).append("Unhandled link manager type ").append(clientManager).toString());
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(89).append("Unable to resolve client manager for link ID '").append(linkId).append("', may be due to cluster link deletion race").toString());
            return;
        }
        throw new MatchError(option);
    }

    private void maybeRun(Function0<BoxedUnit> work) {
        boolean bl;
        if (this.initialized()) {
            bl = true;
        } else {
            synchronized (this) {
                boolean bl2;
                if (this.initialized()) {
                    bl2 = true;
                } else {
                    Option$.MODULE$.apply(this.startupWork()).foreach((Function1 & Serializable)x$4 -> (Buffer)x$4.$plus$eq((Object)work));
                    bl2 = false;
                }
                boolean bl3 = bl2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl12 : MonitorExitStatement: MONITOREXIT : this
                bl = bl3;
            }
        }
        if (bl) {
            work.apply$mcV$sp();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$onStateChange$2(ClusterLinkControllerListener $this, ClusterLinkTopicState os) {
        return !(os instanceof ClusterLinkTopicState.PendingStoppedMirror);
    }

    public static final /* synthetic */ void $anonfun$onStateChange$8(String topic$2, Option newState$1, ClusterLinkFactory.ClientManager x0$1) {
        if (x0$1 instanceof ClusterLinkDestClientManager) {
            ((ClusterLinkDestClientManager)x0$1).clusterLinkClearMirrorStartOffsets().processMirrorStateChange(topic$2, (Option<ClusterLinkTopicState>)newState$1);
            return;
        }
    }

    public ClusterLinkControllerListener(ClusterLinkManager manager, KafkaConfig brokerConfig) {
        this.manager = manager;
        this.brokerConfig = brokerConfig;
        this.initialized = false;
        this.startupWork = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

