/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.cluster.PartitionStatus;
import kafka.security.authorizer.AclAuthorizer;
import kafka.server.KafkaConfig;
import kafka.server.link.AbstractClusterLinkClientManager;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkAutoMirroring;
import kafka.server.link.ClusterLinkClearMirrorStartOffsets;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkListOffsets;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkPauseMirrorTopics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.ClusterLinkSyncOffsets;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.LocalClusterLinkAdminClient;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rmg\u0001\u0002#F\u00011C\u0011B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u00182\t\u0011\r\u0004!\u0011!Q\u0001\n\u0011D\u0011\u0002\u001b\u0001\u0003\u0002\u0003\u0006I![8\t\u0011A\u0004!\u0011!Q\u0001\nED\u0011\u0002\u001e\u0001\u0003\u0002\u0003\u0006I!\u001e=\t\u0011e\u0004!\u0011!Q\u0001\niD\u0001\" \u0001\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003?\u0001!Q1A\u0005\u0002\u0005\u0005\u0002BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002$!a\u00111\u0007\u0001\u0003\u0002\u0003\u0006I!!\u000e\u0002<!a\u0011q\b\u0001\u0003\u0002\u0003\u0006I!!\u0011\u0002N!Q\u0011q\n\u0001\u0003\u0006\u0004%\t!!\u0015\t\u0015\u0005%\u0004A!A!\u0002\u0013\t\u0019\u0006\u0003\u0006\u0002l\u0001\u0011)\u0019!C\u0001\u0003[B!\"!\u001e\u0001\u0005\u0003\u0005\u000b\u0011BA8\u0011\u001d\t9\b\u0001C\u0001\u0003sB\u0011\"!&\u0001\u0001\u0004%I!a&\t\u0013\u0005\u0005\u0006\u00011A\u0005\n\u0005\r\u0006\u0002CAX\u0001\u0001\u0006K!!'\t\u0013\u0005E\u0006\u00011A\u0005\n\u0005M\u0006\"CA_\u0001\u0001\u0007I\u0011BA`\u0011!\t\u0019\r\u0001Q!\n\u0005U\u0006\"CAc\u0001\u0001\u0007I\u0011BAd\u0011%\t\t\u000e\u0001a\u0001\n\u0013\t\u0019\u000e\u0003\u0005\u0002X\u0002\u0001\u000b\u0015BAe\u0011%\tI\u000e\u0001a\u0001\n\u0013\tY\u000eC\u0005\u0002f\u0002\u0001\r\u0011\"\u0003\u0002h\"A\u00111\u001e\u0001!B\u0013\ti\u000eC\u0005\u0002n\u0002\u0001\r\u0011\"\u0003\u0002p\"I\u0011\u0011 \u0001A\u0002\u0013%\u00111 \u0005\t\u0003\u007f\u0004\u0001\u0015)\u0003\u0002r\"Q!\u0011\u0001\u0001C\u0002\u0013\u0005QIa\u0001\t\u0011\t-\u0001\u0001)A\u0005\u0005\u000bA\u0011B!\u0004\u0001\u0005\u0004%IAa\u0004\t\u0011\t]\u0001\u0001)A\u0005\u0005#A\u0011B!\u0007\u0001\u0005\u0004%IAa\u0007\t\u0011\t\r\u0003\u0001)A\u0005\u0005;AqA!\u0012\u0001\t#\u00129\u0005C\u0004\u0003J\u0001!\tAa\u0013\t\u000f\te\u0003\u0001\"\u0001\u0003\\!9!q\f\u0001\u0005\u0002\t\u0005\u0004b\u0002B2\u0001\u0011\u0005!\u0011\r\u0005\b\u0005K\u0002A\u0011\u000bB$\u0011\u001d\u00119\u0007\u0001C)\u0005\u000fBqA!\u001b\u0001\t#\u00129\u0005\u0003\u0005\u0003l\u0001!\t!\u0012B7\u0011!\u00119\b\u0001C\u0001\u000b\ne\u0004b\u0002B?\u0001\u0011\u0005!q\u0010\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u000fCqA!#\u0001\t\u0003\t9\nC\u0004\u0003\f\u0002!\tA!$\t\u000f\tE\u0006\u0001\"\u0001\u00034\"9!1\u001a\u0001\u0005\n\t5\u0007bBB\u000f\u0001\u0011%1q\u0004\u0005\b\u0005\u0017\u0004A\u0011BB%\u0011\u001d\u0019Y\u0006\u0001C\u0005\u0007;Bqa!\u001f\u0001\t\u0003\u0019Y\bC\u0004\u0004\u0016\u0002!Iaa&\t\u000f\r\u0005\u0006\u0001\"\u0011\u0003H!911\u0015\u0001\u0005\u0002\r\u0015\u0006bBBZ\u0001\u0011\u00051Q\u0017\u0005\b\u0007{\u0003A\u0011AB`\u0011\u001d\u00199\r\u0001C\u0005\u0007\u0013Dqaa2\u0001\t\u0013\u0019i\rC\u0004\u00024\u0001!\ta!6\t\u001b\r]\u0007\u0001%A\u0002\u0002\u0003%Ia!7p\u0005q\u0019E.^:uKJd\u0015N\\6EKN$8\t\\5f]Rl\u0015M\\1hKJT!AR$\u0002\t1Lgn\u001b\u0006\u0003\u0011&\u000baa]3sm\u0016\u0014(\"\u0001&\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!T)Y!\tqu*D\u0001F\u0013\t\u0001VI\u0001\u0011BEN$(/Y2u\u00072,8\u000f^3s\u0019&t7n\u00117jK:$X*\u00198bO\u0016\u0014\bC\u0001*V\u001d\tq5+\u0003\u0002U\u000b\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\t1vKA\tEKN$8\t\\5f]Rl\u0015M\\1hKJT!\u0001V#\u0011\u0005ecV\"\u0001.\u000b\u0005mK\u0015!B;uS2\u001c\u0018BA/[\u0005\u001daunZ4j]\u001e\f!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feB\u0011a\nY\u0005\u0003C\u0016\u0013!c\u00117vgR,'\u000fT5oW6\u000bg.Y4fe&\u0011alT\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003K\u001al\u0011aR\u0005\u0003O\u001e\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006AA.\u001b8l\t\u0006$\u0018\r\u0005\u0002k[6\t1N\u0003\u0002m\u0013\u0006\u0011!p[\u0005\u0003].\u0014qb\u00117vgR,'\u000fT5oW\u0012\u000bG/Y\u0005\u0003Q>\u000baBZ3uG\",'/T1oC\u001e,'\u000f\u0005\u0002Oe&\u00111/\u0012\u0002\u001a\u00072,8\u000f^3s\u0019&t7NR3uG\",'/T1oC\u001e,'/A\u0005tG\",G-\u001e7feB\u0011aJ^\u0005\u0003o\u0016\u0013Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018B\u0001;P\u00035Ig.\u001b;jC2\u001cuN\u001c4jOB\u0011aj_\u0005\u0003y\u0016\u0013\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003)\tW\u000f\u001e5pe&TXM\u001d\t\u0006\u007f\u0006\u0015\u0011\u0011B\u0007\u0003\u0003\u0003Q!!a\u0001\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u00111D\u0007\u0003\u0003\u001bQ1!`A\b\u0015\rA\u0015\u0011\u0003\u0006\u0004\u0015\u0006M!\u0002BA\u000b\u0003/\ta!\u00199bG\",'BAA\r\u0003\ry'oZ\u0005\u0005\u0003;\tiA\u0001\u0006BkRDwN]5{KJ\f\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\t\t\u0019\u0003E\u0003\u0000\u0003\u000b\t)\u0003\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\u0011\tY#a\u0004\u0002\rA|G.[2z\u0013\u0011\ty#!\u000b\u0003#\u0005cG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u00170\u0001\nbYR,'oQ8oM&<\u0007k\u001c7jGf\u0004\u0013aB7fiJL7m\u001d\t\u0004\u001d\u0006]\u0012bAA\u001d\u000b\n\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0013\r\tidT\u0001\fY&t7.T3ue&\u001c7/\u0001\tmS:\\\u0017\tZ7j]\u001a\u000b7\r^8ssB1q0a\u0011{\u0003\u000fJA!!\u0012\u0002\u0002\tIa)\u001e8di&|g.\r\t\u0004\u001d\u0006%\u0013bAA&\u000b\n12\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\"mS\u0016tG/C\u0002\u0002@=\u000b\u0001\u0003Z3ti\u0006#W.\u001b8GC\u000e$xN]=\u0016\u0005\u0005M\u0003#B@\u0002V\u0005e\u0013\u0002BA,\u0003\u0003\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005)\u0011\rZ7j]*!\u00111MA\t\u0003\u001d\u0019G.[3oiNLA!a\u001a\u0002^\tq1i\u001c8gYV,g\u000e^!e[&t\u0017!\u00053fgR\fE-\\5o\r\u0006\u001cGo\u001c:zA\u0005Y\u0012m\u00197CS:$\u0017N\\4GS2$XM\u001d+sC:\u001chm\u001c:nKJ,\"!a\u001c\u0011\u00079\u000b\t(C\u0002\u0002t\u0015\u00131$Q2m\u0005&tG-\u001b8h\r&dG/\u001a:Ue\u0006t7OZ8s[\u0016\u0014\u0018\u0001H1dY\nKg\u000eZ5oO\u001aKG\u000e^3s)J\fgn\u001d4pe6,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u00155\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u00151RAG\u0003\u001f\u000b\t*a%\u0011\u00059\u0003\u0001\"\u00020\u0011\u0001\u0004y\u0006\"B2\u0011\u0001\u0004!\u0007\"\u00025\u0011\u0001\u0004I\u0007\"\u00029\u0011\u0001\u0004\t\b\"\u0002;\u0011\u0001\u0004)\b\"B=\u0011\u0001\u0004Q\b\"B?\u0011\u0001\u0004q\bbBA\u0010!\u0001\u0007\u00111\u0005\u0005\b\u0003g\u0001\u0002\u0019AA\u001b\u0011\u001d\ty\u0004\u0005a\u0001\u0003\u0003Bq!a\u0014\u0011\u0001\u0004\t\u0019\u0006C\u0004\u0002lA\u0001\r!a\u001c\u0002'\rdWo\u001d;fe2Kgn[*z]\u000e\f5\r\\:\u0016\u0005\u0005e\u0005#B@\u0002\u0006\u0005m\u0005c\u0001(\u0002\u001e&\u0019\u0011qT#\u0003'\rcWo\u001d;fe2Kgn[*z]\u000e\f5\r\\:\u0002/\rdWo\u001d;fe2Kgn[*z]\u000e\f5\r\\:`I\u0015\fH\u0003BAS\u0003W\u00032a`AT\u0013\u0011\tI+!\u0001\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003[\u0013\u0012\u0011!a\u0001\u00033\u000b1\u0001\u001f\u00132\u0003Q\u0019G.^:uKJd\u0015N\\6Ts:\u001c\u0017i\u00197tA\u000512\r\\;ti\u0016\u0014H*\u001b8l'ft7m\u00144gg\u0016$8/\u0006\u0002\u00026B)q0!\u0002\u00028B\u0019a*!/\n\u0007\u0005mVI\u0001\fDYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;t\u0003i\u0019G.^:uKJd\u0015N\\6Ts:\u001cwJ\u001a4tKR\u001cx\fJ3r)\u0011\t)+!1\t\u0013\u00055V#!AA\u0002\u0005U\u0016aF2mkN$XM\u001d'j].\u001c\u0016P\\2PM\u001a\u001cX\r^:!\u0003m\u0019G.^:uKJd\u0015N\\6Ts:\u001cGk\u001c9jG\u000e{gNZ5hgV\u0011\u0011\u0011\u001a\t\u0006\u007f\u0006\u0015\u00111\u001a\t\u0004\u001d\u00065\u0017bAAh\u000b\na2\t\\;ti\u0016\u0014H*\u001b8l'ft7\rV8qS\u000e\u001c8i\u001c8gS\u001e\u001c\u0018aH2mkN$XM\u001d'j].\u001c\u0016P\\2U_BL7mQ8oM&<7o\u0018\u0013fcR!\u0011QUAk\u0011%\ti\u000bGA\u0001\u0002\u0004\tI-\u0001\u000fdYV\u001cH/\u001a:MS:\\7+\u001f8d)>\u0004\u0018nY\"p]\u001aLwm\u001d\u0011\u00021\rdWo\u001d;fe2Kgn[!vi>l\u0015N\u001d:pe&tw-\u0006\u0002\u0002^B)q0!\u0002\u0002`B\u0019a*!9\n\u0007\u0005\rXI\u0001\rDYV\u001cH/\u001a:MS:\\\u0017)\u001e;p\u001b&\u0014(o\u001c:j]\u001e\fAd\u00197vgR,'\u000fT5oW\u0006+Ho\\'jeJ|'/\u001b8h?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0006%\b\"CAW7\u0005\u0005\t\u0019AAo\u0003e\u0019G.^:uKJd\u0015N\\6BkR|W*\u001b:s_JLgn\u001a\u0011\u0002-\rdWo\u001d;fe2Kgn\u001b'jgR|eMZ:fiN,\"!!=\u0011\u000b}\f)!a=\u0011\u00079\u000b)0C\u0002\u0002x\u0016\u0013ac\u00117vgR,'\u000fT5oW2K7\u000f^(gMN,Go]\u0001\u001bG2,8\u000f^3s\u0019&t7\u000eT5ti>3gm]3ug~#S-\u001d\u000b\u0005\u0003K\u000bi\u0010C\u0005\u0002.z\t\t\u00111\u0001\u0002r\u000692\r\\;ti\u0016\u0014H*\u001b8l\u0019&\u001cHo\u00144gg\u0016$8\u000fI\u0001#G2,8\u000f^3s\u0019&t7n\u00117fCJl\u0015N\u001d:peN#\u0018M\u001d;PM\u001a\u001cX\r^:\u0016\u0005\t\u0015\u0001c\u0001(\u0003\b%\u0019!\u0011B#\u0003E\rcWo\u001d;fe2Kgn[\"mK\u0006\u0014X*\u001b:s_J\u001cF/\u0019:u\u001f\u001a47/\u001a;t\u0003\r\u001aG.^:uKJd\u0015N\\6DY\u0016\f'/T5se>\u00148\u000b^1si>3gm]3ug\u0002\nAd\u00197vgR,'\u000fT5oWB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7/\u0006\u0002\u0003\u0012A\u0019aJa\u0005\n\u0007\tUQI\u0001\u000fDYV\u001cH/\u001a:MS:\\\u0007+Y;tK6K'O]8s)>\u0004\u0018nY:\u0002;\rdWo\u001d;fe2Kgn\u001b)bkN,W*\u001b:s_J$v\u000e]5dg\u0002\na\u0001^8qS\u000e\u001cXC\u0001B\u000f!\u0019\u0011yB!\u000b\u0003.5\u0011!\u0011\u0005\u0006\u0005\u0005G\u0011)#A\u0004nkR\f'\r\\3\u000b\t\t\u001d\u0012\u0011A\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0016\u0005C\u00111aU3u!\u0011\u0011yC!\u0010\u000f\t\tE\"\u0011\b\t\u0005\u0005g\t\t!\u0004\u0002\u00036)\u0019!qG&\u0002\rq\u0012xn\u001c;?\u0013\u0011\u0011Y$!\u0001\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011yD!\u0011\u0003\rM#(/\u001b8h\u0015\u0011\u0011Y$!\u0001\u0002\u000fQ|\u0007/[2tA\u000513\u000f^1siV\u0004\u0018\t\u001a3ji&|g.\u00197BGRLg/Z(s\u0013:\f7\r^5wKR\u000b7o[:\u0015\u0005\u0005\u0015\u0016a\u00049p_2LE\r\u0015:j]\u000eL\u0007/\u00197\u0015\t\t5#1\u000b\t\u0004\u007f\n=\u0013\u0002\u0002B)\u0003\u0003\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0003V\u001d\u0002\rAa\u0016\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007#B@\u0002\u0006\t5\u0012a\u0005:fg>,(oY3JIB\u0013\u0018N\\2ja\u0006dG\u0003\u0002B'\u0005;BqA!\u0016)\u0001\u0004\u00119&\u0001\u0011bY2\f5\r\u001c$jYR,'o]+tKJ+7o\\;sG\u0016LEMR8s[\u0006$HC\u0001B'\u0003]\t7\r\u001c$jYR,'oV5uQJ+7o\\;sG\u0016LE-\u0001\u000fti\u0006\u0014H/\u001e9BI\u0012LG/[8oC2\f5\r^5wKR\u000b7o[:\u0002OMDW\u000f\u001e3po:\fE\rZ5uS>t\u0017\r\\!di&4Xm\u0014:J]\u0006\u001cG/\u001b<f)\u0006\u001c8n]\u0001\u001eg\",H\u000fZ8x]\u0006#G-\u001b;j_:\fG.Q2uSZ,G+Y:lg\u0006I\u0011\r\u001a3U_BL7m\u001d\u000b\u0005\u0003K\u0013y\u0007C\u0004\u0003l9\u0002\rA!\u001d\u0011\r\tM$Q\u000fB\u0017\u001b\t\u0011)#\u0003\u0003\u0003,\t\u0015\u0012\u0001\u0004:f[>4X\rV8qS\u000e\u001cH\u0003BAS\u0005wBqAa\u001e0\u0001\u0004\u0011\t(A\u0005hKR$v\u000e]5dgV\u0011!\u0011O\u0001\u001aO\u0016$8\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\"mS\u0016tG/\u0006\u0002\u0002H\u0005iq-\u001a;BkRDwN]5{KJ,\u0012A`\u0001\u000fO\u0016$8+\u001f8d\u0003\u000edG+Y:l\u0003Q1W\r^2i)>\u0004\u0018n\u0019)beRLG/[8ogR1!q\u0012BU\u0005[\u0003bA!%\u0003 \n\rVB\u0001BJ\u0015\u0011\u0011)Ja&\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003\u001a\nm\u0015\u0001B;uS2T!A!(\u0002\t)\fg/Y\u0005\u0005\u0005C\u0013\u0019JA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u00042a BS\u0013\u0011\u00119+!\u0001\u0003\u0007%sG\u000fC\u0004\u0003,R\u0002\rA!\f\u0002\u000bQ|\u0007/[2\t\u000f\t=F\u00071\u0001\u0003$\u0006IA/[7f_V$Xj]\u0001\u000fM\u0016$8\r\u001b+pa&\u001c\u0017J\u001c4p)!\u0011)L!0\u0003@\n\u0005\u0007C\u0002BI\u0005?\u00139\fE\u0002O\u0005sK1Aa/F\u0005Q\u0019E.^:uKJd\u0015N\\6U_BL7-\u00138g_\"9!1V\u001bA\u0002\t5\u0002b\u0002BXk\u0001\u0007!1\u0015\u0005\b\u0005\u0007,\u0004\u0019\u0001Bc\u0003Q\u0019H/\u0019:u\u001f\u001a47/\u001a;Ta\u0016\u001cg+\u00197vKB\u0019qPa2\n\t\t%\u0017\u0011\u0001\u0002\u0005\u0019>tw-A\u000egKR\u001c\u0007\u000eV8qS\u000eLeNZ8IC:$G.\u001a*fgVdGo\u001d\u000b\r\u0003K\u0013yM!5\u0003h\nM8\u0011\u0004\u0005\b\u0005W3\u0004\u0019\u0001B\u0017\u0011\u001d\u0011\u0019N\u000ea\u0001\u0005+\fAbY8oM&<g)\u001e;ve\u0016\u0004bAa6\u0003^\n\u0005XB\u0001Bm\u0015\u0011\u0011Y.!\u0005\u0002\r\r|W.\\8o\u0013\u0011\u0011yN!7\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\u0005\u00037\u0012\u0019/\u0003\u0003\u0003f\u0006u#AB\"p]\u001aLw\rC\u0004\u0003jZ\u0002\rAa;\u0002#\u0011,7o\u0019:jaRLwN\u001c$viV\u0014X\r\u0005\u0004\u0003X\nu'Q\u001e\t\u0005\u00037\u0012y/\u0003\u0003\u0003r\u0006u#\u0001\u0005+pa&\u001cG)Z:de&\u0004H/[8o\u0011\u001d\u0011)P\u000ea\u0001\u0005o\f!c\u001d;beR|eMZ:fiN4U\u000f^;sKB1!\u0011\u0013B}\u0005{LAAa?\u0003\u0014\ny1i\\7qY\u0016$\u0018n\u001c8Ti\u0006<W\r\u0005\u0005\u0003\u0000\u000e\u00051QAB\u0006\u001b\t\u00119*\u0003\u0003\u0004\u0004\t]%aA'baB!!q[B\u0004\u0013\u0011\u0019IA!7\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B!1QBB\n\u001d\u0011\tYfa\u0004\n\t\rE\u0011QL\u0001\u0012\u0019&\u001cHo\u00144gg\u0016$8OU3tk2$\u0018\u0002BB\u000b\u0007/\u0011Q\u0003T5ti>3gm]3ugJ+7/\u001e7u\u0013:4wN\u0003\u0003\u0004\u0012\u0005u\u0003bBB\u000em\u0001\u0007!QW\u0001\u0007e\u0016\u001cX\u000f\u001c;\u000295\f\u0017PY3UQJ|w\u000fV8qS\u000eLeNZ8Fq\u000e,\u0007\u000f^5p]V!1\u0011EB\u0014)!\u0019\u0019c!\u000f\u0004<\r\u0015\u0003\u0003BB\u0013\u0007Oa\u0001\u0001B\u0004\u0004*]\u0012\raa\u000b\u0003\u0003Q\u000bBa!\f\u00044A\u0019qpa\f\n\t\rE\u0012\u0011\u0001\u0002\b\u001d>$\b.\u001b8h!\ry8QG\u0005\u0005\u0007o\t\tAA\u0002B]fDqAa+8\u0001\u0004\u0011i\u0003C\u0004\u0004>]\u0002\raa\u0010\u0002\r\u0019,H/\u001e:f!\u0019\u0011\tj!\u0011\u0004$%!11\tBJ\u0005\u00191U\u000f^;sK\"91qI\u001cA\u0002\t5\u0012AB1di&|g\u000e\u0006\b\u0002&\u000e-3QJB(\u0007#\u001a\u0019f!\u0017\t\u000f\t-\u0006\b1\u0001\u0003.!9!1\u001b\u001dA\u0002\tU\u0007b\u0002Buq\u0001\u0007!1\u001e\u0005\b\u0005kD\u0004\u0019\u0001B|\u0011\u001d\u0019)\u0006\u000fa\u0001\u0007/\n1\u0003\\1uKN$xJ\u001a4tKR\u001ch)\u001e;ve\u0016\u0004bAa6\u0003^\nu\bbBB\u000eq\u0001\u0007!QW\u0001\u001cM\u0016$8\r\u001b+pa&\u001c\u0017J\u001c4p/J\f\u0007/\u0012=dKB$\u0018n\u001c8\u0015\u0011\r}3\u0011OB:\u0007o\u0002Ba!\u0019\u0004l9!11MB4\u001d\u0011\u0011\u0019d!\u001a\n\u0005\u0005\r\u0011\u0002BB5\u0003\u0003\tq\u0001]1dW\u0006<W-\u0003\u0003\u0004n\r=$!\u0003+ie><\u0018M\u00197f\u0015\u0011\u0019I'!\u0001\t\u000f\t-\u0016\b1\u0001\u0003.!91QO\u001dA\u0002\r}\u0013!A3\t\u000f\r\u001d\u0013\b1\u0001\u0003.\u0005i!/\u001a9mS\u000e\f7\u000b^1ukN$Ba! \u0004\u0010BA!1OB@\u0007\u000b\u0019\t)\u0003\u0003\u0004\u0004\t\u0015\u0002C\u0002BI\u0005?\u001b\u0019\t\u0005\u0003\u0004\u0006\u000e-UBABD\u0015\r\u0019I)S\u0001\bG2,8\u000f^3s\u0013\u0011\u0019iia\"\u0003\u001fA\u000b'\u000f^5uS>t7\u000b^1ukNDqa!%;\u0001\u0004\u0019\u0019*\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004bAa\u001d\u0003v\r\u0015\u0011A\u0007;p%\u0016\u001cX\u000f\u001c;NSJ\u0014xN]%oM>\u001cFO]5qa\u0016$G\u0003BBB\u00073Cqaa\u0007<\u0001\u0004\u0019Y\n\u0005\u0003\u0002\\\ru\u0015\u0002BBP\u0003;\u0012q\u0002U1si&$\u0018n\u001c8SKN,H\u000e^\u0001\u001aaJ|7-Z:t\u001b&\u0014(o\u001c:Ti\u0006$Xm\u00115b]\u001e,7/A\u0011sKN$(/[2u-\u0006d\u0017\u000eZ1uKR{\u0007/[2D_:4\u0017n\u001a)pY&\u001c\u0017\u0010\u0006\u0004\u0004(\u000e56q\u0016\t\u0005\u0005\u007f\u001cI+\u0003\u0003\u0004,\n]%A\u0003)s_B,'\u000f^5fg\"9!1V\u001fA\u0002\t5\u0002bBBY{\u0001\u00071qU\u0001\u0006aJ|\u0007o]\u0001\u0015i>\u0004\u0018nY\"p]\u001aLwmU=oGJ+H.Z:\u0015\u0005\r]\u0006c\u0001(\u0004:&\u001911X#\u000355K'O]8s)>\u0004\u0018nY\"p]\u001aLwmU=oGJ+H.Z:\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ,\"a!1\u0011\u00079\u001b\u0019-C\u0002\u0004F\u0016\u0013!d\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006l\u0015M\\1hKJ\fQ#[:TkB\u0004xN\u001d;fI\u0006+H\u000f[8sSj,'\u000f\u0006\u0003\u0003N\r-\u0007BB?A\u0001\u0004\tI\u0001\u0006\u0004\u0003N\r=71\u001b\u0005\b\u0007#\f\u0005\u0019\u0001B\u0017\u0003%\u0019G.Y:t\u001d\u0006lW\r\u0003\u0004~\u0003\u0002\u0007\u0011\u0011\u0002\u000b\u0003\u0003k\tab];qKJ$C.\u001b8l\t\u0006$\u0018-F\u0001j\u0001")
public class ClusterLinkDestClientManager
extends AbstractClusterLinkClientManager
implements ClusterLinkFactory.DestClientManager {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkFetcherManager fetcherManager;
    private final Option<Authorizer> authorizer;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final AclBindingFilterTransformer aclBindingFilterTransformer;
    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls;
    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets;
    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs;
    private Option<ClusterLinkAutoMirroring> clusterLinkAutoMirroring;
    private Option<ClusterLinkListOffsets> clusterLinkListOffsets;
    private final ClusterLinkClearMirrorStartOffsets clusterLinkClearMirrorStartOffsets;
    private final ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics;
    private final scala.collection.mutable.Set<String> topics;

    private /* synthetic */ ClusterLinkData super$linkData() {
        return super.linkData();
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    public AclBindingFilterTransformer aclBindingFilterTransformer() {
        return this.aclBindingFilterTransformer;
    }

    private Option<ClusterLinkSyncAcls> clusterLinkSyncAcls() {
        return this.clusterLinkSyncAcls;
    }

    private void clusterLinkSyncAcls_$eq(Option<ClusterLinkSyncAcls> x$1) {
        this.clusterLinkSyncAcls = x$1;
    }

    private Option<ClusterLinkSyncOffsets> clusterLinkSyncOffsets() {
        return this.clusterLinkSyncOffsets;
    }

    private void clusterLinkSyncOffsets_$eq(Option<ClusterLinkSyncOffsets> x$1) {
        this.clusterLinkSyncOffsets = x$1;
    }

    private Option<ClusterLinkSyncTopicsConfigs> clusterLinkSyncTopicConfigs() {
        return this.clusterLinkSyncTopicConfigs;
    }

    private void clusterLinkSyncTopicConfigs_$eq(Option<ClusterLinkSyncTopicsConfigs> x$1) {
        this.clusterLinkSyncTopicConfigs = x$1;
    }

    private Option<ClusterLinkAutoMirroring> clusterLinkAutoMirroring() {
        return this.clusterLinkAutoMirroring;
    }

    private void clusterLinkAutoMirroring_$eq(Option<ClusterLinkAutoMirroring> x$1) {
        this.clusterLinkAutoMirroring = x$1;
    }

    private Option<ClusterLinkListOffsets> clusterLinkListOffsets() {
        return this.clusterLinkListOffsets;
    }

    private void clusterLinkListOffsets_$eq(Option<ClusterLinkListOffsets> x$1) {
        this.clusterLinkListOffsets = x$1;
    }

    public ClusterLinkClearMirrorStartOffsets clusterLinkClearMirrorStartOffsets() {
        return this.clusterLinkClearMirrorStartOffsets;
    }

    private ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics() {
        return this.clusterLinkPauseMirrorTopics;
    }

    private scala.collection.mutable.Set<String> topics() {
        return this.topics;
    }

    @Override
    public void startupAdditionalActiveOrInactiveTasks() {
        this.clusterLinkClearMirrorStartOffsets().startup();
        this.clusterLinkPauseMirrorTopics().startup();
    }

    public boolean poolIdPrincipal(Option<String> principal) {
        if (principal instanceof Some) {
            return SecurityUtils.parseKafkaPrincipal((String)((String)((Some)principal).value())).getName().startsWith("pool");
        }
        if (None$.MODULE$.equals(principal)) {
            return false;
        }
        throw new MatchError(principal);
    }

    public boolean resourceIdPrincipal(Option<String> principal) {
        if (principal instanceof Some) {
            return !SecurityUtils.parseKafkaPrincipal((String)((String)((Some)principal).value())).getName().matches("[0-9]+");
        }
        if (None$.MODULE$.equals(principal)) {
            return false;
        }
        throw new MatchError(principal);
    }

    public boolean allAclFiltersUseResourceIdFormat() {
        Option<AclFiltersJson> option = this.currentConfig().aclFilters();
        if (option instanceof Some) {
            AclFiltersJson filter = (AclFiltersJson)((Some)option).value();
            scala.collection.immutable.Set filtersFormat = ((IterableOnceOps)((StrictOptimizedIterableOps)AclJson$.MODULE$.toAclBindingFilters(filter).filter((Function1 & Serializable)aclBindingFilter -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkDestClientManager.$anonfun$allAclFiltersUseResourceIdFormat$1(this, aclBindingFilter)))).map((Function1 & Serializable)aclBindingFilter -> BoxesRunTime.boxToBoolean((boolean)this.resourceIdPrincipal((Option<String>)Option$.MODULE$.apply((Object)aclBindingFilter.entryFilter().principal()))))).toSet();
            if (filtersFormat.isEmpty()) {
                return true;
            }
            if (filtersFormat.size() == 1) {
                return BoxesRunTime.unboxToBoolean((Object)filtersFormat.head());
            }
            throw new IllegalArgumentException(new StringBuilder(177).append("If kafka.config.authorizer.resource.id.support.enable flag is enabled, aclFilters in cluster link").append("should contain filters either in old or new format, but got mix of both format. ").append(filter).toString());
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public boolean aclFilterWithResourceId() {
        return Predef$.MODULE$.Boolean2boolean(this.brokerConfig.getBoolean("multitenant.authorizer.support.resource.ids")) && this.allAclFiltersUseResourceIdFormat();
    }

    @Override
    public void startupAdditionalActiveTasks() {
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)new Some((Object)new ClusterLinkSyncOffsets(this, super.clusterLinkManager().metadataManager(), super.linkData(), this.destAdminFactory(), super.linkMetrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncOffsets().get()).startup();
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)new Some((Object)new ClusterLinkSyncTopicsConfigs(this, super.clusterLinkManager().metadataManager(), new LocalClusterLinkAdminClient((ConfluentAdmin)this.destAdminFactory().apply()), Predef$.MODULE$.Integer2int(this.currentConfig().topicConfigSyncMs()), super.linkMetrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncTopicConfigs().get()).startup();
        this.clusterLinkListOffsets_$eq((Option<ClusterLinkListOffsets>)new Some((Object)new ClusterLinkListOffsets(this, this.fetcherManager, Predef$.MODULE$.Integer2int(this.currentConfig().availabilityCheckMs()))));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkListOffsets().get()).startup();
        if (this.currentConfig().aclSyncEnable()) {
            this.authorizer.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            });
            if (!this.authorizer.exists((Function1 & Serializable)authorizer -> BoxesRunTime.boxToBoolean((boolean)this.isSupportedAuthorizer(authorizer)))) {
                throw new IllegalArgumentException(new StringBuilder(125).append("ACL migration is supported only with the built-in ").append("authorizers AclAuthorizer and ConfluentServerAuthorizer. ").append(this.authorizer.get().getClass()).append(" is not supported.").toString());
            }
            this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)new Some((Object)new ClusterLinkSyncAcls(this, super.linkData(), super.clusterLinkManager().metadataManager(), this.destAdminFactory(), super.linkMetrics(), this.aclBindingFilterTransformer(), this.aclFilterWithResourceId())));
            ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkSyncAcls().get()).startup();
        }
        this.clusterLinkAutoMirroring_$eq((Option<ClusterLinkAutoMirroring>)new Some((Object)new ClusterLinkAutoMirroring(this, super.clusterLinkManager().metadataManager(), super.linkData(), this.destAdminFactory(), super.linkMetrics())));
        ((ClusterLinkScheduler.PeriodicTask)this.clusterLinkAutoMirroring().get()).startup();
    }

    @Override
    public void shutdownAdditionalActiveOrInactiveTasks() {
        this.clusterLinkClearMirrorStartOffsets().shutdown();
        this.clusterLinkPauseMirrorTopics().shutdown();
    }

    @Override
    public void shutdownAdditionalActiveTasks() {
        this.clusterLinkSyncTopicConfigs().foreach((Function1 & Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncTopicConfigs_$eq((Option<ClusterLinkSyncTopicsConfigs>)None$.MODULE$);
        this.clusterLinkSyncOffsets().foreach((Function1 & Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncOffsets_$eq((Option<ClusterLinkSyncOffsets>)None$.MODULE$);
        this.clusterLinkSyncAcls().foreach((Function1 & Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkSyncAcls_$eq((Option<ClusterLinkSyncAcls>)None$.MODULE$);
        this.clusterLinkAutoMirroring().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkAutoMirroring_$eq((Option<ClusterLinkAutoMirroring>)None$.MODULE$);
        this.clusterLinkListOffsets().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        this.clusterLinkListOffsets_$eq((Option<ClusterLinkListOffsets>)None$.MODULE$);
    }

    @Override
    public void addTopics(Set<String> addTopics) {
        Object object = this.lock();
        synchronized (object) {
            addTopics.foreach((Function1 & Serializable)topic -> {
                ClusterLinkDestClientManager.$anonfun$addTopics$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void removeTopics(Set<String> removeTopics) {
        Object object = this.lock();
        synchronized (object) {
            removeTopics.foreach((Function1 & Serializable)topic -> {
                ClusterLinkDestClientManager.$anonfun$removeTopics$1(this, topic);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Set<String> getTopics() {
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Set set = this.topics().toSet();
            return set;
        }
    }

    public ClusterLinkAdminClient getClusterLinkAdminClient() {
        Option<ClusterLinkAdminClient> currentAdmin = this.admin();
        if (currentAdmin == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Client manager for cluster link data ").append(super.linkData()).toString());
        }
        return (ClusterLinkAdminClient)currentAdmin.getOrElse((Function0 & Serializable)() -> {
            throw new ClusterLinkPausedException(new StringBuilder(27).append("Cluster link for ").append(this.super$linkData().linkName()).append(" is paused").toString());
        });
    }

    public Option<Authorizer> getAuthorizer() {
        return this.authorizer;
    }

    public Option<ClusterLinkSyncAcls> getSyncAclTask() {
        return this.clusterLinkSyncAcls();
    }

    @Override
    public CompletableFuture<Object> fetchTopicPartitions(String topic, int timeoutMs) {
        CompletableFuture<Object> result = new CompletableFuture<Object>();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            super.scheduler().scheduleWhenComplete("ClusterLinkFetchTopicPartitions", describeTopicsResult.allTopicNames(), () -> result.complete(BoxesRunTime.boxToInteger((int)((TopicDescription)((KafkaFuture)describeTopicsResult.topicNameValues().get(topic)).get()).partitions().size())));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "fetching partitions"));
        }
        return result;
    }

    @Override
    public CompletableFuture<ClusterLinkTopicInfo> fetchTopicInfo(String topic, int timeoutMs, long startOffsetSpecValue) {
        CompletableFuture<ClusterLinkTopicInfo> result = new CompletableFuture<ClusterLinkTopicInfo>();
        try {
            DescribeTopicsOptions describeTopicsOptions = new DescribeTopicsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs)).includeAuthorizedOperations(true);
            DescribeTopicsResult describeTopicsResult = this.getAdmin().describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), describeTopicsOptions);
            OffsetSpec startOffsetSpec = ClusterLinkUtils$.MODULE$.toOffsetSpec(startOffsetSpecValue, this.currentConfig().mirrorStartOffsetSpec());
            CompletableFuture startOffsetsFuture = startOffsetSpec != null && !(startOffsetSpec instanceof OffsetSpec.EarliestSpec) ? ((KafkaFuture)describeTopicsResult.topicNameValues().get(topic)).toCompletionStage().thenCompose(topicDesc -> {
                HashMap reqMap = new HashMap();
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), topicDesc.partitions().size()).foreach((Function1 & Serializable)i -> reqMap.put(new TopicPartition(topic, BoxesRunTime.unboxToInt((Object)i)), startOffsetSpec));
                return this.getAdmin().listOffsets(reqMap).all().toCompletionStage();
            }) : CompletableFuture.completedFuture(Collections.emptyMap());
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            DescribeConfigsOptions describeConfigsOptions = new DescribeConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs));
            DescribeConfigsResult describeConfigsResult = this.getAdmin().describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava(), describeConfigsOptions);
            KafkaFuture futures = KafkaFuture.allOf((KafkaFuture[])new KafkaFuture[]{describeTopicsResult.allTopicNames(), describeConfigsResult.all()});
            super.scheduler().scheduleWhenComplete("FetchTopicInfo", futures, () -> this.fetchTopicInfoHandleResults(topic, (KafkaFuture<Config>)((KafkaFuture)describeConfigsResult.values().get(resource)), (KafkaFuture<TopicDescription>)((KafkaFuture)describeTopicsResult.topicNameValues().get(topic)), startOffsetsFuture, result));
        }
        catch (Throwable e) {
            result.completeExceptionally(this.fetchTopicInfoWrapException(topic, e, "preparing client to fetch information"));
        }
        return result;
    }

    private void fetchTopicInfoHandleResults(String topic, KafkaFuture<Config> configFuture, KafkaFuture<TopicDescription> descriptionFuture, CompletionStage<java.util.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>> startOffsetsFuture, CompletableFuture<ClusterLinkTopicInfo> result) {
        try {
            java.util.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> startOffsets = this.maybeThrowTopicInfoException(topic, startOffsetsFuture.toCompletableFuture(), "fetching start offsets");
            HashMap latestOffsetReqMap = new HashMap();
            startOffsets.entrySet().stream().filter(e -> ((ListOffsetsResult.ListOffsetsResultInfo)e.getValue()).offset() == -1L).forEach(e -> latestOffsetReqMap.put(e.getKey(), new OffsetSpec.LatestSpec()));
            KafkaFuture latestOffsetsFuture = latestOffsetReqMap.isEmpty() ? KafkaFuture.completedFuture(Collections.emptyMap()) : this.getAdmin().listOffsets(latestOffsetReqMap).all();
            super.scheduler().scheduleWhenComplete("FetchTopicInfoLatestOffsets", latestOffsetsFuture, () -> this.fetchTopicInfoHandleResults(topic, configFuture, descriptionFuture, startOffsetsFuture, (KafkaFuture<java.util.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>>)latestOffsetsFuture, result));
            return;
        }
        catch (Throwable e2) {
            result.completeExceptionally(e2);
            return;
        }
    }

    private <T> T maybeThrowTopicInfoException(String topic, Future<T> future, String action) {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            throw this.fetchTopicInfoWrapException(topic, e.getCause(), action);
        }
        catch (Throwable e) {
            throw this.fetchTopicInfoWrapException(topic, e, action);
        }
    }

    private void fetchTopicInfoHandleResults(String topic, KafkaFuture<Config> configFuture, KafkaFuture<TopicDescription> descriptionFuture, CompletionStage<java.util.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>> startOffsetsFuture, KafkaFuture<java.util.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>> latestOffsetsFuture, CompletableFuture<ClusterLinkTopicInfo> result) {
        try {
            TopicDescription description = this.maybeThrowTopicInfoException(topic, (Future)descriptionFuture, "fetching description");
            Config config = this.maybeThrowTopicInfoException(topic, (Future)configFuture, "fetching configuration");
            java.util.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> offsets = this.maybeThrowTopicInfoException(topic, startOffsetsFuture.toCompletableFuture(), "fetching start offsets");
            java.util.Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo> latestOffsets = this.maybeThrowTopicInfoException(topic, (Future)latestOffsetsFuture, "fetching latest offsets");
            Seq startOffsets = offsets.isEmpty() ? (Seq)Seq$.MODULE$.empty() : RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), description.partitions().size()).map((Function1)(JFunction1.mcJI.sp & Serializable)i -> {
                TopicPartition tp = new TopicPartition(topic, i);
                boolean bl = false;
                Some some = null;
                Option option = Option$.MODULE$.apply(offsets.get(tp)).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.offset()));
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    long l = BoxesRunTime.unboxToLong((Object)some.value());
                    if (-1L == l) {
                        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply(latestOffsets.get(tp)).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.offset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                    }
                }
                if (bl) {
                    return BoxesRunTime.unboxToLong((Object)some.value());
                }
                if (None$.MODULE$.equals(option)) {
                    return 0L;
                }
                throw new MatchError((Object)option);
            });
            result.complete(new ClusterLinkTopicInfo(description, config, (Seq<Object>)startOffsets));
            return;
        }
        catch (Throwable e) {
            result.completeExceptionally(e);
            return;
        }
    }

    private Throwable fetchTopicInfoWrapException(String topic, Throwable e, String action) {
        ApiError error = ApiError.fromThrowable((Throwable)e);
        return error.error().exception(new StringBuilder(42).append("While ").append(action).append(" for topic '").append(topic).append("' over cluster link '").append(super.linkData().linkName()).append("': ").append(error.messageWithFallback()).toString());
    }

    @Override
    public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
        ReplicaStatusOptions options = new ReplicaStatusOptions().includeLinkedReplicas(false);
        return CollectionConverters$.MODULE$.MapHasAsScala(this.getAdmin().replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(partitions).asJava(), options).partitionResults()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                CompletableFuture completableFuture = new CompletableFuture();
                future.whenComplete((res, ex) -> {
                    Option option = Option$.MODULE$.apply(ex);
                    if (option instanceof Some) {
                        Throwable e = (Throwable)((Some)option).value();
                        completableFuture.completeExceptionally(e);
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        completableFuture.complete(this.toResultMirrorInfoStripped((PartitionResult)res));
                        return;
                    }
                    throw new MatchError((Object)option);
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), completableFuture);
            }
            throw new MatchError(null);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private PartitionStatus toResultMirrorInfoStripped(PartitionResult result) {
        scala.collection.immutable.Seq replicas = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(result.replicas()).asScala().map((Function1 & Serializable)rs -> new ReplicaStatus(rs.brokerId(), rs.isLeader(), rs.isObserver(), rs.isIsrEligible(), rs.isInIsr(), rs.isCaughtUp(), rs.logStartOffset(), rs.logEndOffset(), rs.lastCaughtUpTimeMs(), rs.lastFetchTimeMs(), Optional.of(this.super$linkData().linkName()), Optional.empty()))).toSeq();
        return new PartitionStatus(result.leaderId(), result.leaderEpoch().getAsInt(), (Seq<ReplicaStatus>)replicas);
    }

    @Override
    public void processMirrorStateChanges() {
        this.clusterLinkClearMirrorStartOffsets().processMirrorStateChanges();
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            AlterConfigPolicy policy = (AlterConfigPolicy)((Some)option).value();
            java.util.Map configs = Utils.propsToStringMap((Properties)props);
            if (policy instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)policy;
                java.util.Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                return Utils.mkProperties(newConfigs);
            }
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            policy.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
            return props;
        }
        if (None$.MODULE$.equals(option)) {
            return props;
        }
        throw new MatchError(option);
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.currentConfig().topicConfigSyncRules();
    }

    public ClusterLinkMetadataManager metadataManager() {
        return super.clusterLinkManager().metadataManager();
    }

    private boolean isSupportedAuthorizer(Authorizer authorizer) {
        if (authorizer instanceof AclAuthorizer) {
            return true;
        }
        if (authorizer instanceof StandardAuthorizer) {
            return true;
        }
        return this.isSupportedAuthorizer("io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer", authorizer);
    }

    private boolean isSupportedAuthorizer(String className, Authorizer authorizer) {
        try {
            return Utils.loadClass((String)className, Authorizer.class).isInstance(authorizer);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public ClusterLinkMetrics metrics() {
        return this.linkMetrics();
    }

    public static final /* synthetic */ boolean $anonfun$allAclFiltersUseResourceIdFormat$1(ClusterLinkDestClientManager $this, AclBindingFilter aclBindingFilter) {
        return !$this.poolIdPrincipal((Option<String>)Option$.MODULE$.apply((Object)aclBindingFilter.entryFilter().principal()));
    }

    public static final /* synthetic */ void $anonfun$addTopics$1(ClusterLinkDestClientManager $this, String topic) {
        if ($this.topics().add((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Added topic '").append(topic).append("' for cluster link data '").append($this.super$linkData()).append("'").toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$removeTopics$1(ClusterLinkDestClientManager $this, String topic) {
        if ($this.topics().remove((Object)topic)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Removed topic '").append(topic).append("' for cluster link data '").append($this.super$linkData()).append("''").toString());
            return;
        }
    }

    public ClusterLinkDestClientManager(ClusterLinkManager clusterLinkManager, KafkaConfig brokerConfig, ClusterLinkData linkData, ClusterLinkFetcherManager fetcherManager, ClusterLinkScheduler scheduler, ClusterLinkConfig initialConfig, Option<Authorizer> authorizer, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkMetrics metrics, Function1<ClusterLinkConfig, ClusterLinkAdminClient> linkAdminFactory, Function0<ConfluentAdmin> destAdminFactory, AclBindingFilterTransformer aclBindingFilterTransformer) {
        this.brokerConfig = brokerConfig;
        this.fetcherManager = fetcherManager;
        this.authorizer = authorizer;
        this.alterConfigPolicy = alterConfigPolicy;
        this.destAdminFactory = destAdminFactory;
        this.aclBindingFilterTransformer = aclBindingFilterTransformer;
        super(clusterLinkManager, linkData, metrics, scheduler, linkAdminFactory, initialConfig);
        this.logIdent_$eq(new StringBuilder(36).append("[ClusterLinkClientManager-").append(super.linkData().linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.clusterLinkSyncAcls = None$.MODULE$;
        this.clusterLinkSyncOffsets = None$.MODULE$;
        this.clusterLinkSyncTopicConfigs = None$.MODULE$;
        this.clusterLinkAutoMirroring = None$.MODULE$;
        this.clusterLinkListOffsets = None$.MODULE$;
        this.clusterLinkClearMirrorStartOffsets = new ClusterLinkClearMirrorStartOffsets(super.linkData(), super.scheduler(), super.clusterLinkManager().metadataManager(), destAdminFactory, 1000, 1000);
        this.clusterLinkPauseMirrorTopics = new ClusterLinkPauseMirrorTopics(super.linkData().linkId(), super.linkData().linkName(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> !this.isActive(), super.scheduler(), super.clusterLinkManager().metadataManager(), destAdminFactory, 20, 5000, 1000);
        this.topics = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }
}

