/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkScheduler;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i3Aa\u0002\u0005\u0001\u001f!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0011%\u0001\u0003A!A!\u0002\u0013\ts\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u00030\u0001\u0011E\u0003\u0007C\u00035\u0001\u0011%QG\u0001\fDYV\u001cH/\u001a:MS:\\G*[:u\u001f\u001a47/\u001a;t\u0015\tI!\"\u0001\u0003mS:\\'BA\u0006\r\u0003\u0019\u0019XM\u001d<fe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0016\u001d\t\u00112#D\u0001\t\u0013\t!\u0002\"\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u0003-]\u0011A\u0002U3sS>$\u0017n\u0019+bg.T!\u0001\u0006\u0005\u0002\u001b\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3s!\t\u0011\"$\u0003\u0002\u001c\u0011\ta2\t\\;ti\u0016\u0014H*\u001b8l\t\u0016\u001cHo\u00117jK:$X*\u00198bO\u0016\u0014\u0018A\u00044fi\u000eDWM]'b]\u0006<WM\u001d\t\u0003%yI!a\b\u0005\u00033\rcWo\u001d;fe2Kgn\u001b$fi\u000eDWM]'b]\u0006<WM]\u0001\u000bS:$XM\u001d<bY6\u001b\bC\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#aA%oi&\u0011\u0001&F\u0001\u0012e\u0016\u001c8\r[3ek2,G)\u001a7bs6\u001b\u0018A\u0002\u001fj]&$h\b\u0006\u0003,Y5r\u0003C\u0001\n\u0001\u0011\u0015AB\u00011\u0001\u001a\u0011\u0015aB\u00011\u0001\u001e\u0011\u0015\u0001C\u00011\u0001\"\u0003\r\u0011XO\u001c\u000b\u0002cA\u0011!EM\u0005\u0003g\r\u0012qAQ8pY\u0016\fg.A\u0007iC:$G.Z(gMN,Go\u001d\u000b\u0003cYBQa\u000e\u0004A\u0002a\naAZ;ukJ,\u0007cA\u001dB\u00076\t!H\u0003\u0002<y\u000511m\\7n_:T!!D\u001f\u000b\u0005yz\u0014AB1qC\u000eDWMC\u0001A\u0003\ry'oZ\u0005\u0003\u0005j\u00121bS1gW\u00064U\u000f^;sKB!A)S&O\u001b\u0005)%B\u0001$H\u0003\u0011)H/\u001b7\u000b\u0003!\u000bAA[1wC&\u0011!*\u0012\u0002\u0004\u001b\u0006\u0004\bCA\u001dM\u0013\ti%H\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005=;fB\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0015\tG-\\5o\u0015\t!F(A\u0004dY&,g\u000e^:\n\u0005Y\u000b\u0016!\u0005'jgR|eMZ:fiN\u0014Vm];mi&\u0011\u0001,\u0017\u0002\u0016\u0019&\u001cHo\u00144gg\u0016$8OU3tk2$\u0018J\u001c4p\u0015\t1\u0016\u000b")
public class ClusterLinkListOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkFetcherManager fetcherManager;

    @Override
    public boolean run() {
        Stream<TopicPartition> waitingPartitions = this.fetcherManager.waitingSourceRecordPartitions();
        HashMap requestPartitions = new HashMap();
        waitingPartitions.forEach(tp -> requestPartitions.put(tp, new OffsetSpec.LatestSpec()));
        if (!requestPartitions.isEmpty()) {
            ListOffsetsResult result = this.clientManager.getAdmin().listOffsets(requestPartitions);
            this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable)() -> this.handleOffsets((KafkaFuture<Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>>)result.all()));
            return false;
        }
        return true;
    }

    private boolean handleOffsets(KafkaFuture<Map<TopicPartition, ListOffsetsResult.ListOffsetsResultInfo>> future) {
        try {
            this.fetcherManager.handleSourceOffsets((Map)future.get());
        }
        catch (Throwable e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Failed to get offsets for topic partitions, request will be retried", (Function0<Throwable>)(Function0 & Serializable)() -> e);
        }
        return true;
    }

    public ClusterLinkListOffsets(ClusterLinkDestClientManager clientManager, ClusterLinkFetcherManager fetcherManager, int intervalMs) {
        this.clientManager = clientManager;
        this.fetcherManager = fetcherManager;
        super(clientManager.scheduler(), "ClusterLinkListOffsets", intervalMs);
    }
}

