/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import kafka.server.KafkaConfig;
import kafka.server.link.MetadataRefreshListener;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.utils.LogContext;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005md\u0001\u0002\r\u001a\u0001\u0001B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\te\u0001\u0011\t\u0011)A\u0005]!A1\u0007\u0001BC\u0002\u0013\u0005A\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u00036\u0011!\u0019\u0005A!b\u0001\n\u0003!\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u00111\u0003!\u0011!Q\u0001\n5C\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005G\")\u0001\u000e\u0001C\u0001S\"9!\u000f\u0001a\u0001\n\u0013\u0019\bb\u0002?\u0001\u0001\u0004%I! \u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003u\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001C\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003\u0002\u001c!A\u0011q\u0004\u0001!B\u0013\ti\u0001C\u0004\u0002*\u0001!\t%a\u000b\t\u0011\u0005M\u0002\u0001\"\u0001\u001a\u0003kAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!A\u0011\u0011\u000f\u0001\u0005\u0002e\t\u0019\bC\u0004\u0002z\u0001!\t!\u0007\u001b\u0003'\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1\u000b\u0005iY\u0012\u0001\u00027j].T!\u0001H\u000f\u0002\rM,'O^3s\u0015\u0005q\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0005\u0002\"A\t\u0016\u000e\u0003\rR!\u0001J\u0013\u0002\u000f\rd\u0017.\u001a8ug*\u0011aD\n\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014x-\u0003\u0002,G\tAQ*\u001a;bI\u0006$\u0018-\u0001\u0007ce>\\WM]\"p]\u001aLw-F\u0001/!\ty\u0003'D\u0001\u001c\u0013\t\t4DA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%\u0001\u0005mS:\\g*Y7f+\u0005)\u0004C\u0001\u001c@\u001d\t9T\b\u0005\u00029w5\t\u0011H\u0003\u0002;?\u00051AH]8pizR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011ahO\u0001\nY&t7NT1nK\u0002\na\u0001\\5oW&#W#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!+\u0013AB2p[6|g.\u0003\u0002K\u000f\n!Q+^5e\u0003\u001da\u0017N\\6JI\u0002\n\u0001\u0002\\5oW6{G-\u001a\t\u0003\u001d~s!a\u0014/\u000f\u0005ASfBA)Y\u001d\t\u0011VK\u0004\u00029'&\tA+\u0001\u0002j_&\u0011akV\u0001\nG>tg\r\\;f]RT\u0011\u0001V\u0005\u0003=eS!AV,\n\u0005iY&B\u0001\u0010Z\u0013\tif,A\tDYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001eT!AG.\n\u0005\u0001\f'\u0001\u0003'j].lu\u000eZ3\u000b\u0005us\u0016\u0001G7fi\u0006$\u0017\r^1SK\u001a\u0014Xm\u001d5CC\u000e\\wN\u001a4NgB\u0011A-Z\u0007\u0002w%\u0011am\u000f\u0002\u0005\u0019>tw-\u0001\tnKR\fG-\u0019;b\u001b\u0006D\u0018iZ3Ng\u00061A(\u001b8jiz\"rA\u001b7n]>\u0004\u0018\u000f\u0005\u0002l\u00015\t\u0011\u0004C\u0003-\u0015\u0001\u0007a\u0006C\u00034\u0015\u0001\u0007Q\u0007C\u0003D\u0015\u0001\u0007Q\tC\u0003M\u0015\u0001\u0007Q\nC\u0003c\u0015\u0001\u00071\rC\u0003h\u0015\u0001\u00071-\u0001\u0007mS:\\W\r\u001a+pa&\u001c7/F\u0001u!\r)(0N\u0007\u0002m*\u0011q\u000f_\u0001\nS6lW\u000f^1cY\u0016T!!_\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002|m\n\u00191+\u001a;\u0002!1Lgn[3e)>\u0004\u0018nY:`I\u0015\fHc\u0001@\u0002\u0004A\u0011Am`\u0005\u0004\u0003\u0003Y$\u0001B+oSRD\u0001\"!\u0002\r\u0003\u0003\u0005\r\u0001^\u0001\u0004q\u0012\n\u0014!\u00047j].,G\rV8qS\u000e\u001c\b%A\fnKR\fG-\u0019;b%\u00164'/Z:i\u0019&\u001cH/\u001a8feV\u0011\u0011Q\u0002\t\u0006I\u0006=\u00111C\u0005\u0004\u0003#Y$AB(qi&|g\u000eE\u0002l\u0003+I1!a\u0006\u001a\u0005]iU\r^1eCR\f'+\u001a4sKNDG*[:uK:,'/A\u000enKR\fG-\u0019;b%\u00164'/Z:i\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u0004}\u0006u\u0001\"CA\u0003\u001f\u0005\u0005\t\u0019AA\u0007\u0003aiW\r^1eCR\f'+\u001a4sKNDG*[:uK:,'\u000f\t\u0015\u0004!\u0005\r\u0002c\u00013\u0002&%\u0019\u0011qE\u001e\u0003\u0011Y|G.\u0019;jY\u0016\fQB]3rk\u0016\u001cH/\u00169eCR,GCAA\u0017!\r!\u0017qF\u0005\u0004\u0003cY$aA%oi\u0006I1/\u001a;U_BL7m\u001d\u000b\u0004}\u0006]\u0002bBA\u001d%\u0001\u0007\u00111H\u0001\u0007i>\u0004\u0018nY:\u0011\tY\ni$N\u0005\u0003w\u0006\u000b\u0011D\\3x\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\n+\u0018\u000e\u001c3feR\u0011\u00111\t\t\u0005\u0003\u000b\n\tF\u0004\u0003\u0002H\u00055SBAA%\u0015\r\tYeR\u0001\te\u0016\fX/Z:ug&!\u0011qJA%\u0003=iU\r^1eCR\f'+Z9vKN$\u0018\u0002BA*\u0003+\u0012qAQ;jY\u0012,'O\u0003\u0003\u0002P\u0005%\u0013a\u0003:fi\u0006Lg\u000eV8qS\u000e$\u0002\"a\u0017\u0002b\u0005\u0015\u0014\u0011\u000e\t\u0004I\u0006u\u0013bAA0w\t9!i\\8mK\u0006t\u0007BBA2)\u0001\u0007Q'A\u0003u_BL7\rC\u0004\u0002hQ\u0001\r!a\u0017\u0002\u0015%\u001c\u0018J\u001c;fe:\fG\u000e\u0003\u0004\u0002lQ\u0001\raY\u0001\u0006]><Xj]\u0001\u0019[\u0006L(-\u001a+ie><h)\u0019;bY\u0016C8-\u001a9uS>tG#\u0001@\u0002%M,GOU3ge\u0016\u001c\b\u000eT5ti\u0016tWM\u001d\u000b\u0004}\u0006U\u0004bBA<-\u0001\u0007\u00111C\u0001\tY&\u001cH/\u001a8fe\u0006yA.\u001b8l\t\u0016\u001c8M]5qi&|g\u000e")
public class ClusterLinkMetadata
extends Metadata {
    private final KafkaConfig brokerConfig;
    private final String linkName;
    private final Uuid linkId;
    private final ClusterLinkConfig.LinkMode linkMode;
    private Set<String> linkedTopics;
    private volatile Option<MetadataRefreshListener> metadataRefreshListener;

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid linkId() {
        return this.linkId;
    }

    private Set<String> linkedTopics() {
        return this.linkedTopics;
    }

    private void linkedTopics_$eq(Set<String> x$1) {
        this.linkedTopics = x$1;
    }

    private Option<MetadataRefreshListener> metadataRefreshListener() {
        return this.metadataRefreshListener;
    }

    private void metadataRefreshListener_$eq(Option<MetadataRefreshListener> x$1) {
        this.metadataRefreshListener = x$1;
    }

    public int requestUpdate() {
        int updateVersion = super.requestUpdate();
        this.metadataRefreshListener().foreach((Function1 & Serializable)x$1 -> {
            x$1.onMetadataRequestUpdate();
            return BoxedUnit.UNIT;
        });
        return updateVersion;
    }

    public void setTopics(Set<String> topics) {
        synchronized (this) {
            this.linkedTopics_$eq(topics);
        }
        this.requestUpdate();
    }

    public synchronized MetadataRequest.Builder newMetadataRequestBuilder() {
        return new MetadataRequest.Builder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.linkedTopics().toList()).asJava(), false);
    }

    public synchronized boolean retainTopic(String topic, boolean isInternal, long nowMs) {
        return this.linkedTopics().contains((Object)topic);
    }

    public void maybeThrowFatalException() {
        super.maybeThrowFatalException();
    }

    public void setRefreshListener(MetadataRefreshListener listener) {
        this.metadataRefreshListener_$eq((Option<MetadataRefreshListener>)new Some((Object)listener));
    }

    public String linkDescription() {
        return new StringBuilder(9).append(this.linkName()).append("-").append(this.linkMode.lowerCaseName()).append("-broker-").append(this.brokerConfig().brokerId()).toString();
    }

    public ClusterLinkMetadata(KafkaConfig brokerConfig, String linkName, Uuid linkId, ClusterLinkConfig.LinkMode linkMode, long metadataRefreshBackoffMs, long metadataMaxAgeMs) {
        this.brokerConfig = brokerConfig;
        this.linkName = linkName;
        this.linkId = linkId;
        this.linkMode = linkMode;
        super(metadataRefreshBackoffMs, metadataMaxAgeMs, new LogContext(new StringBuilder(39).append("[ClusterLinkMetadata brokerId=").append(brokerConfig.brokerId()).append(", link=").append(linkName).append("] ").toString()), new ClusterResourceListeners());
        this.linkedTopics = Predef$.MODULE$.Set().empty();
        this.metadataRefreshListener = None$.MODULE$;
    }
}

