/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.domain.TierRecordType;
import kafka.tier.serdes.MetadataSnapshotUploadComplete;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.OffsetAndEpoch;
import kafka.utils.checksum.Algorithm;

public class TierMetadataSnapshotUploadComplete
extends AbstractTierMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte VERSION_V2 = 2;
    public static final byte VERSION_V3 = 3;
    public static final byte CURRENT_VERSION = 3;
    private static final int INITIAL_BUFFER_SIZE = 96;
    private final TopicIdPartition topicIdPartition;
    protected final MetadataSnapshotUploadComplete metadata;

    public TierMetadataSnapshotUploadComplete(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, OffsetAndEpoch stateOffset, OffsetAndEpoch snapshotOffset, long snapshotTimestampMs, byte checksumAlgorithm) {
        FlatBufferBuilder builder = new FlatBufferBuilder(TierMetadataSnapshotUploadComplete.initialBufferSize()).forceDefaults(false);
        int entryId = TierMetadataSnapshotUploadComplete.buildMetadataSnapshotComplete(builder, tierEpoch, objectId, stateOffset, snapshotOffset, snapshotTimestampMs, checksumAlgorithm);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = MetadataSnapshotUploadComplete.getRootAsMetadataSnapshotUploadComplete(builder.dataBuffer());
    }

    public TierMetadataSnapshotUploadComplete(TopicIdPartition topicIdPartition, MetadataSnapshotUploadComplete metadata) {
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public TierMetadataSnapshotUploadComplete(TierMetadataSnapshotUploadInitiate snapshotInitiate, FileTierPartitionStateSnapshotObject snapshotObject) {
        this(snapshotInitiate.topicIdPartition(), snapshotInitiate.tierEpoch(), snapshotInitiate.messageId(), snapshotInitiate.stateOffsetAndEpoch(), snapshotObject.lastMaterializedEventOffsetAndEpoch(), snapshotObject.snapshotTimestampMs(), snapshotObject.checksumAlgorithm().id);
    }

    static int buildMetadataSnapshotComplete(FlatBufferBuilder builder, int tierEpoch, UUID objectId, OffsetAndEpoch stateOffset, OffsetAndEpoch snapshotOffset, long snapshotTimestampMs, byte checksumAlgorithm) {
        MetadataSnapshotUploadComplete.startMetadataSnapshotUploadComplete(builder);
        MetadataSnapshotUploadComplete.addVersion(builder, (byte)3);
        MetadataSnapshotUploadComplete.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        MetadataSnapshotUploadComplete.addObjectId(builder, objectIdOffset);
        int stateOffsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        MetadataSnapshotUploadComplete.addStateOffsetAndEpoch(builder, stateOffsetAndEpochId);
        int snapshotOffsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, snapshotOffset.offset(), snapshotOffset.epoch().orElse(-1));
        MetadataSnapshotUploadComplete.addSnapshotOffsetAndEpoch(builder, snapshotOffsetAndEpochId);
        MetadataSnapshotUploadComplete.addSnapshotTimestampMs(builder, snapshotTimestampMs);
        MetadataSnapshotUploadComplete.addChecksumAlgorithmId(builder, checksumAlgorithm);
        return MetadataSnapshotUploadComplete.endMetadataSnapshotUploadComplete(builder);
    }

    public static int initialBufferSize() {
        return 96;
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.MetadataSnapshotUploadComplete;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    public OffsetAndEpoch snapshotOffsetAndEpoch() {
        return this.metadata.snapshotOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.metadata.snapshotOffsetAndEpoch());
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        kafka.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public long snapshotTimestampMs() {
        return this.metadata.snapshotTimestampMs();
    }

    public Algorithm checksumAlgorithm() {
        return Algorithm.toAlgorithm(this.metadata.checksumAlgorithmId());
    }

    public byte version() {
        return this.metadata.version();
    }

    public String toString() {
        return "MetadataSnapshotUploadComplete(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", snapshotId=" + this.messageId() + ", messageIdBase64=" + this.messageIdAsBase64() + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", snapshotOffsetAndEpoch=" + this.snapshotOffsetAndEpoch() + ", snapshotTimestampMs=" + this.snapshotTimestampMs() + ", checksum=" + (Object)((Object)this.checksumAlgorithm()) + ")";
    }
}

