/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierUploadType;
import kafka.tier.serdes.OpaqueDataField;
import kafka.tier.serdes.SegmentUploadInitiate;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.TierObjectStore;

public class TierSegmentUploadInitiate
extends AbstractTierSegmentMetadata {
    public static final byte VERSION_V1 = 1;
    public static final byte VERSION_V2 = 2;
    public static final byte CURRENT_VERSION = 2;
    private static final int INITIAL_BUFFER_SIZE = 160;
    private final TopicIdPartition topicIdPartition;
    private final SegmentUploadInitiate metadata;

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long baseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, OffsetAndEpoch stateOffset, TierObjectStore.OpaqueData opaqueData) {
        this(topicIdPartition, tierEpoch, objectId, Optional.empty(), baseOffset, endOffset, maxTimestamp, firstBatchTimestamp, size, hasEpochState, hasAbortedTxns, hasProducerState, uploadType, stateOffset, opaqueData);
    }

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, Optional<UUID> previousObjectId, long baseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, OffsetAndEpoch stateOffset, TierObjectStore.OpaqueData opaqueData) {
        FlatBufferBuilder builder = new FlatBufferBuilder(TierSegmentUploadInitiate.initialBufferSize()).forceDefaults(false);
        int entryId = TierSegmentUploadInitiate.buildSegmentUploadInitiate(builder, tierEpoch, objectId, previousObjectId, baseOffset, endOffset, maxTimestamp, firstBatchTimestamp, size, hasEpochState, hasAbortedTxns, hasProducerState, uploadType, stateOffset, opaqueData);
        builder.finish(entryId);
        this.topicIdPartition = topicIdPartition;
        this.metadata = SegmentUploadInitiate.getRootAsSegmentUploadInitiate(builder.dataBuffer());
    }

    static int buildSegmentUploadInitiate(FlatBufferBuilder builder, int tierEpoch, UUID objectId, Optional<UUID> previousObjectId, long baseOffset, long endOffset, long maxTimestamp, long firstBatchTimestamp, int size, boolean hasEpochState, boolean hasAbortedTxns, boolean hasProducerState, TierUploadType uploadType, OffsetAndEpoch stateOffset, TierObjectStore.OpaqueData opaqueData) {
        SegmentUploadInitiate.startSegmentUploadInitiate(builder);
        SegmentUploadInitiate.addVersion(builder, (byte)2);
        SegmentUploadInitiate.addTierEpoch(builder, tierEpoch);
        int objectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, objectId.getMostSignificantBits(), objectId.getLeastSignificantBits());
        SegmentUploadInitiate.addObjectId(builder, objectIdOffset);
        previousObjectId.ifPresent(uuid -> {
            int previousObjectIdOffset = kafka.tier.serdes.UUID.createUUID(builder, uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
            SegmentUploadInitiate.addPreviousObjectId(builder, previousObjectIdOffset);
        });
        SegmentUploadInitiate.addBaseOffset(builder, baseOffset);
        SegmentUploadInitiate.addEndOffsetDelta(builder, (int)(endOffset - baseOffset));
        SegmentUploadInitiate.addMaxTimestamp(builder, maxTimestamp);
        SegmentUploadInitiate.addSize(builder, size);
        SegmentUploadInitiate.addHasEpochState(builder, hasEpochState);
        SegmentUploadInitiate.addHasAbortedTxns(builder, hasAbortedTxns);
        SegmentUploadInitiate.addHasProducerState(builder, hasProducerState);
        SegmentUploadInitiate.addUploadType(builder, TierUploadType.toByte(uploadType));
        int offsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch(builder, stateOffset.offset(), stateOffset.epoch().orElse(-1));
        SegmentUploadInitiate.addStateOffsetAndEpoch(builder, offsetAndEpochId);
        if (!opaqueData.equals(TierObjectStore.OpaqueData.ZEROED)) {
            long[] arr = opaqueData.intoLongArray();
            int opaqueDataOffset = OpaqueDataField.createOpaqueDataField(builder, arr[0], arr[1], arr[2], arr[3]);
            SegmentUploadInitiate.addOpaqueData(builder, opaqueDataOffset);
        }
        SegmentUploadInitiate.addFirstBatchTimestamp(builder, firstBatchTimestamp);
        return SegmentUploadInitiate.endSegmentUploadInitiate(builder);
    }

    public TierSegmentUploadInitiate(TopicIdPartition topicIdPartition, SegmentUploadInitiate metadata) {
        if (metadata.version() >= 1 && metadata.stateOffsetAndEpoch() == null) {
            throw new IllegalArgumentException(String.format("TierSegmentUploadInitiate version %d must contain a stateOffsetAndEpoch.", metadata.version()));
        }
        this.topicIdPartition = topicIdPartition;
        this.metadata = metadata;
    }

    public static int initialBufferSize() {
        return 160;
    }

    @Override
    public TierObjectMetadata.State state() {
        return TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE;
    }

    public long baseOffset() {
        return this.metadata.baseOffset();
    }

    public long endOffset() {
        return this.metadata.baseOffset() + (long)this.metadata.endOffsetDelta();
    }

    public long maxTimestamp() {
        return this.metadata.maxTimestamp();
    }

    public int size() {
        return this.metadata.size();
    }

    public boolean hasEpochState() {
        return this.metadata.hasEpochState();
    }

    public boolean hasAbortedTxns() {
        return this.metadata.hasAbortedTxns();
    }

    public boolean hasProducerState() {
        return this.metadata.hasProducerState();
    }

    public TierUploadType uploadType() {
        return TierUploadType.fromByte(this.metadata.uploadType());
    }

    public long firstBatchTimestamp() {
        return this.metadata.firstBatchTimestamp();
    }

    @Override
    public TierRecordType type() {
        return TierRecordType.SegmentUploadInitiate;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    @Override
    public int tierEpoch() {
        return this.metadata.tierEpoch();
    }

    @Override
    public OffsetAndEpoch stateOffsetAndEpoch() {
        return this.metadata.stateOffsetAndEpoch() == null ? OffsetAndEpoch.EMPTY : new OffsetAndEpoch(this.metadata.stateOffsetAndEpoch());
    }

    public TierObjectStore.OpaqueData opaqueData() {
        OpaqueDataField opaque = this.metadata.opaqueData();
        if (opaque == null) {
            return TierObjectStore.OpaqueData.ZEROED;
        }
        long[] arr = new long[]{opaque.f0(), opaque.f1(), opaque.f2(), opaque.f3()};
        return TierObjectStore.OpaqueData.fromLongArray(arr);
    }

    public Optional<UUID> previousObjectId() {
        return Optional.ofNullable(this.metadata.previousObjectId()).map(id -> new UUID(id.mostSignificantBits(), id.leastSignificantBits()));
    }

    @Override
    public ByteBuffer payloadBuffer() {
        return this.metadata.getByteBuffer().duplicate();
    }

    @Override
    public UUID messageId() {
        kafka.tier.serdes.UUID objectId = this.metadata.objectId();
        return new UUID(objectId.mostSignificantBits(), objectId.leastSignificantBits());
    }

    public String toString() {
        return "TierSegmentUploadInitiate(version=" + this.metadata.version() + ", topicIdPartition=" + this.topicIdPartition() + ", tierEpoch=" + this.tierEpoch() + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", baseOffset=" + this.baseOffset() + ", endOffset=" + this.endOffset() + ", maxTimestamp=" + this.maxTimestamp() + ", size=" + this.size() + ", hasEpochState=" + this.hasEpochState() + ", hasAbortedTxns=" + this.hasAbortedTxns() + ", hasProducerState=" + this.hasProducerState() + ", uploadType=" + (Object)((Object)this.uploadType()) + ", stateOffsetAndEpoch=" + this.stateOffsetAndEpoch() + ", opaqueData=" + this.opaqueData() + ", firstRecordBatchTimestamp=" + this.firstBatchTimestamp() + ", )";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierSegmentUploadInitiate that = (TierSegmentUploadInitiate)o;
        return Objects.equals(this.topicIdPartition(), that.topicIdPartition()) && Objects.equals(this.metadata.version(), that.metadata.version()) && Objects.equals(this.tierEpoch(), that.tierEpoch()) && Objects.equals(this.objectId(), that.objectId()) && Objects.equals(this.baseOffset(), that.baseOffset()) && Objects.equals(this.endOffset(), that.endOffset()) && Objects.equals(this.maxTimestamp(), that.maxTimestamp()) && Objects.equals(this.size(), that.size()) && Objects.equals(this.hasEpochState(), that.hasEpochState()) && Objects.equals(this.hasAbortedTxns(), that.hasAbortedTxns()) && Objects.equals(this.hasProducerState(), that.hasProducerState()) && Objects.equals((Object)this.uploadType(), (Object)that.uploadType()) && Objects.equals(this.stateOffsetAndEpoch(), that.stateOffsetAndEpoch()) && Objects.equals(this.opaqueData(), that.opaqueData()) && Objects.equals(this.firstBatchTimestamp(), that.firstBatchTimestamp());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata.version(), this.tierEpoch(), this.objectId(), this.baseOffset(), this.endOffset(), this.maxTimestamp(), this.size(), this.hasEpochState(), this.hasAbortedTxns(), this.hasProducerState(), this.uploadType(), this.stateOffsetAndEpoch(), this.opaqueData(), this.firstBatchTimestamp()});
    }
}

