/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import java.util.HashMap;
import java.util.Map;

public enum TierUploadType {
    Archive(0),
    Compaction(1);

    private static final Map<Byte, TierUploadType> ID_TO_TYPE;
    private final byte id;

    private TierUploadType(byte id) {
        this.id = id;
    }

    public static byte toByte(TierUploadType recordType) {
        return recordType.id;
    }

    public static TierUploadType fromByte(byte id) {
        TierUploadType type = ID_TO_TYPE.get(id);
        if (type == null) {
            throw new IllegalArgumentException("Unknown TierUploadType byte id " + id);
        }
        return type;
    }

    static {
        ID_TO_TYPE = new HashMap<Byte, TierUploadType>();
        for (TierUploadType type : TierUploadType.values()) {
            TierUploadType oldType = ID_TO_TYPE.put(type.id, type);
            if (oldType == null) continue;
            throw new ExceptionInInitializerError("id reused for ID_TO_TYPE " + (Object)((Object)oldType) + " and " + (Object)((Object)type));
        }
    }
}

