/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.IOException;
import java.io.InputStream;

public class AutoAbortingGenericInputStream
extends InputStream {
    private final InputStream innerInputStream;
    private final long autoAbortSize;
    private long bytesRead = 0L;
    private long totalBytes;
    private boolean exception = false;

    AutoAbortingGenericInputStream(InputStream innerInputStream, long autoAbortSize, long totalBytes) {
        this.innerInputStream = innerInputStream;
        this.autoAbortSize = autoAbortSize;
        this.totalBytes = totalBytes;
    }

    @Override
    public int read() throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            int read = this.innerInputStream.read();
            if (read > 0) {
                ++this.bytesRead;
            }
            return read;
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            int read = this.innerInputStream.read(b);
            if (read > 0) {
                this.bytesRead += (long)read;
            }
            return read;
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            int read = this.innerInputStream.read(b, off, len);
            if (read > 0) {
                this.bytesRead += (long)read;
            }
            return read;
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }

    long remainingBytes() {
        return this.totalBytes - this.bytesRead;
    }

    public void abort() throws IOException {
        this.innerInputStream.close();
    }

    @Override
    public void close() {
        boolean shouldDrain = !this.exception && this.remainingBytes() < this.autoAbortSize;
        try {
            if (shouldDrain) {
                byte[] skipBuf = new byte[1024];
                while (this.innerInputStream.read(skipBuf, 0, skipBuf.length) > 0) {
                }
                this.innerInputStream.close();
            } else {
                this.abort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int available() throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            return this.innerInputStream.available();
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.exception) {
            throw new IllegalStateException("An exception has already been encountered reading this stream");
        }
        try {
            long skipped = this.innerInputStream.skip(n);
            this.bytesRead += skipped;
            return skipped;
        }
        catch (IOException io) {
            this.exception = true;
            throw io;
        }
    }
}

