/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.time.Instant;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h!\u0002\r\u001a\u0003\u0003\u0001\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u000by\u0002A\u0011A \t\u0011-\u0003\u0001\u0019!C\u000171C\u0001\u0002\u0015\u0001A\u0002\u0013\u00051$\u0015\u0005\u0007/\u0002\u0001\u000b\u0015B'\t\u000fq\u0003\u0001\u0019!C\u0005;\"9q\r\u0001a\u0001\n\u0013A\u0007B\u00026\u0001A\u0003&a\fC\u0004m\u0001\u0001\u0007I\u0011B7\t\u000fm\u0004\u0001\u0019!C\u0005y\"1a\u0010\u0001Q!\n9Dq!!\u0001\u0001\r\u0003\t\u0019\u0001C\u0004\u0002\u000e\u00011\t!a\u0004\t\u000f\u0005u\u0001A\"\u0001\u0002 !1\u0011\u0011\u0014\u0001\u0005\u0002uCq!a'\u0001\t\u0003\ti\n\u0003\u0004\u0002&\u0002!\t!\u001c\u0005\b\u0003O\u0003A\u0011AAU\u0011!\t\u0019\f\u0001C\t3\u0005U\u0006bBAe\u0001\u0011E\u00111\u001a\u0005\t\u0003'\u0004A\u0011C\r\u0002V\"9\u0011\u0011\u001c\u0001\u0005\u0012\u0005m\u0007bBAo\u0001\u0011E\u0011q\u001c\u0002\t)&,'\u000fV1tW*\u0011!dG\u0001\u0006i\u0006\u001c8n\u001d\u0006\u00039u\tA\u0001^5fe*\ta$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0016\u0005\u0005\"5c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0017\u000e\u0003)R!aK\u000f\u0002\u000bU$\u0018\u000e\\:\n\u00055R#a\u0002'pO\u001eLgnZ\u0001\re\u0016$(/\u001f*bi\u0016|\u0005\u000f\u001e\t\u0004GA\u0012\u0014BA\u0019%\u0005\u0019y\u0005\u000f^5p]B\u00111\u0007P\u0007\u0002i)\u0011QGN\u0001\u0005G>\u0014XM\u0003\u00028q\u00059Q.\u001a;sS\u000e\u001c(BA\u001d;\u0003\u0019I\u0018-\\7fe*\t1(A\u0002d_6L!!\u0010\u001b\u0003\u000b5+G/\u001a:\u0002\rqJg.\u001b;?)\t\u0001%\nE\u0002B\u0001\tk\u0011!\u0007\t\u0003\u0007\u0012c\u0001\u0001B\u0003F\u0001\t\u0007aIA\u0001U#\t9\u0005\t\u0005\u0002$\u0011&\u0011\u0011\n\n\u0002\b\u001d>$\b.\u001b8h\u0011\u0015q#\u00011\u00010\u0003)\u0011X\r\u001e:z\u0007>,h\u000e^\u000b\u0002\u001bB\u00111ET\u0005\u0003\u001f\u0012\u00121!\u00138u\u00039\u0011X\r\u001e:z\u0007>,h\u000e^0%KF$\"AU+\u0011\u0005\r\u001a\u0016B\u0001+%\u0005\u0011)f.\u001b;\t\u000fY#\u0011\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010J\u0019\u0002\u0017I,GO]=D_VtG\u000f\t\u0015\u0003\u000be\u0003\"a\t.\n\u0005m##\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0019}\u0003\u0018-^:fIVsG/\u001b7\u0016\u0003y\u00032a\t\u0019`!\t\u0001W-D\u0001b\u0015\t\u00117-\u0001\u0003uS6,'\"\u00013\u0002\t)\fg/Y\u0005\u0003M\u0006\u0014q!\u00138ti\u0006tG/\u0001\t`a\u0006,8/\u001a3V]RLGn\u0018\u0013fcR\u0011!+\u001b\u0005\b-\u001e\t\t\u00111\u0001_\u00035y\u0006/Y;tK\u0012,f\u000e^5mA!\u0012\u0001\"W\u0001\u0007?\u0016\u0014(o\u001c:\u0016\u00039\u00042a\t\u0019p!\t\u0001\bP\u0004\u0002rm:\u0011!/^\u0007\u0002g*\u0011AoH\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!a\u001e\u0013\u0002\u000fA\f7m[1hK&\u0011\u0011P\u001f\u0002\n)\"\u0014xn^1cY\u0016T!a\u001e\u0013\u0002\u0015}+'O]8s?\u0012*\u0017\u000f\u0006\u0002S{\"9aKCA\u0001\u0002\u0004q\u0017aB0feJ|'\u000f\t\u0015\u0003\u0017e\u000b\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003\u0013i\u0011aG\u0005\u0004\u0003\u0017Y\"\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0003\r\u0019G\u000f_\u000b\u0003\u0003#\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/Y\u0012a\u00024fi\u000eDWM]\u0005\u0005\u00037\t)BA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0006ue\u0006t7/\u001b;j_:$b\"!\t\u0002:\u0005M\u00131MA:\u0003\u0007\u000bi\t\u0006\u0003\u0002$\u0005=\u0002#BA\u0013\u0003W\u0011UBAA\u0014\u0015\r\tI\u0003J\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u0017\u0003O\u0011aAR;ukJ,\u0007bBA\u0019\u001d\u0001\u000f\u00111G\u0001\u0003K\u000e\u0004B!!\n\u00026%!\u0011qGA\u0014\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0004c\u001d\u0001\u0007\u00111\b\t\u0005\u0003{\ty%\u0004\u0002\u0002@)\u00191&!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007G>lWn\u001c8\u000b\u0007y\t9E\u0003\u0003\u0002J\u0005-\u0013AB1qC\u000eDWM\u0003\u0002\u0002N\u0005\u0019qN]4\n\t\u0005E\u0013q\b\u0002\u0005)&lW\rC\u0004\u0002V9\u0001\r!a\u0016\u0002#QLWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000f\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tifG\u0001\u0006i>\u0004\u0018nY\u0005\u0005\u0003C\nYFA\tUS\u0016\u0014Hk\u001c9jG\u0006\u0003\b/\u001a8eKJDq!!\u001a\u000f\u0001\u0004\t9'A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA77\u0005)1\u000f^8sK&!\u0011\u0011OA6\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0007bBA;\u001d\u0001\u0007\u0011qO\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\tI(a \u000e\u0005\u0005m$bAA?;\u000511/\u001a:wKJLA!!!\u0002|\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bbBAC\u001d\u0001\u0007\u0011qQ\u0001\u0007G>tg-[4\u0011\u0007\u0005\u000bI)C\u0002\u0002\ff\u0011q\u0002V5feR\u000b7o[:D_:4\u0017n\u001a\u0005\b\u0003\u001fs\u0001\u0019AAI\u0003%!\bN]8ui2,'\u000f\u0005\u0003$a\u0005M\u0005cA\u0015\u0002\u0016&\u0019\u0011q\u0013\u0016\u0003\u0013QC'o\u001c;uY\u0016\u0014\u0018a\u00039bkN,G-\u00168uS2\fA\"[:FeJ|'o\u0015;bi\u0016,\"!a(\u0011\u0007\r\n\t+C\u0002\u0002$\u0012\u0012qAQ8pY\u0016\fg.\u0001\u0006feJ|'o\u0015;bi\u0016\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0002,B!\u0011QVAX\u001b\t\t\t%\u0003\u0003\u00022\u0006\u0005#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000fe\u0016$(/\u001f+bg.d\u0015\r^3s)\u001d\u0011\u0016qWA^\u0003\u000bDa!!/\u0014\u0001\u0004i\u0015!E7bqJ+GO]=CC\u000e\\wN\u001a4Ng\"9\u0011QX\nA\u0002\u0005}\u0016!\u00028po6\u001b\bcA\u0012\u0002B&\u0019\u00111\u0019\u0013\u0003\t1{gn\u001a\u0005\u0007\u0003\u000f\u001c\u0002\u0019A8\u0002\u0003Q\f\u0011\u0002Z3mCf$\u0016m]6\u0015\u000bI\u000bi-!5\t\r\u0005=G\u00031\u0001N\u0003\u001d!W\r\\1z\u001bNDq!!0\u0015\u0001\u0004\ty,\u0001\fdC:\u001cW\r\\!oIN+G/\u0012:s_J\u001cF/\u0019;f)\r\u0011\u0016q\u001b\u0005\u0007\u0003\u000f,\u0002\u0019A8\u0002-=t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:$\u0012AU\u0001 _:\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]^KG\u000f\u001b#fY\u0006LH#\u0002*\u0002b\u0006\r\bbBAh/\u0001\u0007\u0011q\u0018\u0005\b\u0003{;\u0002\u0019AA`\u0001")
public abstract class TierTask<T extends TierTask<T>>
implements Logging {
    private final Option<Meter> retryRateOpt;
    private volatile int retryCount;
    private volatile Option<Instant> _pausedUntil;
    private volatile Option<Throwable> _error;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int retryCount() {
        return this.retryCount;
    }

    public void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    private Option<Instant> _pausedUntil() {
        return this._pausedUntil;
    }

    private void _pausedUntil_$eq(Option<Instant> x$1) {
        this._pausedUntil = x$1;
    }

    private Option<Throwable> _error() {
        return this._error;
    }

    private void _error_$eq(Option<Throwable> x$1) {
        this._error = x$1;
    }

    public abstract TopicIdPartition topicIdPartition();

    public abstract CancellationContext ctx();

    public abstract Future<T> transition(Time var1, TierTopicAppender var2, TierObjectStore var3, ReplicaManager var4, TierTasksConfig var5, Option<Throttler> var6, ExecutionContext var7);

    public Option<Instant> pausedUntil() {
        return this._pausedUntil();
    }

    public boolean isErrorState() {
        return this._error().isDefined();
    }

    public Option<Throwable> errorState() {
        return this._error();
    }

    public TopicPartition topicPartition() {
        return this.topicIdPartition().topicPartition();
    }

    public void retryTaskLater(int maxRetryBackoffMs, long nowMs, Throwable t) {
        this.retryCount_$eq(this.retryCount() + 1);
        this.retryRateOpt.foreach((Function1 & Serializable)x$1 -> {
            x$1.mark();
            return BoxedUnit.UNIT;
        });
        Instant now = Instant.ofEpochMilli(nowMs);
        int pauseMs = Math.min(maxRetryBackoffMs, (Random$.MODULE$.nextInt(this.retryCount()) + 1) * 1000);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("retrying ").append(this).append(" after ").append(pauseMs).append("ms").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(pauseMs)));
    }

    public void delayTask(int delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(18).append("retrying ").append(this).append(" after ").append(delayMs).append("ms").toString());
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public void cancelAndSetErrorState(Throwable t) {
        this._error_$eq((Option<Throwable>)new Some((Object)t));
        this.ctx().cancel();
    }

    public void onSuccessfulTransition() {
        this.retryCount_$eq(0);
        this._pausedUntil_$eq((Option<Instant>)None$.MODULE$);
    }

    public void onSuccessfulTransitionWithDelay(long delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.onSuccessfulTransition();
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public TierTask(Option<Meter> retryRateOpt) {
        this.retryRateOpt = retryRateOpt;
        this.retryCount = 0;
        this._pausedUntil = None$.MODULE$;
        this._error = None$.MODULE$;
    }
}

