/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.tier.tasks.UpdatableQueueEntry;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]4AAE\n\u00035!)!\u0005\u0001C\u0001G!9\u0011\u0007\u0001b\u0001\n\u0013\u0011\u0004BB \u0001A\u0003%1\u0007C\u0004A\u0001\t\u0007I\u0011B!\t\r\u0015\u0003\u0001\u0015!\u0003C\u0011\u001d1\u0005A1A\u0005\n\u001dCaa\u0015\u0001!\u0002\u0013A\u0005b\u0002+\u0001\u0005\u0004%I!\u0016\u0005\u00073\u0002\u0001\u000b\u0011\u0002,\t\u000fi\u0003\u0001\u0019!C\u00057\"9q\f\u0001a\u0001\n\u0013\u0001\u0007B\u00024\u0001A\u0003&A\fC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003l\u0001\u0011\u0005A\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0003v\u0001\u0011\u0005aO\u0001\bVa\u0012\fG/\u00192mKF+X-^3\u000b\u0005Q)\u0012!\u0002;bg.\u001c(B\u0001\f\u0018\u0003\u0011!\u0018.\u001a:\u000b\u0003a\tQa[1gW\u0006\u001c\u0001!\u0006\u0002\u001cQM\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005!\u0003cA\u0013\u0001M5\t1\u0003\u0005\u0002(Q1\u0001A!B\u0015\u0001\u0005\u0004Q#!\u0001+\u0012\u0005-r\u0003CA\u000f-\u0013\ticDA\u0004O_RD\u0017N\\4\u0011\u0005\u0015z\u0013B\u0001\u0019\u0014\u0005M)\u0006\u000fZ1uC\ndW-U;fk\u0016,e\u000e\u001e:z\u0003\u0011awnY6\u0016\u0003M\u0002\"\u0001N\u001f\u000e\u0003UR!AN\u001c\u0002\u000b1|7m[:\u000b\u0005aJ\u0014AC2p]\u000e,(O]3oi*\u0011!hO\u0001\u0005kRLGNC\u0001=\u0003\u0011Q\u0017M^1\n\u0005y*$\u0001\u0002'pG.\fQ\u0001\\8dW\u0002\nAaY8oIV\t!\t\u0005\u00025\u0007&\u0011A)\u000e\u0002\n\u0007>tG-\u001b;j_:\fQaY8oI\u0002\nQ!\u001b;f[N,\u0012\u0001\u0013\t\u0005\u0013:\u0003f%D\u0001K\u0015\tYE*A\u0004nkR\f'\r\\3\u000b\u00055s\u0012AC2pY2,7\r^5p]&\u0011qJ\u0013\u0002\u0004\u001b\u0006\u0004\bC\u0001\u0014R\u0013\t\u0011vFA\u0002LKf\fa!\u001b;f[N\u0004\u0013!B9vKV,W#\u0001,\u0011\u0007%;\u0006+\u0003\u0002Y\u0015\n)\u0011+^3vK\u00061\u0011/^3vK\u0002\naa\u00197pg\u0016$W#\u0001/\u0011\u0005ui\u0016B\u00010\u001f\u0005\u001d\u0011un\u001c7fC:\f!b\u00197pg\u0016$w\fJ3r)\t\tG\r\u0005\u0002\u001eE&\u00111M\b\u0002\u0005+:LG\u000fC\u0004f\u0017\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'A\u0004dY>\u001cX\r\u001a\u0011\u0002\tA,8\u000f\u001b\u000b\u0003C&DQA[\u0007A\u0002\u0019\nA!\u001b;f[\u0006\u0001\u0002/^:i\u0013\u001atu\u000e\u001e)sKN,g\u000e\u001e\u000b\u0003C6DQA\u001b\bA\u0002\u0019\nA\u0001]8mYR\t\u0001\u000fE\u0002\u001ec\u001aJ!A\u001d\u0010\u0003\r=\u0003H/[8o\u0003\u0011!\u0018m[3\u0015\u0003\u0019\nQa\u00197pg\u0016$\u0012!\u0019")
public final class UpdatableQueue<T extends UpdatableQueueEntry> {
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock().newCondition();
    private final Map<Object, T> items = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Queue<Object> queue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
    private boolean closed = false;

    private Lock lock() {
        return this.lock;
    }

    private Condition cond() {
        return this.cond;
    }

    private Map<Object, T> items() {
        return this.items;
    }

    private Queue<Object> queue() {
        return this.queue;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public void push(T item) {
        Object key = item.key();
        this.lock().lock();
        try {
            if (this.closed()) {
                throw new CancellationException("queue closed");
            }
            if (!this.items().contains(key)) {
                this.queue().enqueue(key);
            }
            this.items().update(key, item);
            this.cond().signal();
        }
        finally {
            this.lock().unlock();
        }
    }

    public void pushIfNotPresent(T item) {
        Object key = item.key();
        this.lock().lock();
        try {
            if (!this.items().contains(key)) {
                this.queue().enqueue(key);
                this.items().update(key, item);
                this.cond().signal();
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public Option<T> poll() {
        None$ none$;
        block7: {
            this.lock().lock();
            try {
                if (this.closed()) {
                    throw new CancellationException("queue closed");
                }
                if (this.queue().isEmpty()) {
                    none$ = None$.MODULE$;
                    break block7;
                }
                Object key = this.queue().dequeue();
                Option option = this.items().remove(key);
                if (option instanceof Some) {
                    UpdatableQueueEntry item = (UpdatableQueueEntry)((Some)option).value();
                    none$ = new Some((Object)item);
                    break block7;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException("Illegal queue state");
                }
                throw new MatchError((Object)option);
            }
            finally {
                this.lock().unlock();
            }
        }
        return none$;
    }

    public T take() {
        UpdatableQueueEntry updatableQueueEntry;
        this.lock().lock();
        try {
            while (!this.closed() && this.queue().isEmpty()) {
                this.cond().await();
            }
            if (this.closed()) {
                throw new CancellationException("queue closed");
            }
            updatableQueueEntry = (UpdatableQueueEntry)this.poll().get();
        }
        finally {
            this.lock().unlock();
        }
        return (T)updatableQueueEntry;
    }

    public void close() {
        this.lock().lock();
        try {
            this.closed_$eq(true);
            this.cond().signalAll();
        }
        finally {
            this.lock().unlock();
        }
    }
}

