/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTaskWorkingSet;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.ArchiveTaskState;
import kafka.tier.tasks.archive.ArchiverMetrics;
import kafka.tier.tasks.archive.ArchiverPartitionLagInfo;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.archive.FailedState;
import kafka.tier.tasks.archive.Upload;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t%d\u0001B\u001a5\u0005uB\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"Aa\u000b\u0001B\u0001B\u0003%q\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!!\u0007A!A!\u0002\u0013)\u0007\u0002C6\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001\u0002 \u0001\u0003\u0002\u0003\u0006Y! \u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\t\t\u0003\u0001C)\u0003GA\u0011\"a\u000f\u0001\u0005\u0004%i!!\u0010\t\u0011\u0005\r\u0003\u0001)A\u0007\u0003\u007fA\u0011\"!\u0012\u0001\u0005\u0004%I!a\u0012\t\u0011\u0005]\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0017\t\u0011\u0005M\u0004\u0001)A\u0005\u0003;B\u0011\"!\u001e\u0001\u0005\u0004%I!a\u0017\t\u0011\u0005]\u0004\u0001)A\u0005\u0003;B\u0011\"!\u001f\u0001\u0005\u0004%I!a\u0017\t\u0011\u0005m\u0004\u0001)A\u0005\u0003;B\u0011\"! \u0001\u0001\u0004%I!a \t\u0013\u0005\u001d\u0005\u00011A\u0005\n\u0005%\u0005\u0002CAK\u0001\u0001\u0006K!!!\t\u0013\u0005}\u0005\u00011A\u0005\n\u0005}\u0004\"CAQ\u0001\u0001\u0007I\u0011BAR\u0011!\t9\u000b\u0001Q!\n\u0005\u0005\u0005\"CAV\u0001\u0001\u0007I\u0011BA@\u0011%\ti\u000b\u0001a\u0001\n\u0013\ty\u000b\u0003\u0005\u00024\u0002\u0001\u000b\u0015BAA\u0011%\t9\f\u0001a\u0001\n\u0013\tI\fC\u0005\u0002<\u0002\u0001\r\u0011\"\u0003\u0002>\"9\u0011\u0011\u0019\u0001!B\u0013a\u0007\"CAc\u0001\u0001\u0007I\u0011BA@\u0011%\t9\r\u0001a\u0001\n\u0013\tI\r\u0003\u0005\u0002N\u0002\u0001\u000b\u0015BAA\u0011)\t\t\u000e\u0001b\u0001\n\u00031\u00141\u001b\u0005\t\u00037\u0004\u0001\u0015!\u0003\u0002V\"I\u0011Q\u001c\u0001C\u0002\u0013%\u0011q\u001c\u0005\t\u0003[\u0004\u0001\u0015!\u0003\u0002b\"9\u0011q\u001e\u0001\u0005\u0002\u0005E\bb\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;AqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u00036\u0001!IAa\u000e\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D\u001dI!\u0011\n\u001b\u0002\u0002#\u0005!1\n\u0004\tgQ\n\t\u0011#\u0001\u0003N!9\u0011q\u0001\u0019\u0005\u0002\t=\u0003\"\u0003B)aE\u0005I\u0011\u0001B*\u00051!\u0016.\u001a:Be\u000eD\u0017N^3s\u0015\t)d'A\u0004be\u000eD\u0017N^3\u000b\u0005]B\u0014!\u0002;bg.\u001c(BA\u001d;\u0003\u0011!\u0018.\u001a:\u000b\u0003m\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001}\u0011\u0003\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013a!\u00118z%\u00164\u0007CA#I\u001b\u00051%BA$;\u0003\u0015)H/\u001b7t\u0013\tIeIA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\taU*D\u00017\u0013\tqeGA\bUS\u0016\u0014H+Y:lg\u000e{gNZ5h\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"!\u0015+\u000e\u0003IS!a\u0015\u001e\u0002\rM,'O^3s\u0013\t)&K\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002#QLWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'\u000f\u0005\u0002Y76\t\u0011L\u0003\u0002[q\u0005)Ao\u001c9jG&\u0011A,\u0017\u0002\u0012)&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\u0018a\u0004;jKJ|%M[3diN#xN]3\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005D\u0014!B:u_J,\u0017BA2a\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0017aA2uqB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eO\u0001\bM\u0016$8\r[3s\u0013\tQwMA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0005nCb$\u0016m]6t!\tyT.\u0003\u0002o\u0001\n\u0019\u0011J\u001c;\u0002\tQLW.\u001a\t\u0003cjl\u0011A\u001d\u0006\u0003\u000fNT!\u0001^;\u0002\r\r|W.\\8o\u0015\tYdO\u0003\u0002xq\u00061\u0011\r]1dQ\u0016T\u0011!_\u0001\u0004_J<\u0017BA>s\u0005\u0011!\u0016.\\3\u0002\u0005\u0015\u001c\u0007c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u0001\u000b!bY8oGV\u0014(/\u001a8u\u0013\r\t)a \u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003EA\u0006\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010)\u0011\ti!!\u0005\u0011\u0007\u0005=\u0001!D\u00015\u0011\u0015a\u0018\u0002q\u0001~\u0011\u0015Q\u0015\u00021\u0001L\u0011\u0015y\u0015\u00021\u0001Q\u0011\u00151\u0016\u00021\u0001X\u0011\u0015i\u0016\u00021\u0001_\u0011\u0015!\u0017\u00021\u0001f\u0011\u0015Y\u0017\u00021\u0001m\u0011\u001dy\u0017\u0002%AA\u0002A\f!\u0002\\8hO\u0016\u0014h*Y7f+\t\t)\u0003\u0005\u0003\u0002(\u0005Ub\u0002BA\u0015\u0003c\u00012!a\u000bA\u001b\t\tiCC\u0002\u00020q\na\u0001\u0010:p_Rt\u0014bAA\u001a\u0001\u00061\u0001K]3eK\u001aLA!a\u000e\u0002:\t11\u000b\u001e:j]\u001eT1!a\rA\u0003q!v\nU0M\u0003\u001e;\u0015JT$`!\u0006\u0013F+\u0013+J\u001f:\u001bvlQ(V\u001dR+\"!a\u0010\u0010\u0005\u0005\u0005S$A\u0003\u0002;Q{\u0005k\u0018'B\u000f\u001eKejR0Q\u0003J#\u0016\nV%P\u001dN{6iT+O)\u0002\nA\"\\3ue&\u001c7o\u0012:pkB,\"!!\u0013\u0011\t\u0005-\u00131K\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u00059Q.\u001a;sS\u000e\u001c(BA*v\u0013\u0011\t)&!\u0014\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\tEf$XMU1uKV\u0011\u0011Q\f\t\u0005\u0003?\ny'\u0004\u0002\u0002b)!\u00111MA3\u0003\u0011\u0019wN]3\u000b\t\u0005=\u0013q\r\u0006\u0005\u0003S\nY'\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003[\n1aY8n\u0013\u0011\t\t(!\u0019\u0003\u000b5+G/\u001a:\u0002\u0013\tLH/\u001a*bi\u0016\u0004\u0013!\u0003:fiJL(+\u0019;f\u0003)\u0011X\r\u001e:z%\u0006$X\rI\u0001\u000fKb\u001cW\r\u001d;j_:\u001c(+\u0019;f\u0003=)\u0007pY3qi&|gn\u001d*bi\u0016\u0004\u0013!\u0004;pi\u0006dG*Y4WC2,X-\u0006\u0002\u0002\u0002B\u0019q(a!\n\u0007\u0005\u0015\u0005I\u0001\u0003M_:<\u0017!\u0005;pi\u0006dG*Y4WC2,Xm\u0018\u0013fcR!\u00111RAI!\ry\u0014QR\u0005\u0004\u0003\u001f\u0003%\u0001B+oSRD\u0011\"a%\u0017\u0003\u0003\u0005\r!!!\u0002\u0007a$\u0013'\u0001\bu_R\fG\u000eT1h-\u0006dW/\u001a\u0011)\u0007]\tI\nE\u0002@\u00037K1!!(A\u0005!1x\u000e\\1uS2,\u0017a\t;pi\u0006dG*Y4WC2,XmV5uQ>,H/\u0012:s_J\u0004\u0016M\u001d;ji&|gn]\u0001(i>$\u0018\r\u001c'bOZ\u000bG.^3XSRDw.\u001e;FeJ|'\u000fU1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0006\u0015\u0006\"CAJ3\u0005\u0005\t\u0019AAA\u0003\u0011\"x\u000e^1m\u0019\u0006<g+\u00197vK^KG\u000f[8vi\u0016\u0013(o\u001c:QCJ$\u0018\u000e^5p]N\u0004\u0003f\u0001\u000e\u0002\u001a\u0006!\u0002/\u0019:uSRLwN\u001c'bO6\u000b\u0007PV1mk\u0016\f\u0001\u0004]1si&$\u0018n\u001c8MC\u001el\u0015\r\u001f,bYV,w\fJ3r)\u0011\tY)!-\t\u0013\u0005ME$!AA\u0002\u0005\u0005\u0015!\u00069beRLG/[8o\u0019\u0006<W*\u0019=WC2,X\r\t\u0015\u0004;\u0005e\u0015A\u00067bO\u001eLgn\u001a)beRLG/[8og\u000e{WO\u001c;\u0016\u00031\f!\u0004\\1hO&tw\rU1si&$\u0018n\u001c8t\u0007>,h\u000e^0%KF$B!a#\u0002@\"A\u00111S\u0010\u0002\u0002\u0003\u0007A.A\fmC\u001e<\u0017N\\4QCJ$\u0018\u000e^5p]N\u001cu.\u001e8uA!\u001a\u0001%!'\u00021A\f'\u000f^5uS>tG+[7f\u0019\u0006<W*\u0019=WC2,X-\u0001\u000fqCJ$\u0018\u000e^5p]RKW.\u001a'bO6\u000b\u0007PV1mk\u0016|F%Z9\u0015\t\u0005-\u00151\u001a\u0005\n\u0003'\u0013\u0013\u0011!a\u0001\u0003\u0003\u000b\u0011\u0004]1si&$\u0018n\u001c8US6,G*Y4NCb4\u0016\r\\;fA!\u001a1%!'\u0002\u0013Q\f7o[)vKV,WCAAk!\u0011\ty!a6\n\u0007\u0005eGGA\tBe\u000eD\u0017N^3s)\u0006\u001c8.U;fk\u0016\f!\u0002^1tWF+X-^3!\u0003)9xN]6j]\u001e\u001cV\r^\u000b\u0003\u0003C\u0004R\u0001TAr\u0003OL1!!:7\u0005I!\u0016.\u001a:UCN\\wk\u001c:lS:<7+\u001a;\u0011\t\u0005=\u0011\u0011^\u0005\u0004\u0003W$$aC!sG\"Lg/\u001a+bg.\f1b^8sW&twmU3uA\u00051Am\\,pe.$\"!a=\u0011\r\u0005U\u0018q B\u0003\u001d\u0011\t90a?\u000f\t\u0005-\u0012\u0011`\u0005\u0002\u0003&\u0019\u0011Q !\u0002\u000fA\f7m[1hK&!!\u0011\u0001B\u0002\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005u\b\tE\u0003\u007f\u0005\u000f\t9/C\u0002\u0003\n}\u0014aAR;ukJ,\u0017\u0001C:ikR$wn\u001e8\u0015\u0005\u0005-\u0015\u0001\u00059beRLG/[8o\u0019\u0006<\u0017J\u001c4p+\t\u0011\u0019\u0002\u0005\u0004\u0002v\u0006}(Q\u0003\t\u0005\u0003\u001f\u00119\"C\u0002\u0003\u001aQ\u0012\u0001$\u0011:dQ&4XM\u001d)beRLG/[8o\u0019\u0006<\u0017J\u001c4p\u0003Mawn\u001a)beRLG/[8o\u0019\u0006<\u0017J\u001c4p)\u0011\tYIa\b\t\u000f\t\u00052\u00061\u0001\u0002\u0002\u0006Y1-\u001e:sK:$H+[7f\u0003Y\u0019\u0018N_3PMRKWM]1cY\u0016\u001cVmZ7f]R\u001cH\u0003BAA\u0005OAqA!\u000b-\u0001\u0004\u0011Y#A\u0002m_\u001e\u0004BA!\f\u000325\u0011!q\u0006\u0006\u0004\u0005SQ\u0014\u0002\u0002B\u001a\u0005_\u00111\"\u00112tiJ\f7\r\u001e'pO\u0006yb\r\\;tQRKW.Z(g\r&\u00148\u000f\u001e+jKJ\f'\r\\3TK\u001elWM\u001c;\u0015\t\te\"q\b\t\u0006\u007f\tm\u0012\u0011Q\u0005\u0004\u0005{\u0001%AB(qi&|g\u000eC\u0004\u0003*5\u0002\rAa\u000b\u0002\u001bM\u001c\u0007.\u001a3vY&tw\rT1h)\u0011\u0011ID!\u0012\t\u000f\t\u001dc\u00061\u0001\u0002h\u0006!A/Y:l\u00031!\u0016.\u001a:Be\u000eD\u0017N^3s!\r\ty\u0001M\n\u0003ay\"\"Aa\u0013\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011)FK\u0002q\u0005/Z#A!\u0017\u0011\t\tm#QM\u0007\u0003\u0005;RAAa\u0018\u0003b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005G\u0002\u0015AC1o]>$\u0018\r^5p]&!!q\rB/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public final class TierArchiver
implements Logging {
    private final TierTasksConfig config;
    private final ReplicaManager replicaManager;
    private final CancellationContext ctx;
    private final KafkaMetricsGroup metricsGroup;
    private final Meter byteRate;
    private final Meter retryRate;
    private final Meter exceptionsRate;
    private volatile long kafka$tier$tasks$archive$TierArchiver$$totalLagValue;
    private volatile long kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions;
    private volatile long kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue;
    private volatile int kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount;
    private volatile long kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue;
    private final ArchiverTaskQueue taskQueue;
    private final TierTaskWorkingSet<ArchiveTask> workingSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return TierArchiver.class.getName();
    }

    private final int TOP_LAGGING_PARTITIONS_COUNT() {
        return 5;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Meter byteRate() {
        return this.byteRate;
    }

    private Meter retryRate() {
        return this.retryRate;
    }

    private Meter exceptionsRate() {
        return this.exceptionsRate;
    }

    public long kafka$tier$tasks$archive$TierArchiver$$totalLagValue() {
        return this.kafka$tier$tasks$archive$TierArchiver$$totalLagValue;
    }

    private void totalLagValue_$eq(long x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$totalLagValue = x$1;
    }

    public long kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions() {
        return this.kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions;
    }

    private void totalLagValueWithoutErrorPartitions_$eq(long x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions = x$1;
    }

    public long kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue() {
        return this.kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue;
    }

    private void partitionLagMaxValue_$eq(long x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue = x$1;
    }

    public int kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount() {
        return this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount;
    }

    private void laggingPartitionsCount_$eq(int x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount = x$1;
    }

    public long kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue() {
        return this.kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue;
    }

    private void partitionTimeLagMaxValue_$eq(long x$1) {
        this.kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue = x$1;
    }

    public ArchiverTaskQueue taskQueue() {
        return this.taskQueue;
    }

    private TierTaskWorkingSet<ArchiveTask> workingSet() {
        return this.workingSet;
    }

    public List<Future<ArchiveTask>> doWork() {
        return this.workingSet().doWork(this.config, (Option<Throttler>)None$.MODULE$);
    }

    public void shutdown() {
        this.ctx.cancel();
        this.taskQueue().close();
    }

    public List<ArchiverPartitionLagInfo> partitionLagInfo() {
        return (List)this.replicaManager.leaderPartitionsIterator().flatMap((Function1 & Serializable)x$1 -> x$1.log()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TierArchiver.$anonfun$partitionLagInfo$2(x$2))).map((Function1 & Serializable)log -> new ArchiverPartitionLagInfo(log.topicPartition(), log.tierPartitionState().status(), this.sizeOfTierableSegments((AbstractLog)log), this.flushTimeOfFirstTierableSegment((AbstractLog)log))).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierArchiver.$anonfun$partitionLagInfo$4(x$3))).toList().sortBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)TierArchiver.$anonfun$partitionLagInfo$5(x$4)), (Ordering)Ordering.Long$.MODULE$);
    }

    public void logPartitionLagInfo(long currentTime) {
        List<ArchiverPartitionLagInfo> laggingPartitions = this.partitionLagInfo();
        this.laggingPartitionsCount_$eq(laggingPartitions.size());
        this.totalLagValue_$eq(BoxesRunTime.unboxToLong((Object)this.partitionLagInfo().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.sizeOfTierableSegments())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = TierArchiver.$anonfun$logPartitionLagInfo$2(this);
            Object var6_3 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        this.totalLagValueWithoutErrorPartitions_$eq(BoxesRunTime.unboxToLong((Object)laggingPartitions.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TierArchiver.$anonfun$logPartitionLagInfo$3(x$6))).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.sizeOfTierableSegments())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        List topLaggingPartitions = laggingPartitions.take(5);
        if (topLaggingPartitions.nonEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = TierArchiver.$anonfun$logPartitionLagInfo$5(this, topLaggingPartitions);
                Object var7_5 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.partitionLagMaxValue_$eq(((ArchiverPartitionLagInfo)topLaggingPartitions.head()).sizeOfTierableSegments());
        } else {
            this.partitionLagMaxValue_$eq(0L);
        }
        List partitionsWithOldestSegments = ((List)laggingPartitions.filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TierArchiver.$anonfun$logPartitionLagInfo$6(x$8))).sortBy((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)TierArchiver.$anonfun$logPartitionLagInfo$7(x$9)), (Ordering)Ordering.Long$.MODULE$)).take(5);
        if (partitionsWithOldestSegments.nonEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = TierArchiver.$anonfun$logPartitionLagInfo$8(this, partitionsWithOldestSegments);
                Object var8_7 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            this.partitionTimeLagMaxValue_$eq(Math.max(currentTime - BoxesRunTime.unboxToLong((Object)((ArchiverPartitionLagInfo)partitionsWithOldestSegments.head()).timeFirstTierableSegmentRolled().get()), 0L));
            return;
        }
        this.partitionTimeLagMaxValue_$eq(0L);
    }

    private long sizeOfTierableSegments(AbstractLog log) {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)log.tierableLogSegments().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private Option<Object> flushTimeOfFirstTierableSegment(AbstractLog log) {
        return log.tierableLogSegments().headOption().map((Function1 & Serializable)segment -> BoxesRunTime.boxToLong((long)TierArchiver.$anonfun$flushTimeOfFirstTierableSegment$1(segment)));
    }

    private Option<Object> schedulingLag(ArchiveTask task) {
        ArchiveTaskState archiveTaskState = task.state();
        if (archiveTaskState instanceof BeforeLeader) {
            return new Some((Object)BoxesRunTime.boxToLong((long)-1L));
        }
        if (archiveTaskState instanceof BeforeUpload) {
            return this.replicaManager.getLog(task.topicPartition()).map((Function1 & Serializable)log -> BoxesRunTime.boxToLong((long)this.sizeOfTierableSegments(log)));
        }
        if (archiveTaskState instanceof Upload) {
            return new Some((Object)BoxesRunTime.boxToLong((long)-2L));
        }
        if (archiveTaskState instanceof AfterUpload) {
            return new Some((Object)BoxesRunTime.boxToLong((long)-3L));
        }
        if (archiveTaskState instanceof FailedState) {
            return new Some((Object)BoxesRunTime.boxToLong((long)-4L));
        }
        throw new MatchError((Object)archiveTaskState);
    }

    public static final /* synthetic */ boolean $anonfun$partitionLagInfo$2(AbstractLog x$2) {
        return x$2.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ boolean $anonfun$partitionLagInfo$4(ArchiverPartitionLagInfo x$3) {
        return x$3.sizeOfTierableSegments() > 0L;
    }

    public static final /* synthetic */ long $anonfun$partitionLagInfo$5(ArchiverPartitionLagInfo x$4) {
        return 0L - x$4.sizeOfTierableSegments();
    }

    public static final /* synthetic */ String $anonfun$logPartitionLagInfo$2(TierArchiver $this) {
        return new StringBuilder(43).append("Sum of TierArchiver lag of all partitions: ").append($this.kafka$tier$tasks$archive$TierArchiver$$totalLagValue()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$logPartitionLagInfo$3(ArchiverPartitionLagInfo x$6) {
        return !x$6.tierPartitionStatus().hasError();
    }

    public static final /* synthetic */ String $anonfun$logPartitionLagInfo$5(TierArchiver $this, List topLaggingPartitions$1) {
        return new StringBuilder(160).append($this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount()).append(" partitions seen with lag > 0. Partitions with most").append(" TierArchiver lag in descending order of lag (TopicPartition, PartitionStatus, LagInBytes, OldestTimestamp):").append(" ").append(topLaggingPartitions$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$logPartitionLagInfo$6(ArchiverPartitionLagInfo x$8) {
        return x$8.timeFirstTierableSegmentRolled().isDefined();
    }

    public static final /* synthetic */ long $anonfun$logPartitionLagInfo$7(ArchiverPartitionLagInfo x$9) {
        return BoxesRunTime.unboxToLong((Object)x$9.timeFirstTierableSegmentRolled().get());
    }

    public static final /* synthetic */ String $anonfun$logPartitionLagInfo$8(TierArchiver $this, List partitionsWithOldestSegments$1) {
        return new StringBuilder(169).append($this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount()).append(" partitions seen with lag > 0. Partitions with oldest").append(" segments awaiting archival in order of oldest time (TopicPartition, PartitionStatus, LagInBytes, OldestTimestamp):").append(" ").append(partitionsWithOldestSegments$1).toString();
    }

    public static final /* synthetic */ long $anonfun$flushTimeOfFirstTierableSegment$1(LogSegment segment) {
        return BoxesRunTime.unboxToLong((Object)segment.lastFlushedTimeMs().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> segment.lastModified()));
    }

    public TierArchiver(TierTasksConfig config, ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, CancellationContext ctx, int maxTasks, Time time, ExecutionContext ec) {
        this.config = config;
        this.replicaManager = replicaManager;
        this.ctx = ctx;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().removeMetric("BytesPerSec");
        this.byteRate = this.metricsGroup().newMeter("BytesPerSec", "bytes per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("RetriesPerSec");
        this.retryRate = this.metricsGroup().newMeter("RetriesPerSec", "number of retries per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("ObjectStoreRetriableExceptionsPerSec");
        this.exceptionsRate = this.metricsGroup().newMeter("ObjectStoreRetriableExceptionsPerSec", "number of times TierObjectStoreRetriableException was invoked per second", TimeUnit.SECONDS);
        this.kafka$tier$tasks$archive$TierArchiver$$totalLagValue = 0L;
        this.metricsGroup().removeMetric("TotalLag");
        this.metricsGroup().newGauge("TotalLag", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public long value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$totalLagValue();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions = 0L;
        this.metricsGroup().removeMetric("TotalLagWithoutErrorPartitions");
        this.metricsGroup().newGauge("TotalLagWithoutErrorPartitions", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public long value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$totalLagValueWithoutErrorPartitions();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue = 0L;
        this.metricsGroup().removeMetric("PartitionLagMaxValue");
        this.metricsGroup().newGauge("PartitionLagMaxValue", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public long value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$partitionLagMaxValue();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount = 0;
        this.metricsGroup().removeMetric("LaggingPartitionsCount");
        this.metricsGroup().newGauge("LaggingPartitionsCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$laggingPartitionsCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue = 0L;
        this.metricsGroup().removeMetric("PartitionTimeLagMaxValue");
        this.metricsGroup().newGauge("PartitionTimeLagMaxValue", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierArchiver $outer;

            public long value() {
                return this.$outer.kafka$tier$tasks$archive$TierArchiver$$partitionTimeLagMaxValue();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.taskQueue = new ArchiverTaskQueue(ctx.subContext(), maxTasks, time, (Function1<ArchiveTask, Option<Object>>)(Function1 & Serializable)task -> this.schedulingLag((ArchiveTask)task), new ArchiverMetrics((Option<Meter>)new Some((Object)this.byteRate()), (Option<Meter>)new Some((Object)this.retryRate()), (Option<Meter>)new Some((Object)this.exceptionsRate())), config.brokerId());
        this.workingSet = new TierTaskWorkingSet<ArchiveTask>(this.taskQueue(), replicaManager, tierTopicAppender, tierObjectStore, time, ec);
    }
}

