/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.snapshot;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kafka.log.AbstractLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.exceptions.NotTierablePartitionException;
import kafka.tier.exceptions.TierSnapshotFailedException;
import kafka.tier.exceptions.TierSnapshotFencedException;
import kafka.tier.exceptions.TierSnapshotRestoreFencedException;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.Header;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.SnapshotTasksConfig;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class MetadataSnapshotTask$
implements Logging {
    public static final MetadataSnapshotTask$ MODULE$ = new MetadataSnapshotTask$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return MetadataSnapshotTask.class.getName();
    }

    public MetadataSnapshotTask.MetadataSnapshotTaskState kafka$tier$tasks$snapshot$MetadataSnapshotTask$$garbageCollectOlderSnapshots(TopicIdPartition topicIdPartition, int leaderEpoch, AbstractLog log, TierObjectStore tierObjectStore, Time time, TierTasksConfig config) {
        List<TierObjectStore.KeyAndVersion> snapshotsToDelete;
        Optional<FileTierPartitionStateSnapshotObject> lastCommittedSnapshotInfo;
        UUID lastCommittedSnapshotId = log.tierPartitionState().lastCommittedSnapshotId();
        if (lastCommittedSnapshotId == null || ((Object)lastCommittedSnapshotId).equals(Header.SNAPSHOT_ID_EMPTY)) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$garbageCollectOlderSnapshots$1(topicIdPartition);
                Object var19_8 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return new MetadataSnapshotTask.BeforeMetadataSnapshotState(leaderEpoch);
        }
        String snapshotPrefix = TierObjectStore.TierPartitionStateSnapshotMetadata.pathPrefix("", topicIdPartition);
        List snapshotObjects = tierObjectStore.listObject(snapshotPrefix, false).keySet().stream().map(snapshotPath -> FileTierPartitionStateSnapshotObject.decodeSnapshotName(TierObjectStore.TierPartitionStateSnapshotMetadata.extractEncodedName(snapshotPath))).collect(Collectors.toList());
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$garbageCollectOlderSnapshots$3(topicIdPartition, snapshotObjects);
            Object var20_11 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        if (!(lastCommittedSnapshotInfo = snapshotObjects.stream().filter(x$6 -> {
            UUID uUID = x$6.snapshotId();
            return !(uUID != null ? !((Object)uUID).equals(lastCommittedSnapshotId) : lastCommittedSnapshotId != null);
        }).findFirst()).isPresent()) {
            if (this.logger().underlying().isErrorEnabled()) {
                String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$garbageCollectOlderSnapshots$5(lastCommittedSnapshotId, topicIdPartition);
                Object var21_13 = null;
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return new MetadataSnapshotTask.BeforeMetadataSnapshotState(leaderEpoch);
        }
        long timeMs = time.milliseconds();
        long retentionMs = TimeUnit.DAYS.toMillis(((SnapshotTasksConfig)config.snapshotTaskConfig().get()).retentionDays().apply$mcI$sp());
        long retentionCutoffTimeMs = timeMs - retentionMs;
        if (this.logger().underlying().isDebugEnabled()) {
            String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$garbageCollectOlderSnapshots$6(topicIdPartition, retentionCutoffTimeMs, timeMs, retentionMs);
            Object var22_17 = null;
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        if ((snapshotsToDelete = snapshotObjects.stream().filter(snapshotObject -> snapshotObject.snapshotTimestampMs() < ((FileTierPartitionStateSnapshotObject)lastCommittedSnapshotInfo.get()).snapshotTimestampMs() && snapshotObject.snapshotTimestampMs() < retentionCutoffTimeMs).map(s -> {
            TierObjectStore.TierPartitionStateSnapshotMetadata metadata = new TierObjectStore.TierPartitionStateSnapshotMetadata(topicIdPartition, (FileTierPartitionStateSnapshotObject)s);
            return new TierObjectStore.KeyAndVersion(metadata.toPath("", TierObjectStore.FileType.TIER_PARTITION_STATE_METADATA_SNAPSHOT));
        }).collect(Collectors.toList())).isEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$garbageCollectOlderSnapshots$9(topicIdPartition);
                Object var23_19 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
        } else {
            StringBuilder sb = new StringBuilder(new java.lang.StringBuilder(43).append("Following snapshots are to be deleted for ").append(topicIdPartition).append("\n").toString());
            snapshotsToDelete.forEach(kv -> sb.append(kv.key()).append(" "));
            if (this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = sb.toString();
                Object var24_21 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            tierObjectStore.deleteVersions(snapshotsToDelete);
        }
        return new MetadataSnapshotTask.BeforeMetadataSnapshotState(leaderEpoch);
    }

    public Future<BoxedUnit> kafka$tier$tasks$snapshot$MetadataSnapshotTask$$writeEvent(TierTopicAppender tierTopicAppender, AbstractTierMetadata event, Time time, ExecutionContext ec) {
        long startTimeMs = time.milliseconds();
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$writeEvent$1(event);
            Object var7_6 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(event))).map((Function1 & Serializable)appendResult -> {
            MetadataSnapshotTask$.$anonfun$writeEvent$2(event, time, startTimeMs, appendResult);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public Option<Tuple2<Path, FileTierPartitionStateSnapshotObject>> searchSnapshotByUuid(UUID snapshotId, Path snapshotsDir) {
        LongRef earliestTimestampMs = LongRef.create((long)Long.MAX_VALUE);
        ObjectRef earliestSnapshot = ObjectRef.create((Object)None$.MODULE$);
        try (DirectoryStream filesStream = FilesWrapper.newDirectoryStream((Path)snapshotsDir);){
            filesStream.forEach(path -> {
                block6: {
                    block9: {
                        FileTierPartitionStateSnapshotObject metadata;
                        block8: {
                            UUID uUID;
                            block7: {
                                if (!FileTierPartitionStateSnapshotObject.isSnapshotFile(((Object)path.getFileName()).toString())) break block6;
                                metadata = FileTierPartitionStateSnapshotObject.decodeSnapshotName(((Object)path.getFileName()).toString());
                                uUID = metadata.snapshotId();
                                if (uUID != null) break block7;
                                if (snapshotId != null) {
                                    return;
                                }
                                break block8;
                            }
                            if (!((Object)uUID).equals(snapshotId)) break block9;
                        }
                        if (metadata.snapshotTimestampMs() < earliestTimestampMs$1.elem) {
                            earliestTimestampMs$1.elem = metadata.snapshotTimestampMs();
                            earliestSnapshot$1.elem = new Some((Object)new Tuple2(path, (Object)metadata));
                            return;
                        }
                    }
                    return;
                }
            });
        }
        return (Option)earliestSnapshot.elem;
    }

    public Path kafka$tier$tasks$snapshot$MetadataSnapshotTask$$snapshotsDir(Path logDir) {
        return logDir.resolve("snapshots");
    }

    public static final /* synthetic */ String $anonfun$garbageCollectOlderSnapshots$1(TopicIdPartition topicIdPartition$6) {
        return new java.lang.StringBuilder(50).append("No committed snapshots available for deletion for ").append(topicIdPartition$6).toString();
    }

    public static final /* synthetic */ String $anonfun$garbageCollectOlderSnapshots$3(TopicIdPartition topicIdPartition$6, List snapshotObjects$1) {
        return new java.lang.StringBuilder(38).append(topicIdPartition$6).append(" Tier metadata snapshot objects List: ").append(snapshotObjects$1).toString();
    }

    public static final /* synthetic */ String $anonfun$garbageCollectOlderSnapshots$5(UUID lastCommittedSnapshotId$1, TopicIdPartition topicIdPartition$6) {
        return new java.lang.StringBuilder(55).append("Committed snapshot ").append(lastCommittedSnapshotId$1.toString()).append(" for ").append(topicIdPartition$6).append(" is not present at object store").toString();
    }

    public static final /* synthetic */ String $anonfun$garbageCollectOlderSnapshots$6(TopicIdPartition topicIdPartition$6, long retentionCutoffTimeMs$1, long timeMs$1, long retentionMs$1) {
        return new java.lang.StringBuilder(52).append(topicIdPartition$6).append(" retentionCutoffTimeMs: ").append(retentionCutoffTimeMs$1).append(" currentTime: ").append(timeMs$1).append(" retentionMs: ").append(retentionMs$1).toString();
    }

    public static final /* synthetic */ String $anonfun$garbageCollectOlderSnapshots$9(TopicIdPartition topicIdPartition$6) {
        return new java.lang.StringBuilder(31).append("No snapshots to be deleted for ").append(topicIdPartition$6).toString();
    }

    public static final /* synthetic */ String $anonfun$garbageCollectOlderSnapshots$11(StringBuilder sb$1) {
        return sb$1.toString();
    }

    public static final /* synthetic */ String $anonfun$writeEvent$1(AbstractTierMetadata event$1) {
        return new java.lang.StringBuilder(11).append(event$1.topicIdPartition()).append(" appending ").append(event$1).toString();
    }

    public static final /* synthetic */ String $anonfun$writeEvent$3(AbstractTierMetadata event$1, Time time$5, long startTimeMs$2) {
        return new java.lang.StringBuilder(17).append(event$1.topicIdPartition()).append(" completed ").append(event$1).append(" in ").append(time$5.milliseconds() - startTimeMs$2).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$writeEvent$4(AbstractTierMetadata event$1) {
        return new java.lang.StringBuilder(55).append(event$1.topicIdPartition()).append(" Stopping state machine as attempt to transition failed").toString();
    }

    public static final /* synthetic */ String $anonfun$writeEvent$5(AbstractTierMetadata event$1) {
        return new java.lang.StringBuilder(59).append(event$1.topicIdPartition()).append(" Stopping state machine as attempt to transition was fenced").toString();
    }

    public static final /* synthetic */ String $anonfun$writeEvent$6(AbstractTierMetadata event$1) {
        return new java.lang.StringBuilder(74).append(event$1.topicIdPartition()).append(" Stopping state machine as attempt to transition was fenced due to restore").toString();
    }

    public static final /* synthetic */ void $anonfun$writeEvent$2(AbstractTierMetadata event$1, Time time$5, long startTimeMs$2, TierPartitionState.AppendResult appendResult) {
        if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult)) {
            MetadataSnapshotTask$ info_this = MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$writeEvent$3(event$1, time$5, startTimeMs$2);
                Object var9_5 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
                return;
            }
            return;
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals((Object)appendResult)) {
            MetadataSnapshotTask$ warn_this = MODULE$;
            if (warn_this.logger().underlying().isWarnEnabled()) {
                String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$writeEvent$4(event$1);
                Object var10_7 = null;
                warn_this.logger().underlying().warn(Logging.msgWithLogIdent$(warn_this, msgWithLogIdent_msg));
            }
            Object var6_6 = null;
            throw new TierSnapshotFailedException(new java.lang.StringBuilder(39).append(event$1.topicIdPartition()).append(" appendResult: ").append((Object)appendResult).append(", moving to failed state").toString(), null);
        }
        if (((Object)((Object)TierPartitionState.AppendResult.NOT_TIERABLE)).equals((Object)appendResult)) {
            throw new NotTierablePartitionException(event$1.topicIdPartition());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult)) {
            MetadataSnapshotTask$ info_this = MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$writeEvent$5(event$1);
                Object var11_9 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            Object var7_8 = null;
            throw new TierSnapshotFencedException(new java.lang.StringBuilder(15).append(event$1.topicIdPartition()).append(" appendResult: ").append((Object)appendResult).toString(), null);
        }
        if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals((Object)appendResult)) {
            MetadataSnapshotTask$ info_this = MODULE$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = MetadataSnapshotTask$.$anonfun$writeEvent$6(event$1);
                Object var12_11 = null;
                info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            }
            Object var8_10 = null;
            throw new TierSnapshotRestoreFencedException(new java.lang.StringBuilder(15).append(event$1.topicIdPartition()).append(" appendResult: ").append((Object)appendResult).toString(), null);
        }
        throw new IllegalStateException(new java.lang.StringBuilder(26).append(event$1.topicIdPartition()).append(" unexpected appendResult: ").append((Object)appendResult).toString());
    }

    private MetadataSnapshotTask$() {
    }
}

