/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.topic.TierTopic;
import kafka.utils.CoreUtils;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.utils.Utils;

public class TierPartitionStateFencingTrigger {
    public static final List<String> REQUIRED_PROPERTIES = Arrays.asList(KafkaConfig.TierMetadataNamespaceProp(), "confluent.tier.recovery.working.dir");
    public static final String FENCE_TARGET_PARTITIONS_CONFIG_FILE = "file-fence-target-partitions";
    public static final String FENCE_TARGET_PARTITIONS_CONFIG_FILE_DOC = "The path to a file containing non-empty list of target tiered partitions to be fenced by the tool. The format of the file is a newline separated list of information. Each line is a comma-separated value (CSV) containing information about a single tiered TopicIdPartition in the following format: <tiered_partition_topic_ID_base64_encoded>:<tiered_partition_topic_name>-<tiered_partition_number> <freeze_merged_log_start_offset> where `freeze_merged_log_start_offset` is a boolean indicating that log start offset must be frozen as part of fencing the partition.";
    public static final String FENCE_TRIGGER_OUTPUT_FILE = "output.json";
    public static final String FENCE_TRIGGER_OUTPUT_FILE_DOC = "The path where JSON containing the fenced partitions, and fence message offsets/UUIDs will be written to.";

    private static ArgumentParser createArgParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)TierPartitionStateFencingTrigger.class.getName()).defaultHelp(true).description("Provides a command to fence tiered topic partitions using the TierPartitionFence event.");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("tier.config")}).dest("tier.config").type(String.class).required(true).help("The path to a configuration file containing the required properties");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(FENCE_TARGET_PARTITIONS_CONFIG_FILE)}).dest(FENCE_TARGET_PARTITIONS_CONFIG_FILE).type(String.class).required(true).help(FENCE_TARGET_PARTITIONS_CONFIG_FILE_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(FENCE_TRIGGER_OUTPUT_FILE)}).dest(FENCE_TRIGGER_OUTPUT_FILE).type(String.class).required(true).help(FENCE_TRIGGER_OUTPUT_FILE_DOC);
        return parser;
    }

    private static void cleanDirectory(String dir) throws IOException {
        if (dir.isEmpty()) {
            return;
        }
        File root = new File(dir);
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        System.out.println("Deleting all files under working directory: " + dir);
        ArrayList<File> filesToKeep = new ArrayList<File>();
        filesToKeep.add(root);
        Utils.delete((File)root, filesToKeep, (boolean)false);
    }

    private static void run(ArgumentParser parser, Namespace args) throws ArgumentParserException, InterruptedException, IOException, ExecutionException {
        Map<TopicIdPartition, Boolean> tieredTopicIdPartitions;
        List<String> tieredTopicIdPartitionsStr;
        Properties props;
        String propertiesConfFile = args.getString("tier.config").trim();
        try {
            ArrayList<String> requiredTotal = new ArrayList<String>();
            requiredTotal.addAll(REQUIRED_PROPERTIES);
            requiredTotal.addAll(ProducerConfig.configNames());
            props = Utils.loadProps((String)propertiesConfFile, requiredTotal);
        }
        catch (IOException e) {
            throw new ArgumentParserException(String.format("Can not load properties from file: '%s'", propertiesConfFile), (Throwable)e, parser);
        }
        String bootstrapServers = props.getProperty("bootstrap.servers", "").trim();
        if (bootstrapServers.isEmpty()) {
            throw new ArgumentParserException(String.format("The provided properties conf file: '%s' can not contain empty or absent bootstrap servers as value for the property: '%s'", propertiesConfFile, "bootstrap.servers"), parser);
        }
        String tierTopicNamespace = props.getProperty(KafkaConfig.TierMetadataNamespaceProp(), "");
        String tieredTopicIdPartitionFile = args.getString(FENCE_TARGET_PARTITIONS_CONFIG_FILE).trim();
        try {
            Path filePath = Paths.get(tieredTopicIdPartitionFile, new String[0]);
            tieredTopicIdPartitionsStr = Files.readAllLines(filePath);
            tieredTopicIdPartitions = RecoveryUtils.parseFencingInformation(tieredTopicIdPartitionsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArgumentParserException(String.format("Can not parse partitions information from file: '%s'", tieredTopicIdPartitionFile), (Throwable)e, parser);
        }
        if (tieredTopicIdPartitions.isEmpty()) {
            throw new ArgumentParserException(String.format("Found no partitions information in file: '%s'", tieredTopicIdPartitionFile), parser);
        }
        System.out.println(String.format("Read the following tiered TopicIdPartition from %s as candidates for fencing:\n%s\n", tieredTopicIdPartitionFile, String.join((CharSequence)"\n", tieredTopicIdPartitionsStr)));
        String outputFile = args.getString(FENCE_TRIGGER_OUTPUT_FILE).trim();
        File file = new File(outputFile);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite existing file at " + outputFile);
        }
        if (!file.createNewFile()) {
            throw new IOException("Could not create output file at path " + outputFile);
        }
        String workingDirName = props.getProperty("confluent.tier.recovery.working.dir", "");
        try {
            TierPartitionStateFencingTrigger.cleanDirectory(workingDirName);
        }
        catch (IOException e) {
            System.err.println("Failed to clean the working directory " + e);
            throw new IllegalStateException("Failed to clean the working directory ", e);
        }
        HashSet inputPartitions = tieredTopicIdPartitions.keySet().stream().map(TopicIdPartition::topicPartition).collect(Collectors.toCollection(HashSet::new));
        RecoveryUtils.validatePartitions(props, inputPartitions);
        try (FileOutputStream fos = new FileOutputStream(file);){
            List<FenceEventInfo> events = TierPartitionStateFencingTrigger.injectFencingEvents(props, tierTopicNamespace, tieredTopicIdPartitions);
            fos.write(FenceEventInfo.listToJson(events).getBytes());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<FenceEventInfo> injectFencingEvents(Properties properties, String tierTopicNamespace, Map<TopicIdPartition, Boolean> tieredTopicIdPartitions) throws ExecutionException, InterruptedException {
        String tierTopicName = TierTopic.topicName(tierTopicNamespace);
        ArrayList<FenceEventInfo> events = new ArrayList<FenceEventInfo>();
        try (Producer<byte[], byte[]> producer = RecoveryUtils.createTierTopicProducer(properties, TierPartitionStateFencingTrigger.class.getSimpleName());){
            int numTierTopicPartitions = RecoveryUtils.getNumPartitions(producer, tierTopicName);
            for (Map.Entry<TopicIdPartition, Boolean> entry : tieredTopicIdPartitions.entrySet()) {
                TopicIdPartition tieredPartition = entry.getKey();
                Boolean freezeMergedLogStartOffset = entry.getValue();
                TierPartitionFence fencingEvent = new TierPartitionFence(tieredPartition, UUID.randomUUID(), freezeMergedLogStartOffset);
                RecordMetadata metadata = RecoveryUtils.injectTierTopicEvent(producer, fencingEvent, tierTopicName, numTierTopicPartitions);
                FenceEventInfo event = new FenceEventInfo(tieredPartition.topic(), tieredPartition.topicIdAsBase64(), tieredPartition.partition(), CoreUtils.uuidToBase64(fencingEvent.messageId()), freezeMergedLogStartOffset, metadata.offset(), metadata.partition(), metadata.timestamp());
                events.add(event);
            }
            ArrayList<FenceEventInfo> arrayList = events;
            return arrayList;
        }
        catch (Exception e) {
            System.err.println("Could not inject fencing events.");
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        block2: {
            ArgumentParser parser = TierPartitionStateFencingTrigger.createArgParser();
            try {
                TierPartitionStateFencingTrigger.run(parser, parser.parseArgs(args));
            }
            catch (ArgumentParserException e) {
                parser.handleError(e);
                if (e instanceof HelpScreenException) break block2;
                throw e;
            }
        }
    }
}

