/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kafka.tier.topic.TierCatchupConsumer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TierDiscoverConsumer
extends TierCatchupConsumer {
    private static final Logger log = LoggerFactory.getLogger(TierDiscoverConsumer.class);
    volatile Map<TopicPartition, Long> tierTopicPartitionsAndEndOffsets;

    TierDiscoverConsumer(Supplier<Consumer<byte[], byte[]>> consumerSupplier) {
        super(consumerSupplier);
    }

    void doStart(Set<TopicPartition> tierTopicPartitions, long consumeFromTimestamp) {
        if (!this.maybeStartConsumer(tierTopicPartitions, consumeFromTimestamp)) {
            throw new IllegalStateException(String.format("Unable to startup consumer with consume from timestamp: %d", consumeFromTimestamp));
        }
    }

    boolean tryComplete() {
        if (this.tierTopicPartitionsAndEndOffsets == null) {
            return false;
        }
        return super.tryComplete((tp, position) -> this.tierTopicPartitionsAndEndOffsets.get(tp) <= this.consumer.position(tp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        super.close();
        TierDiscoverConsumer tierDiscoverConsumer = this;
        synchronized (tierDiscoverConsumer) {
            this.tierTopicPartitionsAndEndOffsets = null;
        }
    }

    private boolean maybeStartConsumer(Set<TopicPartition> tierTopicPartitions, long consumeFromTimestamp) {
        if (!this.getConsumerAndAssignPartitions(tierTopicPartitions)) {
            return false;
        }
        HashMap tierTopicPartitionAndTimestamp = new HashMap();
        tierTopicPartitions.forEach(tp -> tierTopicPartitionAndTimestamp.put(tp, consumeFromTimestamp));
        log.info("Starting consumer for {}", tierTopicPartitions);
        this.consumer.offsetsForTimes(tierTopicPartitionAndTimestamp).forEach((tp, offsetAndTimestamp) -> this.consumer.seek(tp, offsetAndTimestamp == null ? 0L : offsetAndTimestamp.offset()));
        return true;
    }

    @Override
    boolean getConsumerAndAssignPartitions(Set<TopicPartition> partitions) {
        if (this.active() || partitions.isEmpty() || this.tierTopicPartitionsAndEndOffsets != null) {
            return false;
        }
        this.consumer = (Consumer)this.consumerSupplier.get();
        this.consumer.assign(partitions);
        this.tierTopicPartitionsAndEndOffsets = this.consumer.endOffsets(partitions);
        return true;
    }
}

