/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.util.Arrays;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.commands.impl.top.TTop;
import org.jline.terminal.Terminal;

@Command(scope="shell", name="ttop", description="Display threads information")
@Service
public class TTopAction
implements Action {
    @Option(name="--order", aliases={"-o"}, description="Comma separated list of sorting keys")
    String order;
    @Option(name="--stats", aliases={"-t"}, description="Comma separated list of stats to display")
    String stats;
    @Option(name="--seconds", aliases={"-s"}, description="Delay between updates in seconds")
    Integer seconds;
    @Option(name="--millis", aliases={"-m"}, description="Delay between updates in milliseconds")
    Integer millis;
    @Option(name="--nthreads", aliases={"-n"}, description="Only display up to NTHREADS threads")
    int nthreads = -1;
    @Reference
    Session session;

    public Object execute() throws Exception {
        TTop ttop = new TTop((Terminal)this.session.get(".jline.terminal"));
        ttop.sort = this.order != null ? Arrays.asList(this.order.split(",")) : null;
        ttop.delay = this.seconds != null ? (long)(this.seconds * 1000) : ttop.delay;
        ttop.delay = this.millis != null ? (long)this.millis.intValue() : ttop.delay;
        ttop.stats = this.stats != null ? Arrays.asList(this.stats.split(",")) : null;
        ttop.nthreads = this.nthreads;
        ttop.run();
        return null;
    }
}

