/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.gogo.jline.Builtin;
import org.apache.felix.gogo.jline.Converters;
import org.apache.felix.gogo.jline.Posix;
import org.apache.felix.gogo.jline.Procedural;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.gogo.jline.SingleServiceTracker;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.gogo.runtime.Tokenizer;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator,
SingleServiceTracker.SingleServiceListener {
    private final Set<ServiceRegistration<?>> regs = new HashSet();
    private BundleContext context;
    private SingleServiceTracker<CommandProcessor> commandProcessorTracker;
    private Runnable closer;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.commandProcessorTracker = new SingleServiceTracker<CommandProcessor>(context, CommandProcessor.class, this);
        this.commandProcessorTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        Iterator<ServiceRegistration<?>> iterator = this.regs.iterator();
        while (iterator.hasNext()) {
            ServiceRegistration<?> reg = iterator.next();
            reg.unregister();
            iterator.remove();
        }
        this.commandProcessorTracker.close();
    }

    @Override
    public void serviceFound() {
        try {
            this.closer = this.startShell(this.context, this.commandProcessorTracker.getService());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serviceLost() {
        this.stopShell();
    }

    @Override
    public void serviceReplaced() {
        this.serviceLost();
        this.serviceFound();
    }

    private Runnable startShell(BundleContext context, CommandProcessor processor) throws Exception {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "gogo");
        this.regs.add(context.registerService(Converter.class.getName(), (Object)new Converters(context.getBundle(0L).getBundleContext()), null));
        ((Dictionary)dict).put("osgi.command.function", Builtin.functions);
        this.regs.add(context.registerService(Builtin.class.getName(), (Object)new Builtin(), dict));
        ((Dictionary)dict).put("osgi.command.function", Procedural.functions);
        this.regs.add(context.registerService(Procedural.class.getName(), (Object)new Procedural(), dict));
        ((Dictionary)dict).put("osgi.command.function", Posix.functions);
        this.regs.add(context.registerService(Posix.class.getName(), (Object)new Posix(processor), dict));
        Shell shell = new Shell(new ShellContext(), processor);
        ((Dictionary)dict).put("osgi.command.function", Shell.functions);
        this.regs.add(context.registerService(Shell.class.getName(), (Object)shell, dict));
        Terminal terminal = TerminalBuilder.builder().system(true).nativeSignals(true).signalHandler(Terminal.SignalHandler.SIG_IGN).build();
        CommandSession session = processor.createSession(terminal.input(), terminal.output(), terminal.output());
        AtomicBoolean closing = new AtomicBoolean();
        Thread thread = new Thread(() -> {
            block7: {
                String errorMessage = "gogo: unable to create console";
                try {
                    session.put(".terminal", terminal);
                    try {
                        ArrayList<String> args = new ArrayList<String>();
                        args.add("--login");
                        String argstr = shell.getContext().getProperty("gosh.args");
                        if (argstr != null) {
                            Token token;
                            Tokenizer tokenizer = new Tokenizer(argstr);
                            while ((token = tokenizer.next()) != null) {
                                args.add(token.toString());
                            }
                        }
                        shell.gosh(session, args.toArray(new String[args.size()]));
                    }
                    catch (Throwable e) {
                        Object loc = session.get(".location");
                        if (null == loc || !loc.toString().contains(":")) {
                            loc = "gogo";
                        }
                        errorMessage = loc.toString();
                        throw e;
                    }
                }
                catch (Throwable e) {
                    if (closing.get()) break block7;
                    System.err.println(errorMessage + e.getClass().getSimpleName() + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }, "Gogo shell");
        thread.start();
        return () -> {
            closing.set(true);
            shell.stop();
            try {
                terminal.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                long t0 = System.currentTimeMillis();
                while (thread.isAlive()) {
                    thread.interrupt();
                    thread.join(10L);
                    if (System.currentTimeMillis() - t0 <= 5000L) continue;
                    System.err.println("!!! FAILED TO STOP EXECUTOR !!!");
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
    }

    private void stopShell() {
        if (this.closer != null) {
            this.closer.run();
        }
        while (!this.regs.isEmpty()) {
            ServiceRegistration<?> reg = this.regs.iterator().next();
            this.regs.remove(reg);
            reg.unregister();
        }
    }

    private class ShellContext
    implements Shell.Context {
        private ShellContext() {
        }

        @Override
        public String getProperty(String name) {
            return Activator.this.context.getProperty(name);
        }

        @Override
        public void exit() throws Exception {
            Activator.this.context.getBundle(0L).stop();
        }
    }
}

