/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.gogo.runtime.EOFError;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.felix.gogo.runtime.SyntaxError;
import org.apache.felix.gogo.runtime.Token;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.jline.reader.LineReader;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.WCWidth;

public class Highlighter
extends DefaultHighlighter {
    private final CommandSession session;

    public Highlighter(CommandSession session) {
        this.session = session;
    }

    public AttributedString highlight(LineReader reader, String buffer) {
        try {
            Parser.Program program = null;
            List<Token> tokens = null;
            List<Parser.Statement> statements = null;
            String repaired = buffer;
            while (program == null) {
                try {
                    Parser parser = new Parser(repaired);
                    program = parser.program();
                    tokens = parser.tokens();
                    statements = parser.statements();
                }
                catch (EOFError e) {
                    repaired = repaired + " " + e.repair();
                }
            }
            int underlineStart = -1;
            int underlineEnd = -1;
            int negativeStart = -1;
            int negativeEnd = -1;
            String search = reader.getSearchTerm();
            if (search != null && search.length() > 0 && (underlineStart = buffer.indexOf(search)) >= 0) {
                underlineEnd = underlineStart + search.length() - 1;
            }
            if (reader.getRegionActive() != LineReader.RegionType.NONE) {
                negativeStart = reader.getRegionMark();
                if (negativeStart > (negativeEnd = reader.getBuffer().cursor())) {
                    int x = negativeEnd;
                    negativeEnd = negativeStart;
                    negativeStart = x;
                }
                if (reader.getRegionActive() == LineReader.RegionType.LINE) {
                    while (negativeStart > 0 && reader.getBuffer().atChar(negativeStart - 1) != 10) {
                        --negativeStart;
                    }
                    while (negativeEnd < reader.getBuffer().length() - 1 && reader.getBuffer().atChar(negativeEnd + 1) != 10) {
                        ++negativeEnd;
                    }
                }
            }
            Type[] types = new Type[repaired.length()];
            Arrays.fill((Object[])types, (Object)Type.Unknown);
            int cur = 0;
            for (Token token : tokens) {
                if (token.start() >= buffer.length()) break;
                if (token.start() > cur) {
                    cur = token.start();
                }
                Parser.Statement statement = null;
                for (int i = statements.size() - 1; i >= 0; --i) {
                    Parser.Statement s = statements.get(i);
                    if (s.start() > cur || cur >= s.start() + s.length()) continue;
                    statement = s;
                    break;
                }
                Type type = Type.Unknown;
                if (Token.eq(token, "{") || Token.eq(token, "}") || Token.eq(token, "(") || Token.eq(token, ")") || Token.eq(token, "[") || Token.eq(token, "]") || Token.eq(token, "|") || Token.eq(token, ";") || Token.eq(token, "=")) {
                    type = Type.Reserved;
                } else if (token.charAt(0) == '\'' || token.charAt(0) == '\"') {
                    type = Type.String;
                } else if (token.toString().matches("^[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?$")) {
                    type = Type.Number;
                } else if (token.charAt(0) == '$') {
                    type = Type.Variable;
                } else if (((Set)this.session.get(".constants")).contains(token.toString()) || Token.eq(token, "null") || Token.eq(token, "false") || Token.eq(token, "true")) {
                    type = Type.Constant;
                } else {
                    boolean isAssign;
                    boolean isFirst = statement != null && statement.tokens().size() > 0 && token == statement.tokens().get(0);
                    boolean isThirdWithNext = statement != null && statement.tokens().size() > 3 && token == statement.tokens().get(2);
                    boolean bl = isAssign = statement != null && statement.tokens().size() > 1 && Token.eq(statement.tokens().get(1), "=");
                    if (isFirst && isAssign) {
                        type = Type.VariableName;
                    }
                    if (isFirst && !isAssign || isAssign && isThirdWithNext) {
                        Object v = this.session.get(Shell.resolve(this.session, token.toString()));
                        type = v instanceof Function ? Type.Function : Type.BadFunction;
                    }
                }
                Arrays.fill((Object[])types, token.start(), Math.min(token.start() + token.length(), types.length), (Object)type);
                cur = Math.min(token.start() + token.length(), buffer.length());
            }
            if (buffer.length() < repaired.length()) {
                Arrays.fill((Object[])types, buffer.length(), repaired.length(), (Object)Type.Repair);
            }
            AttributedStringBuilder sb = new AttributedStringBuilder();
            Type prevType = Type.Unknown;
            for (int i = 0; i < repaired.length(); ++i) {
                char c;
                if (i == underlineStart) {
                    sb.style(sb.style().underline());
                }
                if (i == negativeStart) {
                    sb.style(sb.style().inverse());
                }
                if (types[i] != prevType) {
                    prevType = types[i];
                    switch (prevType) {
                        case Reserved: {
                            sb.style(sb.style().foreground(5));
                            break;
                        }
                        case String: 
                        case Number: 
                        case Constant: {
                            sb.style(sb.style().foreground(2));
                            break;
                        }
                        case Variable: 
                        case VariableName: {
                            sb.style(sb.style().foreground(6));
                            break;
                        }
                        case Function: {
                            sb.style(sb.style().foreground(12));
                            break;
                        }
                        case BadFunction: {
                            sb.style(sb.style().foreground(9));
                            break;
                        }
                        case Repair: {
                            sb.style(sb.style().foreground(8));
                            break;
                        }
                        default: {
                            sb.style(sb.style().foregroundDefault());
                        }
                    }
                }
                if ((c = repaired.charAt(i)) == '\t' || c == '\n') {
                    sb.append(c);
                } else if (c < ' ') {
                    sb.style(sb.style().inverseNeg()).append('^').append((char)(c + 64)).style(sb.style().inverseNeg());
                } else {
                    int w = WCWidth.wcwidth((int)c);
                    if (w > 0) {
                        sb.append(c);
                    }
                }
                if (i == underlineEnd) {
                    sb.style(sb.style().underlineOff());
                }
                if (i != negativeEnd) continue;
                sb.style(sb.style().inverseOff());
            }
            return sb.toAttributedString();
        }
        catch (SyntaxError e) {
            return super.highlight(reader, buffer);
        }
    }

    static enum Type {
        Reserved,
        String,
        Number,
        Variable,
        VariableName,
        Function,
        BadFunction,
        Value,
        Constant,
        Unknown,
        Repair;

    }
}

