/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.gogo.jline.Expander;
import org.apache.felix.gogo.jline.Highlighter;
import org.apache.felix.gogo.jline.ParsedLineImpl;
import org.apache.felix.gogo.jline.Parser;
import org.apache.felix.gogo.runtime.Closure;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.gogo.runtime.Reflective;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Descriptor;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.command.Job;
import org.apache.felix.service.command.Parameter;
import org.jline.builtins.Completers;
import org.jline.builtins.Options;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.LineReaderImpl;
import org.jline.terminal.Terminal;

public class Shell {
    public static final String VAR_COMPLETIONS = ".completions";
    public static final String VAR_COMMAND_LINE = ".commandLine";
    public static final String VAR_READER = ".reader";
    public static final String VAR_SESSION = ".session";
    public static final String VAR_PROCESSOR = ".processor";
    public static final String VAR_TERMINAL = ".terminal";
    public static final String VAR_EXCEPTION = "exception";
    public static final String VAR_RESULT = "_";
    public static final String VAR_LOCATION = ".location";
    public static final String VAR_PROMPT = "prompt";
    public static final String VAR_RPROMPT = "rprompt";
    public static final String VAR_SCOPE = "SCOPE";
    public static final String VAR_CONTEXT = ".context";
    static final String[] functions = new String[]{"gosh", "sh", "source", "help"};
    private final URI baseURI;
    private final String profile;
    private final Context context;
    private final CommandProcessor processor;
    private AtomicBoolean stopping = new AtomicBoolean();

    public Shell(Context context, CommandProcessor processor) {
        this(context, processor, null);
    }

    public Shell(Context context, CommandProcessor processor, String profile) {
        this.context = context;
        this.processor = processor;
        String baseDir = context.getProperty("gosh.home");
        baseDir = baseDir == null ? context.getProperty("user.dir") : baseDir;
        this.baseURI = new File(baseDir).toURI();
        this.profile = profile != null ? profile : "gosh_profile";
    }

    public Context getContext() {
        return this.context;
    }

    public static Terminal getTerminal(CommandSession session) {
        return (Terminal)session.get(VAR_TERMINAL);
    }

    public static LineReader getReader(CommandSession session) {
        return (LineReader)session.get(VAR_READER);
    }

    public static CommandProcessor getProcessor(CommandSession session) {
        return (CommandProcessor)session.get(VAR_PROCESSOR);
    }

    public static Map<String, List<Completers.CompletionData>> getCompletions(CommandSession session) {
        return (Map)session.get(VAR_COMPLETIONS);
    }

    public static Set<String> getCommands(CommandSession session) {
        return (Set)session.get(".commands");
    }

    public static ParsedLine getParsedLine(CommandSession session) {
        return (ParsedLine)session.get(VAR_COMMAND_LINE);
    }

    public static String getPrompt(CommandSession session) {
        return Shell.expand(session, VAR_PROMPT, "gl! ");
    }

    public static String getRPrompt(CommandSession session) {
        return Shell.expand(session, VAR_RPROMPT, null);
    }

    public static String expand(CommandSession session, String name, String def) {
        Object prompt = session.get(name);
        if (prompt != null) {
            try {
                Object o = org.apache.felix.gogo.runtime.Expander.expand(prompt.toString(), new Closure((CommandSessionImpl)session, null, null));
                if (o != null) {
                    return o.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static String resolve(CommandSession session, String command) {
        String resolved = command;
        if (command.indexOf(58) < 0) {
            Set<String> commands = Shell.getCommands(session);
            Object path = session.get(VAR_SCOPE);
            String scopePath = null == path ? "*" : path.toString();
            block0: for (String scope : scopePath.split(":")) {
                for (String entry : commands) {
                    if ((!"*".equals(scope) || !entry.endsWith(":" + command)) && !entry.equals(scope + ":" + command)) continue;
                    resolved = entry;
                    continue block0;
                }
            }
        }
        return resolved;
    }

    public static CharSequence readScript(URI script) throws Exception {
        URLConnection conn = script.toURL().openConnection();
        int length = conn.getContentLength();
        if (length == -1) {
            System.err.println("eek! unknown Contentlength for: " + script);
            length = 10240;
        }
        InputStream in = conn.getInputStream();
        CharBuffer cbuf = CharBuffer.allocate(length);
        InputStreamReader reader = new InputStreamReader(in);
        ((Reader)reader).read(cbuf);
        in.close();
        cbuf.rewind();
        return cbuf;
    }

    static Set<String> getVariables(CommandSession session) {
        return (Set)session.get(".variables");
    }

    private static <T extends Annotation> T findAnnotation(Annotation[] anns, Class<T> clazz) {
        for (int i = 0; anns != null && i < anns.length; ++i) {
            if (!clazz.isInstance(anns[i])) continue;
            return (T)((Annotation)clazz.cast(anns[i]));
        }
        return null;
    }

    public void stop() {
        this.stopping.set(true);
    }

    public Object gosh(final CommandSession session, String[] argv) throws Exception {
        LineReader reader;
        CommandSession newSession;
        boolean interactive;
        String[] usage = new String[]{"gosh - execute script with arguments in a new session", "  args are available as session variables $1..$9 and $args.", "Usage: gosh [OPTIONS] [script-file [args..]]", "  -c --command             pass all remaining args to sub-shell", "     --nointeractive       don't start interactive session", "     --login               login shell (same session, reads etc/gosh_profile)", "  -s --noshutdown          don't shutdown framework when script completes", "  -x --xtrace              echo commands before execution", "  -? --help                show help", "If no script-file, an interactive shell is started, type $D to exit."};
        Options opt = Options.compile((String[])usage).setOptionsFirst(true).parse((Object[])argv);
        List args = opt.args();
        boolean login = opt.isSet("login");
        boolean bl = interactive = !opt.isSet("nointeractive");
        if (opt.isSet("help")) {
            opt.usage(System.err);
            if (login && !opt.isSet("noshutdown")) {
                this.shutdown();
            }
            return null;
        }
        if (opt.isSet("command") && args.isEmpty()) {
            throw opt.usageError("option --command requires argument(s)");
        }
        CommandSession commandSession = newSession = login ? session : this.processor.createSession(session);
        if (opt.isSet("xtrace")) {
            newSession.put("echo", true);
        }
        Shell.getVariables(session).stream().filter(key -> key.matches("[.]?[A-Z].*")).forEach(key -> newSession.put((String)key, session.get((String)key)));
        Terminal terminal = Shell.getTerminal(session);
        newSession.put(VAR_CONTEXT, this.context);
        newSession.put(VAR_TERMINAL, terminal);
        newSession.put(VAR_PROCESSOR, this.processor);
        newSession.put(VAR_SESSION, session);
        newSession.put("#TERM", (s, arguments) -> terminal.getType());
        newSession.put("#COLUMNS", (s, arguments) -> terminal.getWidth());
        newSession.put("#LINES", (s, arguments) -> terminal.getHeight());
        newSession.put("#PWD", (s, arguments) -> s.currentDir().toString());
        newSession.put("history-file", Paths.get(System.getProperty("user.home"), ".gogo.history"));
        if (args.isEmpty() && interactive) {
            Completers.CompletionEnvironment completionEnvironment = new Completers.CompletionEnvironment(){

                public Map<String, List<Completers.CompletionData>> getCompletions() {
                    return Shell.getCompletions(newSession);
                }

                public Set<String> getCommands() {
                    return Shell.getCommands(session);
                }

                public String resolveCommand(String command) {
                    return Shell.resolve(session, command);
                }

                public String commandName(String command) {
                    int idx = command.indexOf(58);
                    return idx >= 0 ? command.substring(idx + 1) : command;
                }

                public Object evaluate(LineReader reader, ParsedLine line, String func) throws Exception {
                    session.put(Shell.VAR_COMMAND_LINE, line);
                    return session.execute(func);
                }
            };
            reader = LineReaderBuilder.builder().terminal(terminal).variables(((CommandSessionImpl)newSession).getVariables()).completer((Completer)new Completers.Completer(completionEnvironment)).highlighter((org.jline.reader.Highlighter)new Highlighter(session)).parser((org.jline.reader.Parser)new Parser()).expander((org.jline.reader.Expander)new Expander(newSession)).build();
            reader.setOpt(LineReader.Option.AUTO_FRESH_LINE);
            newSession.put(VAR_READER, reader);
            newSession.put(VAR_COMPLETIONS, new HashMap());
        } else {
            reader = null;
        }
        if (login || interactive) {
            URI uri = this.baseURI.resolve("etc/" + this.profile);
            if (!new File(uri).exists()) {
                URL url = this.getClass().getResource("/ext/" + this.profile);
                if (url == null) {
                    url = this.getClass().getResource("/" + this.profile);
                }
                URI uRI = uri = url == null ? null : url.toURI();
            }
            if (uri != null) {
                this.source(newSession, uri.toString());
            }
        }
        Object result = null;
        if (args.isEmpty()) {
            if (interactive) {
                result = this.runShell(session, newSession, terminal, reader);
            }
        } else {
            CharSequence program;
            if (opt.isSet("command")) {
                StringBuilder buf = new StringBuilder();
                for (String arg : args) {
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(arg);
                }
                program = buf;
            } else {
                URI script = session.currentDir().toUri().resolve((String)args.remove(0));
                newSession.put("0", script);
                newSession.put("args", args);
                for (int i = 0; i < args.size(); ++i) {
                    newSession.put(String.valueOf(i + 1), args.get(i));
                }
                program = Shell.readScript(script);
            }
            result = newSession.execute(program);
        }
        if (login && interactive && !opt.isSet("noshutdown")) {
            System.out.println("gosh: stopping framework");
            this.shutdown();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runShell(CommandSession session, CommandSession newSession, Terminal terminal, LineReader reader) throws InterruptedException {
        Object result;
        block15: {
            AtomicBoolean reading = new AtomicBoolean();
            newSession.setJobListener((job, previous, current) -> {
                if (previous == Job.Status.Background || current == Job.Status.Background || previous == Job.Status.Suspended || current == Job.Status.Suspended) {
                    int width = terminal.getWidth();
                    String status = current.name().toLowerCase();
                    terminal.writer().write(this.getStatusLine(job, width, status));
                    terminal.flush();
                    if (reading.get() && !this.stopping.get()) {
                        ((LineReaderImpl)reader).redrawLine();
                        ((LineReaderImpl)reader).redisplay();
                    }
                }
            });
            Terminal.SignalHandler intHandler = terminal.handle(Terminal.Signal.INT, s -> {
                Job current = newSession.foregroundJob();
                if (current != null) {
                    current.interrupt();
                }
            });
            Terminal.SignalHandler suspHandler = terminal.handle(Terminal.Signal.TSTP, s -> {
                Job current = newSession.foregroundJob();
                if (current != null) {
                    current.suspend();
                }
            });
            result = null;
            block12: while (true) {
                while (!this.stopping.get()) {
                    try {
                        reading.set(true);
                        try {
                            String prompt = Shell.getPrompt(session);
                            String rprompt = Shell.getRPrompt(session);
                            if (this.stopping.get()) break block15;
                            reader.readLine(prompt, rprompt, null, null);
                        }
                        finally {
                            reading.set(false);
                        }
                        ParsedLine parsedLine = reader.getParsedLine();
                        if (parsedLine == null) {
                            throw new EndOfFileException();
                        }
                        try {
                            result = session.execute(((ParsedLineImpl)parsedLine).program());
                            session.put(VAR_RESULT, result);
                            if (result == null || Boolean.FALSE.equals(session.get(".Gogo.format"))) continue block12;
                            System.out.println(session.format(result, 0));
                            continue block12;
                        }
                        catch (Exception e) {
                            session.put(VAR_EXCEPTION, e);
                        }
                    }
                    catch (UserInterruptException parsedLine) {
                    }
                    catch (EndOfFileException e) {
                        reader.getHistory().save();
                        break block15;
                    }
                }
                break block15;
                {
                    continue block12;
                    break;
                }
                break;
            }
            finally {
                terminal.handle(Terminal.Signal.INT, intHandler);
                terminal.handle(Terminal.Signal.TSTP, suspHandler);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitJobCompletion(CommandSession session) throws InterruptedException {
        Job job;
        while ((job = session.foregroundJob()) != null) {
            Job job2 = job;
            synchronized (job2) {
                if (job.status() == Job.Status.Foreground) {
                    job.wait();
                }
            }
        }
    }

    private String getStatusLine(Job job, int width, String status) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < width - 1; ++i) {
            sb.append(' ');
        }
        sb.append('\r');
        sb.append("[").append(job.id()).append("]  ");
        sb.append(status);
        for (i = status.length(); i < "background".length(); ++i) {
            sb.append(' ');
        }
        sb.append("  ").append(job.command()).append("\n");
        return sb.toString();
    }

    @Descriptor(value="start a new shell")
    public Object sh(CommandSession session, String[] argv) throws Exception {
        return this.gosh(session, argv);
    }

    private void shutdown() throws Exception {
        this.context.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Descriptor(value="Evaluates contents of file")
    public Object source(CommandSession session, String script) throws Exception {
        URI uri = session.currentDir().toUri().resolve(script);
        session.put("0", uri);
        try {
            Object object = session.execute(Shell.readScript(uri));
            return object;
        }
        finally {
            session.put("0", null);
        }
    }

    private Map<String, List<Method>> getReflectionCommands(CommandSession session) {
        TreeMap<String, List<Method>> commands = new TreeMap<String, List<Method>>();
        Set<String> names = Shell.getCommands(session);
        for (String name : names) {
            Function function = (Function)session.get(name);
            if (!(function instanceof CommandProxy)) continue;
            Object target = ((CommandProxy)function).getTarget();
            ArrayList<Method> methods = new ArrayList<Method>();
            String func = name.substring(name.indexOf(58) + 1).toLowerCase();
            ArrayList<String> funcs = new ArrayList<String>();
            funcs.add("is" + func);
            funcs.add("get" + func);
            funcs.add("set" + func);
            if (Reflective.KEYWORDS.contains(func)) {
                funcs.add(VAR_RESULT + func);
            } else {
                funcs.add(func);
            }
            for (Method method : target.getClass().getMethods()) {
                if (!funcs.contains(method.getName().toLowerCase())) continue;
                methods.add(method);
            }
            commands.put(name, methods);
            ((CommandProxy)function).ungetTarget();
        }
        return commands;
    }

    @Descriptor(value="displays available commands")
    public void help(CommandSession session) {
        Map<String, List<Method>> commands = this.getReflectionCommands(session);
        commands.keySet().forEach(System.out::println);
    }

    @Descriptor(value="displays information about a specific command")
    public void help(CommandSession session, @Descriptor(value="target command") String name) {
        Map<String, List<Method>> commands = this.getReflectionCommands(session);
        List<Method> methods = null;
        int scopeIdx = name.indexOf(58);
        if (scopeIdx < 0) {
            for (Map.Entry<String, List<Method>> entry : commands.entrySet()) {
                String k = entry.getKey().substring(entry.getKey().indexOf(58) + 1);
                if (!name.equals(k)) continue;
                name = entry.getKey();
                methods = entry.getValue();
                break;
            }
        } else {
            methods = commands.get(name);
        }
        if (methods != null && methods.size() > 0) {
            for (Method m : methods) {
                int aliasIdx;
                String[] names;
                Descriptor d = m.getAnnotation(Descriptor.class);
                if (d == null) {
                    System.out.println("\n" + m.getName());
                } else {
                    System.out.println("\n" + m.getName() + " - " + d.value());
                }
                System.out.println("   scope: " + name.substring(0, name.indexOf(58)));
                Class<?>[] paramTypes = m.getParameterTypes();
                TreeMap<String, Parameter> flags = new TreeMap<String, Parameter>();
                TreeMap<String, String> flagDescs = new TreeMap<String, String>();
                TreeMap<String, Parameter> options = new TreeMap<String, Parameter>();
                TreeMap<String, String> optionDescs = new TreeMap<String, String>();
                ArrayList<String> params = new ArrayList<String>();
                Annotation[][] anns = m.getParameterAnnotations();
                for (int paramIdx = 0; paramIdx < anns.length; ++paramIdx) {
                    Class<?> paramType = m.getParameterTypes()[paramIdx];
                    if (paramType == CommandSession.class) continue;
                    Parameter p = Shell.findAnnotation(anns[paramIdx], Parameter.class);
                    d = Shell.findAnnotation(anns[paramIdx], Descriptor.class);
                    if (p != null) {
                        if (p.presentValue().equals("org.apache.felix.service.command.unspecified.parameter")) {
                            options.put(p.names()[0], p);
                            if (d == null) continue;
                            optionDescs.put(p.names()[0], d.value());
                            continue;
                        }
                        flags.put(p.names()[0], p);
                        if (d == null) continue;
                        flagDescs.put(p.names()[0], d.value());
                        continue;
                    }
                    if (d != null) {
                        params.add(paramTypes[paramIdx].getSimpleName());
                        params.add(d.value());
                        continue;
                    }
                    params.add(paramTypes[paramIdx].getSimpleName());
                    params.add("");
                }
                if (flags.size() > 0) {
                    System.out.println("   flags:");
                    for (Map.Entry entry : flags.entrySet()) {
                        names = ((Parameter)entry.getValue()).names();
                        System.out.print("      " + names[0]);
                        for (aliasIdx = 1; aliasIdx < names.length; ++aliasIdx) {
                            System.out.print(", " + names[aliasIdx]);
                        }
                        System.out.println("   " + (String)flagDescs.get(entry.getKey()));
                    }
                }
                if (options.size() > 0) {
                    System.out.println("   options:");
                    for (Map.Entry entry : options.entrySet()) {
                        names = ((Parameter)entry.getValue()).names();
                        System.out.print("      " + names[0]);
                        for (aliasIdx = 1; aliasIdx < names.length; ++aliasIdx) {
                            System.out.print(", " + names[aliasIdx]);
                        }
                        System.out.println("   " + (String)optionDescs.get(entry.getKey()) + (((Parameter)entry.getValue()).absentValue() == null ? "" : " [optional]"));
                    }
                }
                if (params.size() <= 0) continue;
                System.out.println("   parameters:");
                Iterator it = params.iterator();
                while (it.hasNext()) {
                    System.out.println("      " + (String)it.next() + "   " + (String)it.next());
                }
            }
        }
    }

    public static interface Context {
        public String getProperty(String var1);

        public void exit() throws Exception;
    }
}

