/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.osgi;

import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.impl.console.JLineTerminal;
import org.apache.karaf.shell.impl.console.osgi.DelayedStarted;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.util.jaas.JaasHelper;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class LocalConsoleManager {
    private static final String INPUT_ENCODING = "input.encoding";
    private static final String KARAF_DELAY_CONSOLE = "karaf.delay.console";
    private static final String KARAF_LOCAL_USER = "karaf.local.user";
    private static final String KARAF_LOCAL_ROLES = "karaf.local.roles";
    private static final String KARAF_LOCAL_ROLES_DEFAULT = "admin,manager,viewer,systembundles";
    private SessionFactory sessionFactory;
    private BundleContext bundleContext;
    private Session session;
    private ServiceRegistration<?> registration;
    private boolean closing;

    public LocalConsoleManager(BundleContext bundleContext, SessionFactory sessionFactory) throws Exception {
        this.bundleContext = bundleContext;
        this.sessionFactory = sessionFactory;
    }

    public void start() throws Exception {
        final Terminal terminal = TerminalBuilder.builder().nativeSignals(true).signalHandler(Terminal.SignalHandler.SIG_IGN).build();
        Subject subject = this.createLocalKarafSubject();
        this.session = JaasHelper.doAs(subject, new PrivilegedAction<Session>(){

            @Override
            public Session run() {
                String encoding = LocalConsoleManager.getEncoding();
                LocalConsoleManager.this.session = LocalConsoleManager.this.sessionFactory.create(terminal.input(), new PrintStream(terminal.output()), new PrintStream(terminal.output()), new JLineTerminal(terminal), encoding, LocalConsoleManager.this::close);
                LocalConsoleManager.this.registration = LocalConsoleManager.this.bundleContext.registerService(Session.class, (Object)LocalConsoleManager.this.session, null);
                String name = "Karaf local console user " + ShellUtil.getCurrentUserName();
                boolean delayconsole = Boolean.parseBoolean(System.getProperty(LocalConsoleManager.KARAF_DELAY_CONSOLE));
                if (delayconsole) {
                    DelayedStarted watcher = new DelayedStarted(LocalConsoleManager.this.session, name, LocalConsoleManager.this.bundleContext, System.in);
                    new Thread(watcher).start();
                } else {
                    new Thread((Runnable)LocalConsoleManager.this.session, name).start();
                }
                return LocalConsoleManager.this.session;
            }
        });
    }

    public static String getEncoding() {
        String envEncoding = LocalConsoleManager.extractEncodingFromCtype(System.getenv("LC_CTYPE"));
        if (envEncoding != null) {
            return envEncoding;
        }
        return System.getProperty(INPUT_ENCODING, Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String ctype) {
        if (ctype != null && ctype.indexOf(46) > 0) {
            String encodingAndModifier = ctype.substring(ctype.indexOf(46) + 1);
            if (encodingAndModifier.indexOf(64) > 0) {
                return encodingAndModifier.substring(0, encodingAndModifier.indexOf(64));
            }
            return encodingAndModifier;
        }
        return null;
    }

    private Subject createLocalKarafSubject() {
        String userName = System.getProperty(KARAF_LOCAL_USER);
        if (userName == null) {
            userName = "karaf";
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UserPrincipal(userName));
        String roles = System.getProperty(KARAF_LOCAL_ROLES, KARAF_LOCAL_ROLES_DEFAULT);
        if (roles != null) {
            for (String role : roles.split("[,]")) {
                subject.getPrincipals().add((Principal)new RolePrincipal(role.trim()));
            }
        }
        return subject;
    }

    public void stop() throws Exception {
        this.closing = true;
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.session != null) {
            this.session.close();
        }
    }

    protected void close() {
        try {
            if (!this.closing) {
                this.bundleContext.getBundle(0L).stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

