/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.security.PublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.karaf.jaas.modules.publickey.PublickeyCallback;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafJaasAuthenticator
implements PasswordAuthenticator,
PublickeyAuthenticator {
    public static final AttributeStore.AttributeKey<Subject> SUBJECT_ATTRIBUTE_KEY = new AttributeStore.AttributeKey();
    private final Logger LOGGER = LoggerFactory.getLogger(KarafJaasAuthenticator.class);
    private String realm;

    public KarafJaasAuthenticator() {
    }

    public KarafJaasAuthenticator(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean authenticate(final String username, final String password, ServerSession session) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                            continue;
                        }
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            });
            loginContext.login();
            session.setAttribute(SUBJECT_ATTRIBUTE_KEY, (Object)subject);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.debug("User authentication failed with " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean authenticate(final String username, final PublicKey key, ServerSession session) {
        try {
            Subject subject = new Subject();
            LoginContext loginContext = new LoginContext(this.realm, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof NameCallback) {
                            ((NameCallback)callback).setName(username);
                            continue;
                        }
                        if (callback instanceof PublickeyCallback) {
                            ((PublickeyCallback)callback).setPublicKey(key);
                            continue;
                        }
                        throw new UnsupportedCallbackException(callback);
                    }
                }
            });
            loginContext.login();
            session.setAttribute(SUBJECT_ATTRIBUTE_KEY, (Object)subject);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.debug("User authentication failed with " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

