/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.util.ArrayList;
import org.apache.commons.ssl.PEMUtil;
import org.apache.commons.ssl.PKCS8Key;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;

public class OpenSSHGeneratorFileKeyProvider
extends AbstractGeneratorHostKeyProvider {
    private String password;

    public OpenSSHGeneratorFileKeyProvider() {
    }

    public OpenSSHGeneratorFileKeyProvider(String path) {
        this.setPath(Paths.get(path, new String[0]));
    }

    public OpenSSHGeneratorFileKeyProvider(String path, String algorithm) {
        this(path);
        this.setAlgorithm(algorithm);
    }

    public OpenSSHGeneratorFileKeyProvider(String path, String algorithm, int keySize) {
        this(path, algorithm);
        this.setKeySize(keySize);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected KeyPair doReadKeyPair(String resourceKey, InputStream is) throws IOException, GeneralSecurityException {
        PKCS8Key pkcs8 = new PKCS8Key(is, this.password == null ? null : this.password.toCharArray());
        return new KeyPair(pkcs8.getPublicKey(), pkcs8.getPrivateKey());
    }

    protected void doWriteKeyPair(String resourceKey, KeyPair kp, OutputStream os) throws IOException, GeneralSecurityException {
        ArrayList<Key> items = new ArrayList<Key>();
        items.add(kp.getPrivate());
        items.add(kp.getPublic());
        byte[] bytes = PEMUtil.encode(items);
        os.write(bytes);
    }
}

