/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.extension;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class Activator
implements BundleActivator,
ResolverHook,
SynchronousBundleListener,
ResolverHookFactory {
    private static final String WIRING_PATH = "wiring";
    private final Map<Long, Map<String, String>> wiring = new HashMap<Long, Map<String, String>>();
    private BundleContext bundleContext;

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.load();
        context.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        if (event.getBundle().getBundleId() == 0L && event.getType() == 2) {
            ServiceRegistration registration = this.bundleContext.registerService(ResolverHookFactory.class, (Object)this, null);
            try {
                List bundles = this.wiring.keySet().stream().map(id -> this.bundleContext.getBundle(id.longValue())).collect(Collectors.toList());
                ((FrameworkWiring)this.bundleContext.getBundle().adapt(FrameworkWiring.class)).resolveBundles(bundles);
            }
            finally {
                registration.unregister();
            }
        }
        if (event.getType() == 32 || event.getType() == 64) {
            Map<Long, Map<String, String>> map = this.wiring;
            synchronized (map) {
                long id2 = event.getBundle().getBundleId();
                if (event.getType() == 32) {
                    HashMap<String, String> bw = new HashMap<String, String>();
                    for (BundleWire wire : ((BundleWiring)event.getBundle().adapt(BundleWiring.class)).getRequiredWires(null)) {
                        bw.put(this.getRequirementId((Requirement)wire.getRequirement()), this.getCapabilityId(wire.getCapability()));
                    }
                    this.wiring.put(id2, bw);
                    this.saveWiring(id2, bw);
                } else {
                    this.wiring.remove(id2);
                    this.saveWiring(id2, null);
                }
            }
        }
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        long sourceId = requirement.getRevision().getBundle().getBundleId();
        if (Activator.isFragment((Resource)requirement.getRevision()) && !requirement.getNamespace().equals("osgi.wiring.host")) {
            sourceId = this.wiring.get(sourceId).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("osgi.wiring.host")).map(Map.Entry::getValue).mapToLong(s -> {
                int idx = s.indexOf(59);
                if (idx > 0) {
                    s = s.substring(0, idx);
                }
                return Long.parseLong(s.trim());
            }).findFirst().orElse(-1L);
        }
        Map<String, String> bw = this.wiring.get(sourceId);
        String cap = bw.get(this.getRequirementId((Requirement)requirement));
        Iterator<BundleCapability> candIter = candidates.iterator();
        while (candIter.hasNext()) {
            BundleCapability cand = candIter.next();
            if ((cap == null || cap.equals(this.getCapabilityId(cand))) && (cap != null || cand.getRevision().getBundle().getBundleId() == sourceId)) continue;
            candIter.remove();
        }
    }

    public void end() {
    }

    public ResolverHook begin(Collection<BundleRevision> triggers) {
        return this;
    }

    private void load() {
        try {
            Path dir = this.bundleContext.getDataFile(WIRING_PATH).toPath();
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.list(dir).forEach(p -> {
                String name = p.getFileName().toString();
                if (name.matches("[0-9]+")) {
                    try (BufferedReader reader = Files.newBufferedReader(p);){
                        long id = Long.parseLong(name);
                        HashMap<String, String> map = new HashMap<String, String>();
                        while (true) {
                            String key = reader.readLine();
                            String val = reader.readLine();
                            if (key == null || val == null) break;
                            map.put(key, val);
                        }
                        this.wiring.put(id, map);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void saveWiring(long id, Map<String, String> wiring) {
        block16: {
            try {
                Path dir = this.bundleContext.getDataFile(WIRING_PATH).toPath();
                Files.createDirectories(dir, new FileAttribute[0]);
                Path file = dir.resolve(Long.toString(id));
                if (wiring != null) {
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    try (BufferedWriter fw = Files.newBufferedWriter(file, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                        for (Map.Entry<String, String> wire : wiring.entrySet()) {
                            fw.append(wire.getKey()).append('\n');
                            fw.append(wire.getValue()).append('\n');
                        }
                        break block16;
                    }
                }
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private String getRequirementId(Requirement requirement) {
        String filter = (String)requirement.getDirectives().get("filter");
        if (filter != null) {
            return requirement.getNamespace() + "; " + filter;
        }
        return requirement.getNamespace();
    }

    private String getCapabilityId(BundleCapability capability) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(capability.getRevision().getBundle().getBundleId());
        Object v = capability.getAttributes().get("version");
        if (v != null) {
            sb.append("; version=").append(v.toString());
        }
        return sb.toString();
    }

    private static boolean isFragment(Resource resource) {
        for (Capability cap : resource.getCapabilities(null)) {
            if (!"osgi.identity".equals(cap.getNamespace())) continue;
            return "osgi.fragment".equals(cap.getAttributes().get("type"));
        }
        return false;
    }
}

