/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.core.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.karaf.config.core.ConfigMBean;
import org.apache.karaf.config.core.ConfigRepository;
import org.osgi.service.cm.Configuration;

public class ConfigMBeanImpl
extends StandardMBean
implements ConfigMBean {
    private ConfigRepository configRepo;

    public ConfigMBeanImpl() throws NotCompliantMBeanException {
        super(ConfigMBean.class);
    }

    private Configuration getConfiguration(String pid) throws IOException {
        Configuration configuration = this.configRepo.getConfigAdmin().getConfiguration(pid, null);
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration PID " + pid + " doesn't exist");
        }
        return configuration;
    }

    private Dictionary<String, Object> getConfigProperties(String pid) throws IOException {
        Configuration configuration = this.getConfiguration(pid);
        Hashtable<Object, Object> dictionary = configuration.getProperties();
        if (dictionary == null) {
            dictionary = new Hashtable<Object, Object>(new Properties());
        }
        return dictionary;
    }

    @Override
    public List<String> getConfigs() throws MBeanException {
        try {
            Configuration[] configurations = this.configRepo.getConfigAdmin().listConfigurations(null);
            ArrayList<String> pids = new ArrayList<String>();
            for (int i = 0; i < configurations.length; ++i) {
                pids.add(configurations[i].getPid());
            }
            return pids;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void create(String pid) throws MBeanException {
        try {
            this.configRepo.update(pid, new Hashtable<String, Object>());
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void delete(String pid) throws MBeanException {
        try {
            this.configRepo.delete(pid);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public Map<String, String> listProperties(String pid) throws MBeanException {
        try {
            Dictionary<String, Object> dictionary = this.getConfigProperties(pid);
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            Enumeration<String> e = dictionary.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object value = dictionary.get(key);
                propertiesMap.put(key.toString(), value.toString());
            }
            return propertiesMap;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void deleteProperty(String pid, String key) throws MBeanException {
        try {
            Dictionary<String, Object> dictionary = this.getConfigProperties(pid);
            dictionary.remove(key);
            this.configRepo.update(pid, dictionary);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void appendProperty(String pid, String key, String value) throws MBeanException {
        try {
            Dictionary<String, Object> dictionary = this.getConfigProperties(pid);
            Object currentValue = dictionary.get(key);
            if (currentValue == null) {
                dictionary.put(key, value);
            } else if (currentValue instanceof String) {
                dictionary.put(key, currentValue + value);
            } else {
                throw new IllegalStateException("Current value is not a String");
            }
            this.configRepo.update(pid, dictionary);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void setProperty(String pid, String key, String value) throws MBeanException {
        try {
            Dictionary<String, Object> dictionary = this.getConfigProperties(pid);
            dictionary.put(key, value);
            this.configRepo.update(pid, dictionary);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public String getProperty(String pid, String key) throws MBeanException {
        try {
            Dictionary<String, Object> dictionary = this.getConfigProperties(pid);
            Object value = dictionary.get(key);
            if (value != null) {
                return value.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    @Override
    public void update(String pid, Map<String, String> properties) throws MBeanException {
        try {
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            Dictionary<String, Object> dictionary = this.toDictionary(properties);
            this.configRepo.update(pid, dictionary);
        }
        catch (Exception e) {
            throw new MBeanException(null, e.toString());
        }
    }

    private Dictionary<String, Object> toDictionary(Map<String, String> properties) {
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        for (String key : properties.keySet()) {
            ((Dictionary)dictionary).put(key, properties.get(key));
        }
        return dictionary;
    }

    public void setConfigRepo(ConfigRepository configRepo) {
        this.configRepo = configRepo;
    }

    @Override
    public String createFactoryConfiguration(String factoryPid, Map<String, String> properties) throws MBeanException {
        Dictionary<String, Object> dict = this.toDictionary(properties);
        return this.configRepo.createFactoryConfiguration(factoryPid, dict);
    }
}

