/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.common.AbstractAgentClient;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.server.channel.AbstractServerChannel;

public class ChannelAgentForwarding
extends AbstractServerChannel {
    private OutputStream out;
    private SshAgent agent;
    private AgentClient client;

    @Override
    protected OpenFuture doInit(Buffer buffer) {
        DefaultOpenFuture f = new DefaultOpenFuture(this);
        ChannelListener listener = this.getChannelListenerProxy();
        try {
            this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
            Session session = this.getSession();
            FactoryManager manager = ValidateUtils.checkNotNull(session.getFactoryManager(), "No factory manager");
            SshAgentFactory factory = ValidateUtils.checkNotNull(manager.getAgentFactory(), "No agent factory");
            this.agent = factory.createClient(manager);
            this.client = new AgentClient();
            listener.channelOpenSuccess(this);
            f.setOpened();
        }
        catch (Throwable t) {
            Throwable e;
            block6: {
                e = GenericUtils.peelException(t);
                try {
                    listener.channelOpenFailure(this, e);
                }
                catch (Throwable err) {
                    Throwable[] suppressed;
                    Throwable ignored = GenericUtils.peelException(err);
                    this.log.warn("doInit({}) failed ({}) to inform listener of open failure={}: {}", new Object[]{this, ignored.getClass().getSimpleName(), e.getClass().getSimpleName(), ignored.getMessage()});
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("doInit(" + this + ") inform listener open failure details", ignored);
                    }
                    if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = ignored.getSuppressed()) <= 0) break block6;
                    for (Throwable s : suppressed) {
                        this.log.trace("doInit(" + this + ") suppressed channel open failure signalling", s);
                    }
                }
            }
            f.setException(e);
        }
        return f;
    }

    private void closeImmediately0() {
        super.close(true);
    }

    @Override
    public CloseFuture close(boolean immediately) {
        return super.close(immediately).addListener(new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture sshFuture) {
                ChannelAgentForwarding.this.closeImmediately0();
            }
        });
    }

    @Override
    protected void doWriteData(byte[] data, int off, int len) throws IOException {
        this.client.messageReceived(new ByteArrayBuffer(data, off, len));
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException("AgentForward channel does not support extended data");
    }

    protected class AgentClient
    extends AbstractAgentClient {
        public AgentClient() {
            super(ChannelAgentForwarding.this.agent);
        }

        @Override
        protected void reply(Buffer buf) throws IOException {
            ChannelAgentForwarding.this.out.write(buf.array(), buf.rpos(), buf.available());
            ChannelAgentForwarding.this.out.flush();
        }
    }
}

