/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.util.GenericUtils;

public interface AuthenticationIdentitiesProvider
extends KeyIdentityProvider,
PasswordIdentityProvider {
    public Iterable<?> loadIdentities();

    public static final class Utils {
        public static final Comparator<Object> PASSWORD_IDENTITY_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof String) || !(o2 instanceof String)) {
                    return -1;
                }
                return ((String)o1).compareTo((String)o2);
            }
        };
        public static final Comparator<Object> KEYPAIR_IDENTITY_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof KeyPair) || !(o2 instanceof KeyPair)) {
                    return -1;
                }
                if (KeyUtils.compareKeyPairs((KeyPair)o1, (KeyPair)o2)) {
                    return 0;
                }
                return 1;
            }
        };

        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static int findIdentityIndex(List<?> identities, Comparator<? super Object> comp, Object target) {
            for (int index = 0; index < identities.size(); ++index) {
                Object value = identities.get(index);
                if (comp.compare(value, target) != 0) continue;
                return index;
            }
            return -1;
        }

        public static AuthenticationIdentitiesProvider wrap(final Iterable<?> identities) {
            return new AuthenticationIdentitiesProvider(){

                @Override
                public Iterable<KeyPair> loadKeys() {
                    return this.selectIdentities(KeyPair.class);
                }

                @Override
                public Iterable<String> loadPasswords() {
                    return this.selectIdentities(String.class);
                }

                @Override
                public Iterable<?> loadIdentities() {
                    return this.selectIdentities(Object.class);
                }

                private <T> Collection<T> selectIdentities(Class<T> type) {
                    LinkedList<T> matches = null;
                    Iterator iter = GenericUtils.iteratorOf(identities);
                    while (iter.hasNext()) {
                        Object o = iter.next();
                        Class<?> t = o.getClass();
                        if (!type.isAssignableFrom(t)) continue;
                        if (matches == null) {
                            matches = new LinkedList<T>();
                        }
                        matches.add(type.cast(o));
                    }
                    return matches == null ? Collections.emptyList() : matches;
                }
            };
        }
    }
}

