/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.client.subsystem.SubsystemClient;
import org.apache.sshd.client.subsystem.sftp.extensions.SftpClientExtension;
import org.apache.sshd.common.subsystem.sftp.SftpHelper;
import org.apache.sshd.common.subsystem.sftp.SftpUniversalOwnerAndGroup;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.bouncycastle.util.Arrays;

public interface SftpClient
extends SubsystemClient {
    public static final int MIN_BUFFER_SIZE = 127;
    public static final int MIN_READ_BUFFER_SIZE = 127;
    public static final int MIN_WRITE_BUFFER_SIZE = 127;
    public static final int IO_BUFFER_SIZE = 32768;
    public static final int DEFAULT_READ_BUFFER_SIZE = 32768;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = 32768;
    public static final long DEFAULT_WAIT_TIMEOUT;
    public static final String SFTP_CHANNEL_OPEN_TIMEOUT = "sftp-channel-open-timeout";
    public static final long DEFAULT_CHANNEL_OPEN_TIMEOUT;

    public int getVersion();

    public Map<String, byte[]> getServerExtensions();

    public boolean isClosing();

    public CloseableHandle open(String var1) throws IOException;

    public CloseableHandle open(String var1, OpenMode ... var2) throws IOException;

    public CloseableHandle open(String var1, Collection<OpenMode> var2) throws IOException;

    public void close(Handle var1) throws IOException;

    public void remove(String var1) throws IOException;

    public void rename(String var1, String var2) throws IOException;

    public void rename(String var1, String var2, CopyMode ... var3) throws IOException;

    public void rename(String var1, String var2, Collection<CopyMode> var3) throws IOException;

    public int read(Handle var1, long var2, byte[] var4) throws IOException;

    public int read(Handle var1, long var2, byte[] var4, AtomicReference<Boolean> var5) throws IOException;

    public int read(Handle var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    public int read(Handle var1, long var2, byte[] var4, int var5, int var6, AtomicReference<Boolean> var7) throws IOException;

    public void write(Handle var1, long var2, byte[] var4) throws IOException;

    public void write(Handle var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    public void mkdir(String var1) throws IOException;

    public void rmdir(String var1) throws IOException;

    public CloseableHandle openDir(String var1) throws IOException;

    public List<DirEntry> readDir(Handle var1) throws IOException;

    public List<DirEntry> readDir(Handle var1, AtomicReference<Boolean> var2) throws IOException;

    public String canonicalPath(String var1) throws IOException;

    public Attributes stat(String var1) throws IOException;

    public Attributes lstat(String var1) throws IOException;

    public Attributes stat(Handle var1) throws IOException;

    public void setStat(String var1, Attributes var2) throws IOException;

    public void setStat(Handle var1, Attributes var2) throws IOException;

    public String readLink(String var1) throws IOException;

    public void symLink(String var1, String var2) throws IOException;

    public void link(String var1, String var2, boolean var3) throws IOException;

    public void lock(Handle var1, long var2, long var4, int var6) throws IOException;

    public void unlock(Handle var1, long var2, long var4) throws IOException;

    public Iterable<DirEntry> readDir(String var1) throws IOException;

    public InputStream read(String var1) throws IOException;

    public InputStream read(String var1, int var2) throws IOException;

    public InputStream read(String var1, OpenMode ... var2) throws IOException;

    public InputStream read(String var1, int var2, OpenMode ... var3) throws IOException;

    public InputStream read(String var1, Collection<OpenMode> var2) throws IOException;

    public InputStream read(String var1, int var2, Collection<OpenMode> var3) throws IOException;

    public OutputStream write(String var1) throws IOException;

    public OutputStream write(String var1, int var2) throws IOException;

    public OutputStream write(String var1, OpenMode ... var2) throws IOException;

    public OutputStream write(String var1, int var2, OpenMode ... var3) throws IOException;

    public OutputStream write(String var1, Collection<OpenMode> var2) throws IOException;

    public OutputStream write(String var1, int var2, Collection<OpenMode> var3) throws IOException;

    public <E extends SftpClientExtension> E getExtension(Class<? extends E> var1);

    public SftpClientExtension getExtension(String var1);

    static {
        DEFAULT_CHANNEL_OPEN_TIMEOUT = DEFAULT_WAIT_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    }

    public static class DirEntry {
        private final String filename;
        private final String longFilename;
        private final Attributes attributes;

        DirEntry(String filename, String longFilename, Attributes attributes) {
            this.filename = filename;
            this.longFilename = longFilename;
            this.attributes = attributes;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getLongFilename() {
            return this.longFilename;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public String toString() {
            return this.getFilename() + "[" + this.getLongFilename() + "]: " + this.getAttributes();
        }
    }

    public static class Attributes {
        private Set<Attribute> flags = EnumSet.noneOf(Attribute.class);
        private int type = 5;
        private int perms;
        private int uid;
        private int gid;
        private String owner;
        private String group;
        private long size;
        private FileTime accessTime;
        private FileTime createTime;
        private FileTime modifyTime;
        private List<AclEntry> acl;
        private Map<String, byte[]> extensions = Collections.emptyMap();

        public Set<Attribute> getFlags() {
            return this.flags;
        }

        public Attributes addFlag(Attribute flag) {
            this.flags.add(flag);
            return this;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public long getSize() {
            return this.size;
        }

        public Attributes size(long size) {
            this.setSize(size);
            return this;
        }

        public void setSize(long size) {
            this.size = size;
            this.addFlag(Attribute.Size);
        }

        public String getOwner() {
            return this.owner;
        }

        public Attributes owner(String owner) {
            this.setOwner(owner);
            return this;
        }

        public void setOwner(String owner) {
            this.owner = ValidateUtils.checkNotNullAndNotEmpty(owner, "No owner");
            this.addFlag(Attribute.OwnerGroup);
            if (GenericUtils.isEmpty(this.getGroup())) {
                this.setGroup(SftpUniversalOwnerAndGroup.Group.getName());
            }
        }

        public String getGroup() {
            return this.group;
        }

        public Attributes group(String group) {
            this.setGroup(group);
            return this;
        }

        public void setGroup(String group) {
            this.group = ValidateUtils.checkNotNullAndNotEmpty(group, "No group");
            this.addFlag(Attribute.OwnerGroup);
            if (GenericUtils.isEmpty(this.getOwner())) {
                this.setOwner(SftpUniversalOwnerAndGroup.Owner.getName());
            }
        }

        public int getUserId() {
            return this.uid;
        }

        public int getGroupId() {
            return this.gid;
        }

        public Attributes owner(int uid, int gid) {
            this.uid = uid;
            this.gid = gid;
            this.addFlag(Attribute.UidGid);
            return this;
        }

        public int getPermissions() {
            return this.perms;
        }

        public Attributes perms(int perms) {
            this.setPermissions(perms);
            return this;
        }

        public void setPermissions(int perms) {
            this.perms = perms;
            this.addFlag(Attribute.Perms);
        }

        public FileTime getAccessTime() {
            return this.accessTime;
        }

        public Attributes accessTime(long atime) {
            return this.accessTime(atime, TimeUnit.SECONDS);
        }

        public Attributes accessTime(long atime, TimeUnit unit) {
            return this.accessTime(FileTime.from(atime, unit));
        }

        public Attributes accessTime(FileTime atime) {
            this.setAccessTime(atime);
            return this;
        }

        public void setAccessTime(FileTime atime) {
            this.accessTime = ValidateUtils.checkNotNull(atime, "No access time");
            this.addFlag(Attribute.AccessTime);
        }

        public FileTime getCreateTime() {
            return this.createTime;
        }

        public Attributes createTime(long ctime) {
            return this.createTime(ctime, TimeUnit.SECONDS);
        }

        public Attributes createTime(long ctime, TimeUnit unit) {
            return this.createTime(FileTime.from(ctime, unit));
        }

        public Attributes createTime(FileTime ctime) {
            this.setCreateTime(ctime);
            return this;
        }

        public void setCreateTime(FileTime ctime) {
            this.createTime = ValidateUtils.checkNotNull(ctime, "No create time");
            this.addFlag(Attribute.CreateTime);
        }

        public FileTime getModifyTime() {
            return this.modifyTime;
        }

        public Attributes modifyTime(long mtime) {
            return this.modifyTime(mtime, TimeUnit.SECONDS);
        }

        public Attributes modifyTime(long mtime, TimeUnit unit) {
            return this.modifyTime(FileTime.from(mtime, unit));
        }

        public Attributes modifyTime(FileTime mtime) {
            this.setModifyTime(mtime);
            return this;
        }

        public void setModifyTime(FileTime mtime) {
            this.modifyTime = ValidateUtils.checkNotNull(mtime, "No modify time");
            this.addFlag(Attribute.ModifyTime);
        }

        public List<AclEntry> getAcl() {
            return this.acl;
        }

        public Attributes acl(List<AclEntry> acl) {
            this.setAcl(acl);
            return this;
        }

        public void setAcl(List<AclEntry> acl) {
            this.acl = ValidateUtils.checkNotNull(acl, "No ACLs");
            this.addFlag(Attribute.Acl);
        }

        public Map<String, byte[]> getExtensions() {
            return this.extensions;
        }

        public Attributes extensions(Map<String, byte[]> extensions) {
            this.setExtensions(extensions);
            return this;
        }

        public void setStringExtensions(Map<String, String> extensions) {
            this.setExtensions(SftpHelper.toBinaryExtensions(extensions));
        }

        public void setExtensions(Map<String, byte[]> extensions) {
            this.extensions = ValidateUtils.checkNotNull(extensions, "No extensions");
            this.addFlag(Attribute.Extensions);
        }

        public boolean isRegularFile() {
            return (this.getPermissions() & 0xF000) == 32768;
        }

        public boolean isDirectory() {
            return (this.getPermissions() & 0xF000) == 16384;
        }

        public boolean isSymbolicLink() {
            return (this.getPermissions() & 0xF000) == 40960;
        }

        public boolean isOther() {
            return !this.isRegularFile() && !this.isDirectory() && !this.isSymbolicLink();
        }

        public String toString() {
            return "type=" + this.getType() + ";size=" + this.getSize() + ";uid=" + this.getUserId() + ";gid=" + this.getGroupId() + ";perms=0x" + Integer.toHexString(this.getPermissions()) + ";flags=" + this.getFlags() + ";owner=" + this.getOwner() + ";group=" + this.getGroup() + ";aTime=" + this.getAccessTime() + ";cTime=" + this.getCreateTime() + ";mTime=" + this.getModifyTime() + ";extensions=" + this.getExtensions().keySet();
        }
    }

    public static abstract class CloseableHandle
    extends Handle
    implements Channel,
    Closeable {
        protected CloseableHandle(String path, byte[] id) {
            super(path, id);
        }
    }

    public static class Handle {
        private final String path;
        private final byte[] id;

        Handle(String path, byte[] id) {
            this.path = ValidateUtils.checkNotNullAndNotEmpty(path, "No remote path");
            this.id = (byte[])ValidateUtils.checkNotNullAndNotEmpty(id, "No handle ID").clone();
        }

        public String getPath() {
            return this.path;
        }

        public int length() {
            return this.id.length;
        }

        public byte[] getIdentifier() {
            return (byte[])this.id.clone();
        }

        public int hashCode() {
            return Arrays.hashCode((byte[])this.id);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Handle)) {
                return false;
            }
            return Arrays.areEqual((byte[])this.id, (byte[])((Handle)obj).id);
        }

        public String toString() {
            return this.getPath() + ": " + BufferUtils.toHex('\u0000', this.id);
        }
    }

    public static enum Attribute {
        Size,
        UidGid,
        Perms,
        OwnerGroup,
        AccessTime,
        ModifyTime,
        CreateTime,
        Acl,
        Extensions;

    }

    public static enum CopyMode {
        Atomic,
        Overwrite;

    }

    public static enum OpenMode {
        Read,
        Write,
        Append,
        Create,
        Truncate,
        Exclusive;

    }
}

