/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;

public final class SyspropsMapWrapper
implements Map<String, Object> {
    public static final String SYSPROPS_MAPPED_PREFIX = "org.apache.sshd.config";
    public static final SyspropsMapWrapper INSTANCE = new SyspropsMapWrapper();
    public static final PropertyResolver SYSPROPS_RESOLVER = new PropertyResolver(){

        @Override
        public Map<String, Object> getProperties() {
            return INSTANCE;
        }

        @Override
        public PropertyResolver getParentPropertyResolver() {
            return null;
        }

        public String toString() {
            return "SYSPROPS";
        }
    };

    private SyspropsMapWrapper() {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("sysprops#clear() N/A");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Properties props = System.getProperties();
        for (String key : props.stringPropertyNames()) {
            String v;
            if (!SyspropsMapWrapper.isMappedSyspropKey(key) || !Objects.equals(v = props.getProperty(key), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Properties props = System.getProperties();
        TreeSet<Map.Entry<String, Object>> entries = new TreeSet<Map.Entry<String, Object>>(Pair.byKeyEntryComparator());
        for (String key : props.stringPropertyNames()) {
            String v;
            if (!SyspropsMapWrapper.isMappedSyspropKey(key) || (v = props.getProperty(key)) == null) continue;
            entries.add(new Pair<String, String>(SyspropsMapWrapper.getUnmappedSyspropKey(key), v));
        }
        return entries;
    }

    @Override
    public Object get(Object key) {
        return key instanceof String ? System.getProperty(SyspropsMapWrapper.getMappedSyspropKey(key)) : null;
    }

    @Override
    public boolean isEmpty() {
        return GenericUtils.isEmpty(this.keySet());
    }

    @Override
    public Set<String> keySet() {
        Properties props = System.getProperties();
        TreeSet<String> keys = new TreeSet<String>();
        for (String key : props.stringPropertyNames()) {
            if (!SyspropsMapWrapper.isMappedSyspropKey(key)) continue;
            keys.add(SyspropsMapWrapper.getUnmappedSyspropKey(key));
        }
        return keys;
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("sysprops#put(" + key + ")[" + value + "] N/A");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException("sysprops#putAll(" + m + ") N/A");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("sysprops#remove(" + key + ") N/A");
    }

    @Override
    public int size() {
        return GenericUtils.size(this.keySet());
    }

    @Override
    public Collection<Object> values() {
        Properties props = System.getProperties();
        ArrayList<Object> values = new ArrayList<Object>(props.size());
        for (String key : props.stringPropertyNames()) {
            String v;
            if (!SyspropsMapWrapper.isMappedSyspropKey(key) || (v = props.getProperty(key)) == null) continue;
            values.add(v);
        }
        return values;
    }

    public String toString() {
        return Objects.toString(System.getProperties(), null);
    }

    public static boolean isMappedSyspropKey(String key) {
        return GenericUtils.length(key) > SYSPROPS_MAPPED_PREFIX.length() + 1 && key.startsWith(SYSPROPS_MAPPED_PREFIX) && key.charAt(SYSPROPS_MAPPED_PREFIX.length()) == '.';
    }

    public static String getUnmappedSyspropKey(Object key) {
        String s = Objects.toString(key);
        return SyspropsMapWrapper.isMappedSyspropKey(s) ? s.substring(SYSPROPS_MAPPED_PREFIX.length() + 1) : s;
    }

    public static String getMappedSyspropKey(Object key) {
        return "org.apache.sshd.config." + key;
    }
}

