/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultVerifiableSshFuture;
import org.apache.sshd.common.io.IoInputStream;
import org.apache.sshd.common.io.IoReadFuture;
import org.apache.sshd.common.io.ReadPendingException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class ChannelAsyncInputStream
extends AbstractCloseable
implements IoInputStream,
ChannelHolder {
    private final Channel channelInstance;
    private final Buffer buffer = new ByteArrayBuffer();
    private IoReadFutureImpl pending;

    public ChannelAsyncInputStream(Channel channel) {
        this.channelInstance = ValidateUtils.checkNotNull(channel, "No channel");
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Readable src) throws IOException {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            this.buffer.putBuffer(src);
        }
        this.doRead(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoReadFuture read(Buffer buf) {
        IoReadFutureImpl future = new IoReadFutureImpl(buf);
        if (this.isClosing()) {
            future.setValue(new IOException("Closed"));
        } else {
            Buffer buffer = this.buffer;
            synchronized (buffer) {
                if (this.pending != null) {
                    throw new ReadPendingException("Previous pending read not handled");
                }
                this.pending = future;
            }
            this.doRead(false);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (this.buffer.available() == 0 && this.pending != null) {
                this.pending.setValue(new SshException("Closed"));
            }
        }
        super.preClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseFuture doCloseGracefully() {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            return this.builder().when(this.pending).build().close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRead(boolean resume) {
        IoReadFutureImpl future = null;
        int nbRead = 0;
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (this.buffer.available() > 0) {
                if (resume) {
                    // empty if block
                }
                future = this.pending;
                this.pending = null;
                if (future != null) {
                    nbRead = future.buffer.putBuffer(this.buffer, false);
                    this.buffer.compact();
                }
            } else if (!resume) {
                // empty if block
            }
        }
        if (nbRead > 0) {
            Channel channel = this.getChannel();
            try {
                Window wLocal = channel.getLocalWindow();
                wLocal.consumeAndCheck(nbRead);
            }
            catch (IOException e) {
                Session session = channel.getSession();
                session.exceptionCaught(e);
            }
            future.setValue(nbRead);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "]";
    }

    public static class IoReadFutureImpl
    extends DefaultVerifiableSshFuture<IoReadFuture>
    implements IoReadFuture {
        private final Buffer buffer;

        public IoReadFutureImpl(Buffer buffer) {
            super((Object)null);
            this.buffer = buffer;
        }

        @Override
        public Buffer getBuffer() {
            return this.buffer;
        }

        @Override
        public IoReadFuture verify(long timeoutMillis) throws IOException {
            long startTime = System.nanoTime();
            Number result = this.verifyResult(Number.class, timeoutMillis);
            long endTime = System.nanoTime();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Read " + result + " bytes after " + (endTime - startTime) + " nanos");
            }
            return this;
        }

        @Override
        public int getRead() {
            Object v = this.getValue();
            if (v instanceof RuntimeException) {
                throw (RuntimeException)v;
            }
            if (v instanceof Error) {
                throw (Error)v;
            }
            if (v instanceof Throwable) {
                throw (RuntimeSshException)new RuntimeSshException("Error reading from channel.").initCause((Throwable)v);
            }
            if (v instanceof Number) {
                return ((Number)v).intValue();
            }
            throw new IllegalStateException("Unknown read value type: " + (v == null ? "null" : v.getClass().getName()));
        }

        @Override
        public Throwable getException() {
            Object v = this.getValue();
            if (v instanceof Throwable) {
                return (Throwable)v;
            }
            return null;
        }
    }
}

