/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.SocketTimeoutException;
import java.nio.channels.Channel;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.util.Predicate;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class Window
extends AbstractLoggingBean
implements Channel,
ChannelHolder,
PropertyResolver {
    public static final Predicate<Window> SPACE_AVAILABLE_PREDICATE = new Predicate<Window>(){

        @Override
        public boolean evaluate(Window input) {
            return input.sizeHolder.get() > 0;
        }
    };
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicInteger sizeHolder = new AtomicInteger(0);
    private final AbstractChannel channelInstance;
    private final Object lock;
    private final String suffix;
    private int maxSize;
    private int packetSize;
    private Map<String, Object> props = Collections.emptyMap();

    public Window(AbstractChannel channel, Object lock, boolean client, boolean local) {
        this.channelInstance = ValidateUtils.checkNotNull(channel, "No channel provided");
        this.lock = lock != null ? lock : this;
        this.suffix = (client ? "client" : "server") + "/" + (local ? "local" : "remote");
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.props;
    }

    @Override
    public PropertyResolver getParentPropertyResolver() {
        return this.getChannel();
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channelInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.sizeHolder.get();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void init(PropertyResolver resolver) {
        this.init(PropertyResolverUtils.getIntProperty(resolver, "window-size", 0x200000), PropertyResolverUtils.getIntProperty(resolver, "packet-size", 32768), resolver.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int size, int packetSize, Map<String, Object> props) {
        ValidateUtils.checkTrue(size >= 0, "Illegal initial size: %d", size);
        ValidateUtils.checkTrue(packetSize > 0, "Illegal packet size: %d", packetSize);
        Object object = this.lock;
        synchronized (object) {
            this.maxSize = size;
            this.packetSize = packetSize;
            this.props = props == null ? Collections.emptyMap() : props;
            this.updateSize(size);
        }
        if (this.initialized.getAndSet(true)) {
            this.log.debug("init({}) re-initializing", (Object)this);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("init({}) size={}, max={}, packet={}", new Object[]{this, this.getSize(), this.getMaxSize(), this.getPacketSize()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(int window) {
        long expandedSize;
        ValidateUtils.checkTrue(window >= 0, "Negative window size: %d", window);
        this.checkInitialized("expand");
        Object object = this.lock;
        synchronized (object) {
            expandedSize = this.sizeHolder.get() + window;
            if (expandedSize > Integer.MAX_VALUE) {
                this.updateSize(Integer.MAX_VALUE);
            } else {
                this.updateSize((int)expandedSize);
            }
        }
        if (expandedSize > Integer.MAX_VALUE) {
            this.log.warn("expand({}) window={} - truncated expanded size ({}) to {}", new Object[]{this, window, expandedSize, Integer.MAX_VALUE});
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Increase {} by {} up to {}", new Object[]{this, window, expandedSize});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(int len) {
        int remainLen;
        ValidateUtils.checkTrue(len >= 0, "Negative consumption length: %d", len);
        this.checkInitialized("consume");
        Object object = this.lock;
        synchronized (object) {
            remainLen = this.sizeHolder.get() - len;
            if (remainLen >= 0) {
                this.updateSize(remainLen);
            }
        }
        if (remainLen < 0) {
            throw new IllegalStateException("consume(" + this + ") required length (" + len + ") above available: " + (remainLen + len));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Consume {} by {} down to {}", new Object[]{this, len, remainLen});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeAndCheck(int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.consume(len);
                this.check(this.maxSize);
            }
            catch (RuntimeException e) {
                throw new StreamCorruptedException("consumeAndCheck(" + this + ")" + " failed (" + e.getClass().getSimpleName() + ")" + " to consume " + len + " bytes" + ": " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(int maxFree) throws IOException {
        ValidateUtils.checkTrue(maxFree >= 0, "Negative check size: %d", maxFree);
        this.checkInitialized("check");
        int adjustSize = -1;
        AbstractChannel channel = this.getChannel();
        Object object = this.lock;
        synchronized (object) {
            int size = this.sizeHolder.get();
            if (size < maxFree / 2) {
                adjustSize = maxFree - size;
                channel.sendWindowAdjust(adjustSize);
                this.updateSize(maxFree);
            }
        }
        if (adjustSize >= 0 && this.log.isDebugEnabled()) {
            this.log.debug("Increase {} by {} up to {}", new Object[]{this, adjustSize, maxFree});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndConsume(final int len, long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        ValidateUtils.checkTrue(len >= 0, "Negative wait consume length: %d", len);
        this.checkInitialized("waitAndConsume");
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition((Predicate<? super Window>)new Predicate<Window>(){

                @Override
                public boolean evaluate(Window input) {
                    return input.sizeHolder.get() >= len;
                }
            }, maxWaitTime);
            if (this.log.isDebugEnabled()) {
                this.log.debug("waitAndConsume({}) - requested={}, available={}", new Object[]{this, len, this.sizeHolder});
            }
            this.consume(len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForSpace(long maxWaitTime) throws InterruptedException, WindowClosedException, SocketTimeoutException {
        this.checkInitialized("waitForSpace");
        Object object = this.lock;
        synchronized (object) {
            this.waitForCondition(SPACE_AVAILABLE_PREDICATE, maxWaitTime);
            if (this.log.isDebugEnabled()) {
                this.log.debug("waitForSpace({}) available: {}", (Object)this, (Object)this.sizeHolder);
            }
            return this.sizeHolder.get();
        }
    }

    protected void waitForCondition(Predicate<? super Window> predicate, long maxWaitTime) throws WindowClosedException, InterruptedException, SocketTimeoutException {
        long maxWaitNanos;
        long nanoWaitDuration;
        ValidateUtils.checkNotNull(predicate, "No condition");
        ValidateUtils.checkTrue(maxWaitTime > 0L, "Non-positive max. wait time: %d", maxWaitTime);
        for (long remWaitNanos = maxWaitNanos = TimeUnit.MILLISECONDS.toNanos(maxWaitTime); this.isOpen() && remWaitNanos > 0L; remWaitNanos -= nanoWaitDuration) {
            if (predicate.evaluate(this)) {
                return;
            }
            long curWaitMillis = TimeUnit.NANOSECONDS.toMillis(remWaitNanos);
            long nanoWaitStart = System.nanoTime();
            if (curWaitMillis > 0L) {
                this.lock.wait(curWaitMillis);
            } else {
                this.lock.wait(0L, (int)remWaitNanos);
            }
            long nanoWaitEnd = System.nanoTime();
            nanoWaitDuration = nanoWaitEnd - nanoWaitStart;
        }
        if (!this.isOpen()) {
            throw new WindowClosedException(this.toString());
        }
        throw new SocketTimeoutException("waitForCondition(" + this + ") timeout exceeded: " + maxWaitTime);
    }

    protected void updateSize(int size) {
        ValidateUtils.checkTrue(size >= 0, "Invalid size: %d", size);
        this.sizeHolder.set(size);
        this.lock.notifyAll();
    }

    protected void checkInitialized(String location) {
        if (!this.initialized.get()) {
            throw new IllegalStateException(location + " - window not initialized: " + this);
        }
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            this.log.debug("Closing {}", (Object)this);
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.suffix + "](" + String.valueOf(this.getChannel()) + ")";
    }
}

