/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp;

import java.io.IOException;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.util.ValidateUtils;

public class ScpException
extends IOException {
    private static final long serialVersionUID = 7734851624372451732L;
    private final Integer exitStatus;

    public ScpException(String message) {
        this(message, (Integer)null);
    }

    public ScpException(Integer exitStatus) {
        this("Exit status=" + ScpHelper.getExitStatusName(ValidateUtils.checkNotNull(exitStatus, "No exit status")), exitStatus);
    }

    public ScpException(String message, Integer exitStatus) {
        this(message, null, exitStatus);
    }

    public ScpException(Throwable cause, Integer exitStatus) {
        this(ValidateUtils.checkNotNull(cause, "No cause").getMessage(), cause, exitStatus);
    }

    public ScpException(String message, Throwable cause, Integer exitStatus) {
        super(message, cause);
        this.exitStatus = exitStatus;
    }

    public Integer getExitStatus() {
        return this.exitStatus;
    }
}

