/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sshd.common.auth.MutableUserHolder;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class ScpLocation
implements MutableUserHolder,
Serializable,
Cloneable {
    public static final char HOST_PART_SEPARATOR = ':';
    public static final char USERNAME_PART_SEPARATOR = '@';
    private static final long serialVersionUID = 5450230457030600136L;
    private String host;
    private String username;
    private String path;

    public ScpLocation() {
        this(null);
    }

    public ScpLocation(String locSpec) {
        ScpLocation.update(locSpec, this);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isLocal() {
        return GenericUtils.isEmpty(this.getHost());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    public String resolveUsername() {
        String user = this.getUsername();
        if (GenericUtils.isEmpty(user)) {
            return OsUtils.getCurrentUser();
        }
        return user;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int hashCode() {
        return Objects.hash(this.getHost(), this.resolveUsername(), OsUtils.getComparablePath(this.getPath()));
    }

    public boolean equals(Object obj) {
        String otherPath;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScpLocation other = (ScpLocation)obj;
        if (this.isLocal() != other.isLocal()) {
            return false;
        }
        String thisPath = OsUtils.getComparablePath(this.getPath());
        if (!Objects.equals(thisPath, otherPath = OsUtils.getComparablePath(other.getPath()))) {
            return false;
        }
        if (this.isLocal()) {
            return true;
        }
        return Objects.equals(this.resolveUsername(), other.resolveUsername()) && Objects.equals(this.getHost(), other.getHost());
    }

    public ScpLocation clone() {
        try {
            return (ScpLocation)this.getClass().cast(super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone " + this.toString(), e);
        }
    }

    public String toString() {
        String p = this.getPath();
        if (this.isLocal()) {
            return p;
        }
        return this.resolveUsername() + String.valueOf('@') + this.getHost() + String.valueOf(':') + p;
    }

    public static ScpLocation parse(String locSpec) {
        return GenericUtils.isEmpty(locSpec) ? null : ScpLocation.update(locSpec, new ScpLocation());
    }

    public static <L extends ScpLocation> L update(String locSpec, L location) {
        char drive;
        ValidateUtils.checkNotNull(location, "No location to update");
        if (GenericUtils.isEmpty(locSpec)) {
            return location;
        }
        location.setHost(null);
        location.setUsername(null);
        int pos = locSpec.indexOf(58);
        if (pos < 0) {
            location.setPath(locSpec);
            return location;
        }
        if (pos == 1 && OsUtils.isWin32() && ((drive = locSpec.charAt(0)) >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z')) {
            location.setPath(locSpec);
            return location;
        }
        String login = locSpec.substring(0, pos);
        ValidateUtils.checkTrue(pos < locSpec.length() - 1, "Invalid remote specification (missing path): %s", (Object)locSpec);
        location.setPath(locSpec.substring(pos + 1));
        pos = login.indexOf(64);
        ValidateUtils.checkTrue(pos != 0, "Invalid remote specification (missing username): %s", (Object)locSpec);
        if (pos < 0) {
            location.setHost(login);
        } else {
            location.setUsername(login.substring(0, pos));
            ValidateUtils.checkTrue(pos < login.length() - 1, "Invalid remote specification (missing host): %s", (Object)locSpec);
            location.setHost(login.substring(pos + 1));
        }
        return location;
    }
}

