/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.scp.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public class DefaultScpFileOpener
extends AbstractLoggingBean
implements ScpFileOpener {
    public static final DefaultScpFileOpener INSTANCE = new DefaultScpFileOpener();

    @Override
    public InputStream openRead(Session session, Path file, OpenOption ... options) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("openRead({}) file={}, options={}", new Object[]{session, file, Arrays.toString(options)});
        }
        return Files.newInputStream(file, options);
    }

    @Override
    public OutputStream openWrite(Session session, Path file, OpenOption ... options) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("openWrite({}) file={}, options={}", new Object[]{session, file, Arrays.toString(options)});
        }
        return Files.newOutputStream(file, options);
    }
}

