/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import org.apache.sshd.common.util.ValidateUtils;

public interface Int2IntFunction {
    public static final Int2IntFunction IDENTITY = new Int2IntFunction(){

        @Override
        public int apply(int value) {
            return value;
        }
    };

    public int apply(int var1);

    public static final class Utils {
        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static Int2IntFunction sub(int delta) {
            return Utils.add(0 - delta);
        }

        public static Int2IntFunction add(final int delta) {
            if (delta == 0) {
                return IDENTITY;
            }
            return new Int2IntFunction(){

                @Override
                public int apply(int value) {
                    return value + delta;
                }
            };
        }

        public static Int2IntFunction mul(final int factor) {
            if (factor == 1) {
                return IDENTITY;
            }
            return new Int2IntFunction(){

                @Override
                public int apply(int value) {
                    return value * factor;
                }
            };
        }

        public static Int2IntFunction div(final int factor) {
            if (factor == 1) {
                return IDENTITY;
            }
            ValidateUtils.checkTrue(factor != 0, "Zero division factor");
            return new Int2IntFunction(){

                @Override
                public int apply(int value) {
                    return value / factor;
                }
            };
        }
    }
}

