/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Objects;

public interface Transformer<I, O> {
    public static final Transformer<Object, String> TOSTRING = new Transformer<Object, String>(){

        @Override
        public String transform(Object input) {
            return Objects.toString(input, null);
        }
    };
    public static final Transformer<Enum<?>, String> ENUM_NAME_EXTRACTOR = new Transformer<Enum<?>, String>(){

        @Override
        public String transform(Enum<?> input) {
            if (input == null) {
                return null;
            }
            return input.name();
        }
    };

    public O transform(I var1);

    public static final class Utils {
        private static final Transformer IDENTITY = new Transformer(){

            public Object transform(Object input) {
                return input;
            }
        };

        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static <U extends V, V> Transformer<U, V> identity() {
            return IDENTITY;
        }
    }
}

