/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Collection;
import java.util.Map;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;

public final class ValidateUtils {
    private ValidateUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static <T> T checkNotNull(T t, String message) {
        ValidateUtils.checkTrue(t != null, message);
        return t;
    }

    public static <T> T checkNotNull(T t, String message, Object arg) {
        ValidateUtils.checkTrue(t != null, message, arg);
        return t;
    }

    public static <T> T checkNotNull(T t, String message, long value) {
        ValidateUtils.checkTrue(t != null, message, value);
        return t;
    }

    public static <T> T checkNotNull(T t, String message, Object ... args) {
        ValidateUtils.checkTrue(t != null, message, args);
        return t;
    }

    public static String checkNotNullAndNotEmpty(String t, String message) {
        ValidateUtils.checkTrue(GenericUtils.length(t = ValidateUtils.checkNotNull(t, message).trim()) > 0, message);
        return t;
    }

    public static String checkNotNullAndNotEmpty(String t, String message, Object arg) {
        ValidateUtils.checkTrue(GenericUtils.length(t = ValidateUtils.checkNotNull(t, message, arg).trim()) > 0, message, arg);
        return t;
    }

    public static String checkNotNullAndNotEmpty(String t, String message, Object ... args) {
        ValidateUtils.checkTrue(GenericUtils.length(t = ValidateUtils.checkNotNull(t, message, args).trim()) > 0, message, args);
        return t;
    }

    public static <K, V, M extends Map<K, V>> M checkNotNullAndNotEmpty(M t, String message, Object ... args) {
        ValidateUtils.checkTrue(GenericUtils.size(t = ValidateUtils.checkNotNull(t, message, args)) > 0, message, args);
        return t;
    }

    public static <T, C extends Collection<T>> C checkNotNullAndNotEmpty(C t, String message, Object ... args) {
        ValidateUtils.checkTrue(GenericUtils.size(t = ValidateUtils.checkNotNull(t, message, args)) > 0, message, args);
        return t;
    }

    public static byte[] checkNotNullAndNotEmpty(byte[] a, String message) {
        ValidateUtils.checkTrue(NumberUtils.length(a = ValidateUtils.checkNotNull(a, message)) > 0, message);
        return a;
    }

    public static byte[] checkNotNullAndNotEmpty(byte[] a, String message, Object ... args) {
        ValidateUtils.checkTrue(NumberUtils.length(a = ValidateUtils.checkNotNull(a, message, args)) > 0, message, args);
        return a;
    }

    public static int[] checkNotNullAndNotEmpty(int[] a, String message) {
        ValidateUtils.checkTrue(NumberUtils.length(a = ValidateUtils.checkNotNull(a, message)) > 0, message);
        return a;
    }

    public static int[] checkNotNullAndNotEmpty(int[] a, String message, Object ... args) {
        ValidateUtils.checkTrue(NumberUtils.length(a = ValidateUtils.checkNotNull(a, message, args)) > 0, message, args);
        return a;
    }

    public static <T> T[] checkNotNullAndNotEmpty(T[] t, String message, Object ... args) {
        ValidateUtils.checkTrue(GenericUtils.length(t = ValidateUtils.checkNotNull(t, message, args)) > 0, message, args);
        return t;
    }

    public static void checkTrue(boolean flag, String message) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, GenericUtils.EMPTY_OBJECT_ARRAY);
        }
    }

    public static void checkTrue(boolean flag, String message, long value) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, value);
        }
    }

    public static void checkTrue(boolean flag, String message, Object arg) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, arg);
        }
    }

    public static void checkTrue(boolean flag, String message, Object ... args) {
        if (!flag) {
            ValidateUtils.throwIllegalArgumentException(message, args);
        }
    }

    public static void throwIllegalArgumentException(String message, Object ... args) {
        throw new IllegalArgumentException(String.format(message, args));
    }
}

