/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.buffer.keys;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;

public class ED25519BufferPublicKeyParser
extends AbstractBufferPublicKeyParser<PublicKey> {
    public static final ED25519BufferPublicKeyParser IGNORING = new ED25519BufferPublicKeyParser(){

        @Override
        protected PublicKey generatePublicKey(byte[] octets) throws GeneralSecurityException {
            return null;
        }
    };

    public ED25519BufferPublicKeyParser() {
        super(PublicKey.class, "ssh-ed25519");
    }

    @Override
    public PublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(keyType), "Unsupported key type: %s", (Object)keyType);
        return this.generatePublicKey(buffer.getBytes());
    }

    protected PublicKey generatePublicKey(byte[] octets) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException("Unsupported curve: ssh-ed25519");
    }
}

