/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.future.SshFuture;
import org.apache.sshd.common.util.ObjectBuilder;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.closeable.FuturesCloseable;
import org.apache.sshd.common.util.closeable.ParallelCloseable;
import org.apache.sshd.common.util.closeable.SequentialCloseable;
import org.apache.sshd.common.util.closeable.SimpleCloseable;

public final class Builder
implements ObjectBuilder<Closeable> {
    private final Object lock;
    private final List<Closeable> closeables = new ArrayList<Closeable>();

    public Builder(Object lock) {
        this.lock = ValidateUtils.checkNotNull(lock, "No lock");
    }

    public Builder run(final Runnable r) {
        return this.close(new SimpleCloseable(this.lock){

            @Override
            protected void doClose(boolean immediately) {
                try {
                    r.run();
                }
                finally {
                    super.doClose(immediately);
                }
            }
        });
    }

    public <T extends SshFuture> Builder when(SshFuture<T> future) {
        if (future != null) {
            this.when(Collections.singleton(future));
        }
        return this;
    }

    @SafeVarargs
    public final <T extends SshFuture> Builder when(SshFuture<T> ... futures) {
        return this.when(Arrays.asList(futures));
    }

    public <T extends SshFuture> Builder when(Iterable<? extends SshFuture<T>> futures) {
        return this.close(new FuturesCloseable(this.lock, futures));
    }

    public Builder sequential(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            this.close(closeable);
        }
        return this;
    }

    public Builder sequential(Iterable<Closeable> closeables) {
        return this.close(new SequentialCloseable(this.lock, closeables));
    }

    public Builder parallel(Closeable ... closeables) {
        if (closeables.length == 1) {
            this.close(closeables[0]);
        } else if (closeables.length > 0) {
            this.parallel(Arrays.asList(closeables));
        }
        return this;
    }

    public Builder parallel(Iterable<? extends Closeable> closeables) {
        return this.close(new ParallelCloseable(this.lock, closeables));
    }

    public Builder close(Closeable c) {
        if (c != null) {
            this.closeables.add(c);
        }
        return this;
    }

    @Override
    public Closeable build() {
        if (this.closeables.isEmpty()) {
            return new SimpleCloseable(this.lock);
        }
        if (this.closeables.size() == 1) {
            return this.closeables.get(0);
        }
        return new SequentialCloseable(this.lock, this.closeables);
    }
}

