/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;

public class LoggingFilterOutputStream
extends FilterOutputStream {
    private final String msg;
    private final SimplifiedLog log;
    private final int chunkSize;
    private final AtomicInteger writeCount = new AtomicInteger(0);

    public LoggingFilterOutputStream(OutputStream out, String msg, Logger log, PropertyResolver resolver) {
        this(out, msg, log, PropertyResolverUtils.getIntProperty(resolver, "sshd-hexdump-chunk-size", 64));
    }

    public LoggingFilterOutputStream(OutputStream out, String msg, Logger log, int chunkSize) {
        super(out);
        this.msg = msg;
        this.log = LoggingUtils.wrap(log);
        this.chunkSize = chunkSize;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] d = new byte[]{(byte)b};
        this.write(d, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int count = this.writeCount.incrementAndGet();
        BufferUtils.dumpHex(this.log, BufferUtils.DEFAULT_HEXDUMP_LEVEL, this.msg + "[" + count + "]", ' ', this.chunkSize, b, off, len);
        this.out.write(b, off, len);
    }
}

