/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.session.ServerSession;

public abstract class AbstractUserAuth
extends AbstractLoggingBean
implements UserAuth {
    private final String name;
    private ServerSession session;
    private String service;
    private String username;

    protected AbstractUserAuth(String name) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No name");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public String getService() {
        return this.service;
    }

    @Override
    public ServerSession getServerSession() {
        return this.session;
    }

    @Override
    public ServerSession getSession() {
        return this.getServerSession();
    }

    @Override
    public Boolean auth(ServerSession session, String username, String service, Buffer buffer) throws Exception {
        this.session = ValidateUtils.checkNotNull(session, "No server session");
        this.username = username;
        this.service = service;
        return this.doAuth(buffer, true);
    }

    @Override
    public Boolean next(Buffer buffer) throws Exception {
        return this.doAuth(buffer, false);
    }

    @Override
    public void destroy() {
    }

    protected abstract Boolean doAuth(Buffer var1, boolean var2) throws Exception;

    public String toString() {
        return this.getName() + ": " + this.getSession() + "[" + this.getService() + "]";
    }
}

