/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.StringUtil;

public class Row {
    private List<Object> data = new ArrayList<Object>();
    private List<String> content = new ArrayList<String>();

    Row() {
    }

    Row(List<Col> cols) {
        this();
        for (Col col : cols) {
            this.data.add(col.getHeader());
        }
    }

    public void addContent(List<Object> data) {
        this.data = data;
    }

    public void addContent(Object ... cellDataAr) {
        this.data.addAll(Arrays.asList(cellDataAr));
    }

    void formatContent(List<Col> cols) {
        this.content.clear();
        int c = 0;
        for (Col col : cols) {
            this.content.add(col.format(this.data.get(c)));
            ++c;
        }
    }

    String getContent(List<Col> cols, String separator) {
        if (cols.size() != this.content.size()) {
            throw new RuntimeException("Number of columns and number of content elements do not match");
        }
        ArrayList<String[]> contents = new ArrayList<String[]>();
        int lines = 0;
        for (int col = 0; col < cols.size(); ++col) {
            String[] cnt = cols.get(col).getContent(this.content.get(col)).split("\n");
            lines = Math.max(lines, cnt.length);
            contents.add(cnt);
        }
        StringBuilder st = new StringBuilder();
        for (int line = 0; line < lines; ++line) {
            if (line > 0) {
                st.append("\n");
            }
            StringBuilder st2 = new StringBuilder();
            for (int col = 0; col < cols.size(); ++col) {
                String[] strings = (String[])contents.get(col);
                if (col > 0) {
                    st2.append(separator);
                }
                if (line < strings.length) {
                    st2.append(strings[line]);
                    continue;
                }
                st2.append(StringUtil.repeat(" ", cols.get(col).getSize()));
            }
            while (st2.length() > 0 && st2.charAt(st2.length() - 1) == ' ') {
                st2.setLength(st2.length() - 1);
            }
            st.append((CharSequence)st2);
        }
        return st.toString();
    }
}

