/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.audit;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.karaf.jaas.modules.audit.AbstractAuditLoginModule;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventAdminAuditLoginModule
extends AbstractAuditLoginModule {
    public static final String TOPIC_EVENTS = "org/apache/karaf/login/";
    private static final Logger LOGGER = LoggerFactory.getLogger(EventAdminAuditLoginModule.class);
    private static boolean errorLogged;
    private BundleContext bundleContext;
    private String topic;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        this.topic = (String)options.get("topic");
        if (this.topic == null) {
            this.topic = TOPIC_EVENTS;
        } else if (!this.topic.endsWith("/")) {
            this.topic = this.topic + "/";
        }
    }

    @Override
    protected void audit(AbstractAuditLoginModule.Action action, String user) {
        block2: {
            try {
                EventAdminAuditor.audit(this.bundleContext, this.topic + action.toString().toUpperCase(), user, this.subject);
            }
            catch (Throwable t) {
                if (errorLogged) break block2;
                errorLogged = true;
                LOGGER.warn("Unable to send security auditing EventAdmin events: " + t);
            }
        }
    }

    static class EventAdminAuditor {
        EventAdminAuditor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void audit(BundleContext bundleContext, String topic, String username, Subject subject) {
            ServiceReference ref = bundleContext.getServiceReference(EventAdmin.class);
            if (ref != null) {
                EventAdmin eventAdmin = (EventAdmin)bundleContext.getService(ref);
                try {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("type", topic.substring(topic.lastIndexOf("/") + 1).toLowerCase());
                    props.put("timestamp", System.currentTimeMillis());
                    props.put("username", username);
                    props.put("subject", subject);
                    eventAdmin.postEvent(new Event(topic, props));
                }
                finally {
                    bundleContext.ungetService(ref);
                }
            }
        }
    }
}

