/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.exceptions;

import aQute.lib.exceptions.Exceptions;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;

@FunctionalInterface
public interface BiFunctionWithException<T, U, R> {
    public R apply(T var1, U var2) throws Exception;

    default public BiFunction<T, U, R> orElseThrow() {
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    default public BiFunction<T, U, R> orElse(R orElse) {
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Exception e) {
                return orElse;
            }
        };
    }

    default public BiFunction<T, U, R> orElseGet(Supplier<? extends R> orElseGet) {
        Objects.requireNonNull(orElseGet);
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Exception e) {
                return orElseGet.get();
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> asBiFunction(BiFunctionWithException<T, U, R> unchecked) {
        return unchecked.orElseThrow();
    }

    public static <T, U, R> BiFunction<T, U, R> asBiFunctionOrElse(BiFunctionWithException<T, U, R> unchecked, R orElse) {
        return unchecked.orElse(orElse);
    }

    public static <T, U, R> BiFunction<T, U, R> asBiFunctionOrElseGet(BiFunctionWithException<T, U, R> unchecked, Supplier<? extends R> orElseGet) {
        return unchecked.orElseGet(orElseGet);
    }
}

