/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh.keygenerator;

import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.security.KeyPair;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PemWriter {
    private Path privateKeyPath;
    private Path publicKeyPath;

    public PemWriter(Path privateKeyPath, Path publicKeyPath) {
        this.privateKeyPath = privateKeyPath;
        this.publicKeyPath = publicKeyPath;
    }

    public void writeKeyPair(String resource, KeyPair kp) throws IOException, FileNotFoundException {
        try (JcaPEMWriter writer = new JcaPEMWriter((Writer)new FileWriter(this.privateKeyPath.toFile()));){
            writer.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", kp.getPrivate().getEncoded()));
        }
        writer = new JcaPEMWriter((Writer)new FileWriter(this.publicKeyPath.toFile()));
        var4_4 = null;
        try {
            writer.writeObject((PemObjectGenerator)new PemObject("PUBLIC KEY", kp.getPublic().getEncoded()));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var4_4 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }
}

