/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.utils.threading.impl;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.aries.blueprint.utils.threading.impl.Discardable;

public class DiscardableRunnable
implements Runnable,
Discardable<Runnable> {
    private AtomicReference<Runnable> r = new AtomicReference();
    private Queue<Discardable<Runnable>> _removeFromListOnRun;

    public DiscardableRunnable(Runnable run, Queue<Discardable<Runnable>> _unprocessedWork) {
        this.r.set(run);
        this._removeFromListOnRun = _unprocessedWork;
        this._removeFromListOnRun.add(this);
    }

    private DiscardableRunnable(Runnable run) {
        this.r.set(run);
        this._removeFromListOnRun = new LinkedBlockingQueue<Discardable<Runnable>>();
    }

    @Override
    public void run() {
        this._removeFromListOnRun.remove(this);
        Runnable run = this.r.get();
        if (run != null) {
            run.run();
        }
    }

    @Override
    public Runnable discard() {
        this._removeFromListOnRun.remove(this);
        return new DiscardableRunnable(this.r.getAndSet(null));
    }
}

