/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.ssh.KarafAgentFactory;
import org.apache.karaf.shell.ssh.KnownHostsManager;
import org.apache.karaf.shell.ssh.ServerKeyVerifierImpl;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.util.io.input.NoCloseInputStream;
import org.apache.sshd.common.util.io.output.NoCloseOutputStream;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="ssh", name="ssh", description="Connects to a remote SSH server")
@Service
public class SshAction
implements Action {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-l", aliases={"--username"}, description="The user name for remote login", required=false, multiValued=false)
    private String username;
    @Option(name="-P", aliases={"--password"}, description="The password for remote login", required=false, multiValued=false)
    private String password;
    @Option(name="-p", aliases={"--port"}, description="The port to use for SSH connection", required=false, multiValued=false)
    private int port = 22;
    @Option(name="-k", aliases={"--keyfile"}, description="The private keyFile location when using key login, need have BouncyCastle registered as security provider using this flag", required=false, multiValued=false)
    private String keyFile;
    @Option(name="-q", description="Quiet Mode. Do not ask for confirmations", required=false, multiValued=false)
    private boolean quiet;
    @Option(name="-r", aliases={"--retries"}, description="retry connection establishment (up to attempts times)", required=false, multiValued=false)
    private int retries = 0;
    @Argument(index=0, name="hostname", description="The host name to connect to via SSH", required=true, multiValued=false)
    private String hostname;
    @Argument(index=1, name="command", description="Optional command to execute", required=false, multiValued=true)
    private List<String> command;
    @Reference
    private Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        block25: {
            if (this.hostname.indexOf(64) >= 0) {
                if (this.username == null) {
                    this.username = this.hostname.substring(0, this.hostname.indexOf(64));
                }
                this.hostname = this.hostname.substring(this.hostname.indexOf(64) + 1);
            }
            System.out.println("Connecting to host " + this.hostname + " on port " + this.port);
            if (this.username == null) {
                this.username = (String)this.session.get("USER");
            }
            if (this.username == null) {
                this.log.debug("Prompting user for login");
                if (this.username == null) {
                    this.username = this.session.readLine("Login: ", null);
                }
            }
            SshClient client = SshClient.setUpDefaultClient();
            if (this.session.get("SSH_AUTH_SOCK") != null) {
                client.setAgentFactory((SshAgentFactory)KarafAgentFactory.getInstance());
                String agentSocket = this.session.get("SSH_AUTH_SOCK").toString();
                client.getProperties().put("SSH_AUTH_SOCK", agentSocket);
            }
            KnownHostsManager knownHostsManager = new KnownHostsManager(new File(System.getProperty("user.home"), ".sshkaraf/known_hosts"));
            ServerKeyVerifierImpl serverKeyVerifier = new ServerKeyVerifierImpl(knownHostsManager, this.quiet);
            client.setServerKeyVerifier((ServerKeyVerifier)serverKeyVerifier);
            client.setKeyIdentityProvider((KeyIdentityProvider)new FileKeyPairProvider());
            this.log.debug("Created client: {}", (Object)client);
            client.setUserInteraction(new UserInteraction(){

                public void welcome(ClientSession session, String banner, String lang) {
                    System.out.println(banner);
                }

                public String[] interactive(ClientSession s, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
                    String[] answers = new String[prompt.length];
                    try {
                        for (int i = 0; i < prompt.length; ++i) {
                            answers[i] = SshAction.this.session.readLine(prompt[i] + " ", echo[i] ? null : Character.valueOf('*'));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return answers;
                }

                public boolean isInteractionAllowed(ClientSession session) {
                    return true;
                }

                public void serverVersionInfo(ClientSession session, List<String> lines) {
                }

                public String getUpdatedPassword(ClientSession session, String prompt, String lang) {
                    return null;
                }
            });
            client.start();
            try {
                ClientSession sshSession = SshAction.connectWithRetries(client, this.username, this.hostname, this.port, this.retries);
                Object oldIgnoreInterrupts = this.session.get("karaf.ignoreInterrupts");
                try {
                    ChannelShell channel;
                    if (this.password != null) {
                        sshSession.addPasswordIdentity(this.password);
                    }
                    sshSession.auth().verify();
                    System.out.println("Connected");
                    this.session.put("karaf.ignoreInterrupts", (Object)Boolean.TRUE);
                    StringBuilder sb = new StringBuilder();
                    if (this.command != null) {
                        for (String cmd : this.command) {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append(cmd);
                        }
                    }
                    if (sb.length() > 0) {
                        channel = sshSession.createChannel("exec", sb.append("\n").toString());
                        channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
                        channel.setOut((OutputStream)new NoCloseOutputStream((OutputStream)System.out));
                        channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)System.err));
                        channel.open().verify();
                        channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                        break block25;
                    }
                    if (this.session.getTerminal() != null) {
                        channel = sshSession.createShellChannel();
                        org.jline.terminal.Terminal terminal = (org.jline.terminal.Terminal)this.session.get(".jline.terminal");
                        Attributes attributes = terminal.enterRawMode();
                        try {
                            HashMap<PtyMode, Integer> modes = new HashMap<PtyMode, Integer>();
                            SshAction.addMode(modes, PtyMode.VINTR, attributes, Attributes.ControlChar.VINTR);
                            SshAction.addMode(modes, PtyMode.VQUIT, attributes, Attributes.ControlChar.VQUIT);
                            SshAction.addMode(modes, PtyMode.VERASE, attributes, Attributes.ControlChar.VERASE);
                            SshAction.addMode(modes, PtyMode.VKILL, attributes, Attributes.ControlChar.VKILL);
                            SshAction.addMode(modes, PtyMode.VEOF, attributes, Attributes.ControlChar.VEOF);
                            SshAction.addMode(modes, PtyMode.VEOL, attributes, Attributes.ControlChar.VEOL);
                            SshAction.addMode(modes, PtyMode.VEOL2, attributes, Attributes.ControlChar.VEOL2);
                            SshAction.addMode(modes, PtyMode.VSTART, attributes, Attributes.ControlChar.VSTART);
                            SshAction.addMode(modes, PtyMode.VSTOP, attributes, Attributes.ControlChar.VSTOP);
                            SshAction.addMode(modes, PtyMode.VSUSP, attributes, Attributes.ControlChar.VSUSP);
                            SshAction.addMode(modes, PtyMode.VDSUSP, attributes, Attributes.ControlChar.VDSUSP);
                            SshAction.addMode(modes, PtyMode.VREPRINT, attributes, Attributes.ControlChar.VREPRINT);
                            SshAction.addMode(modes, PtyMode.VWERASE, attributes, Attributes.ControlChar.VWERASE);
                            SshAction.addMode(modes, PtyMode.VLNEXT, attributes, Attributes.ControlChar.VLNEXT);
                            SshAction.addMode(modes, PtyMode.VSTATUS, attributes, Attributes.ControlChar.VSTATUS);
                            SshAction.addMode(modes, PtyMode.VDISCARD, attributes, Attributes.ControlChar.VDISCARD);
                            modes.put(PtyMode.IGNPAR, SshAction.getFlag(attributes, Attributes.InputFlag.IGNPAR));
                            modes.put(PtyMode.PARMRK, SshAction.getFlag(attributes, Attributes.InputFlag.PARMRK));
                            modes.put(PtyMode.INPCK, SshAction.getFlag(attributes, Attributes.InputFlag.INPCK));
                            modes.put(PtyMode.ISTRIP, SshAction.getFlag(attributes, Attributes.InputFlag.ISTRIP));
                            modes.put(PtyMode.INLCR, SshAction.getFlag(attributes, Attributes.InputFlag.INLCR));
                            modes.put(PtyMode.IGNCR, SshAction.getFlag(attributes, Attributes.InputFlag.IGNCR));
                            modes.put(PtyMode.ICRNL, SshAction.getFlag(attributes, Attributes.InputFlag.ICRNL));
                            modes.put(PtyMode.IXON, SshAction.getFlag(attributes, Attributes.InputFlag.IXON));
                            modes.put(PtyMode.IXANY, SshAction.getFlag(attributes, Attributes.InputFlag.IXANY));
                            modes.put(PtyMode.IXOFF, SshAction.getFlag(attributes, Attributes.InputFlag.IXOFF));
                            modes.put(PtyMode.ISIG, SshAction.getFlag(attributes, Attributes.LocalFlag.ISIG));
                            modes.put(PtyMode.ICANON, SshAction.getFlag(attributes, Attributes.LocalFlag.ICANON));
                            modes.put(PtyMode.ECHO, SshAction.getFlag(attributes, Attributes.LocalFlag.ECHO));
                            modes.put(PtyMode.ECHOE, SshAction.getFlag(attributes, Attributes.LocalFlag.ECHOE));
                            modes.put(PtyMode.ECHOK, SshAction.getFlag(attributes, Attributes.LocalFlag.ECHOK));
                            modes.put(PtyMode.ECHONL, SshAction.getFlag(attributes, Attributes.LocalFlag.ECHONL));
                            modes.put(PtyMode.NOFLSH, SshAction.getFlag(attributes, Attributes.LocalFlag.NOFLSH));
                            modes.put(PtyMode.TOSTOP, SshAction.getFlag(attributes, Attributes.LocalFlag.TOSTOP));
                            modes.put(PtyMode.IEXTEN, SshAction.getFlag(attributes, Attributes.LocalFlag.IEXTEN));
                            modes.put(PtyMode.OPOST, SshAction.getFlag(attributes, Attributes.OutputFlag.OPOST));
                            modes.put(PtyMode.ONLCR, SshAction.getFlag(attributes, Attributes.OutputFlag.ONLCR));
                            modes.put(PtyMode.OCRNL, SshAction.getFlag(attributes, Attributes.OutputFlag.OCRNL));
                            modes.put(PtyMode.ONOCR, SshAction.getFlag(attributes, Attributes.OutputFlag.ONOCR));
                            modes.put(PtyMode.ONLRET, SshAction.getFlag(attributes, Attributes.OutputFlag.ONLRET));
                            channel.setPtyModes(modes);
                            channel.setPtyColumns(this.getTermWidth());
                            channel.setPtyLines(this.getTermHeight());
                            channel.setAgentForwarding(true);
                            channel.setEnv("TERM", (Object)this.session.getTerminal().getType());
                            String ctype = (String)this.session.get("LC_CTYPE");
                            if (ctype == null) {
                                ctype = Locale.getDefault().toString() + "." + System.getProperty("input.encoding", Charset.defaultCharset().name());
                            }
                            channel.setEnv("LC_CTYPE", (Object)ctype);
                            channel.setIn((InputStream)new NoCloseInputStream(terminal.input()));
                            channel.setOut((OutputStream)new NoCloseOutputStream(terminal.output()));
                            channel.setErr((OutputStream)new NoCloseOutputStream(terminal.output()));
                            channel.open().verify();
                            Terminal.SignalHandler prevWinchHandler = terminal.handle(Terminal.Signal.WINCH, signal -> {
                                try {
                                    Size size = terminal.getSize();
                                    channel.sendWindowChange(size.getColumns(), size.getRows());
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            });
                            Terminal.SignalHandler prevQuitHandler = terminal.handle(Terminal.Signal.QUIT, signal -> {
                                try {
                                    channel.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VQUIT));
                                    channel.getInvertedIn().flush();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            });
                            Terminal.SignalHandler prevIntHandler = terminal.handle(Terminal.Signal.INT, signal -> {
                                try {
                                    channel.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VINTR));
                                    channel.getInvertedIn().flush();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            });
                            Terminal.SignalHandler prevStopHandler = terminal.handle(Terminal.Signal.TSTP, signal -> {
                                try {
                                    channel.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VDSUSP));
                                    channel.getInvertedIn().flush();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            });
                            try {
                                channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                                break block25;
                            }
                            finally {
                                terminal.handle(Terminal.Signal.WINCH, prevWinchHandler);
                                terminal.handle(Terminal.Signal.INT, prevIntHandler);
                                terminal.handle(Terminal.Signal.TSTP, prevStopHandler);
                                terminal.handle(Terminal.Signal.QUIT, prevQuitHandler);
                            }
                        }
                        finally {
                            terminal.setAttributes(attributes);
                        }
                    }
                    throw new IllegalStateException("No terminal for interactive ssh session");
                }
                finally {
                    this.session.put("karaf.ignoreInterrupts", oldIgnoreInterrupts);
                    sshSession.close(false);
                }
            }
            finally {
                client.stop();
            }
        }
        return null;
    }

    private static void addMode(Map<PtyMode, Integer> modes, PtyMode mode, Attributes attributes, Attributes.ControlChar ctrl) {
        int value = attributes.getControlChar(ctrl);
        if (value != -1) {
            modes.put(mode, value);
        }
    }

    private static int getFlag(Attributes attributes, Attributes.InputFlag flag) {
        return attributes.getInputFlag(flag) ? 1 : 0;
    }

    private static int getFlag(Attributes attributes, Attributes.OutputFlag flag) {
        return attributes.getOutputFlag(flag) ? 1 : 0;
    }

    private static int getFlag(Attributes attributes, Attributes.LocalFlag flag) {
        return attributes.getLocalFlag(flag) ? 1 : 0;
    }

    private int getTermWidth() {
        Terminal term = this.session.getTerminal();
        return term != null ? term.getWidth() : 80;
    }

    private int getTermHeight() {
        Terminal term = this.session.getTerminal();
        return term != null ? term.getHeight() : 25;
    }

    private static ClientSession connectWithRetries(SshClient client, String username, String host, int port, int maxAttempts) throws Exception {
        ClientSession session = null;
        int retries = 0;
        do {
            ConnectFuture future = client.connect(username, host, port);
            future.await();
            try {
                session = (ClientSession)future.getSession();
            }
            catch (Exception ex) {
                if (retries++ < maxAttempts) {
                    Thread.sleep(2000L);
                    System.out.println("retrying (attempt " + retries + ") ...");
                    continue;
                }
                throw ex;
            }
        } while (session == null);
        return session;
    }
}

