/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.karaf.tooling.features.Node;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.logging.Log;

public class ResolutionListenerImpl
implements ResolutionListener {
    private Stack parents = new Stack();
    private Map artifacts = new HashMap();
    private Node rootNode;
    private Log log;

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public void testArtifact(Artifact artifact) {
    }

    public void startProcessChildren(Artifact artifact) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (this.parents.isEmpty()) {
            this.rootNode = node;
        }
        this.parents.push(node);
    }

    public void endProcessChildren(Artifact artifact) {
        Node check = (Node)this.parents.pop();
        assert (artifact.equals(check.getArtifact()));
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        assert (omitted.getDependencyConflictId().equals(kept.getDependencyConflictId()));
        Node node = (Node)this.artifacts.get(omitted.getDependencyConflictId());
        assert (node != null);
        node.setArtifact(kept);
    }

    public void omitForCycle(Artifact artifact) {
    }

    public void includeArtifact(Artifact artifact) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (node == null) {
            node = new Node();
            this.artifacts.put(artifact.getDependencyConflictId(), node);
        }
        node.setArtifact(artifact);
        if (!this.parents.isEmpty()) {
            Node parent = (Node)this.parents.peek();
            parent.getChildren().add(node);
            node.getParents().add(parent);
        }
        if (this.rootNode != null) {
            // empty if block
        }
    }

    protected void print(Node node, String string) {
        for (Node n : node.getChildren()) {
            this.print(n, string + "  ");
        }
    }

    public void updateScope(Artifact artifact, String scope) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        node.getArtifact().setScope(scope);
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (node != null) {
            if (replacement.getVersion() != null) {
                node.getArtifact().setVersion(replacement.getVersion());
            }
            if (replacement.getScope() != null) {
                node.getArtifact().setScope(replacement.getScope());
            }
        }
    }

    public void updateScopeCurrentPom(Artifact artifact, String key) {
        this.getLog().debug((CharSequence)("updateScopeCurrentPom: " + artifact));
    }

    public void selectVersionFromRange(Artifact artifact) {
        this.getLog().debug((CharSequence)("selectVersionFromRange: " + artifact));
    }

    public void restrictRange(Artifact artifact, Artifact artifact1, VersionRange versionRange) {
        this.getLog().debug((CharSequence)("restrictRange: " + artifact));
    }

    public Node getNode(Artifact artifact) {
        return (Node)this.artifacts.get(artifact.getDependencyConflictId());
    }

    public Collection getArtifacts() {
        return this.artifacts.values();
    }

    public Node getRootNode() {
        return this.rootNode;
    }
}

